/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.function.IntFunction;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKeyState;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

abstract class AbstractArrayType<T>
extends Type {
    private final ArrayElementComparator arrayElementComparator;
    private final ArrayElementValueFactory<T> valueFactory;
    final ArrayElementWriter arrayElementWriter;
    private final ArrayElementReader arrayElementReader;
    private final IntFunction<T[]> arrayCreator;
    private final ValueWriter.ArrayType arrayType;

    AbstractArrayType(ValueGroup valueGroup, byte typeId, ArrayElementComparator arrayElementComparator, ArrayElementValueFactory<T> valueFactory, ArrayElementWriter arrayElementWriter, ArrayElementReader arrayElementReader, IntFunction<T[]> arrayCreator, ValueWriter.ArrayType arrayType) {
        super(valueGroup, typeId, null, null);
        this.arrayElementComparator = arrayElementComparator;
        this.valueFactory = valueFactory;
        this.arrayElementWriter = arrayElementWriter;
        this.arrayElementReader = arrayElementReader;
        this.arrayCreator = arrayCreator;
        this.arrayType = arrayType;
    }

    @Override
    final void copyValue(GenericKeyState to, GenericKeyState from) {
        this.copyValue(to, from, from.arrayLength);
    }

    abstract void copyValue(GenericKeyState var1, GenericKeyState var2, int var3);

    abstract void initializeArray(GenericKeyState var1, int var2, ValueWriter.ArrayType var3);

    @Override
    void minimalSplitter(GenericKeyState left, GenericKeyState right, GenericKeyState into) {
        int lastEqualIndex = -1;
        if (left.type == right.type) {
            int maxLength = Integer.min(left.arrayLength, right.arrayLength);
            for (int index = 0; index < maxLength && this.arrayElementComparator.compare(left, right, index) == 0; ++index) {
                ++lastEqualIndex;
            }
        }
        int length = Math.min(right.arrayLength, lastEqualIndex + 2);
        this.copyValue(into, right, length);
        into.arrayLength = length;
    }

    @Override
    int compareValue(GenericKeyState left, GenericKeyState right) {
        if (left.isHighestArray || right.isHighestArray) {
            return Boolean.compare(left.isHighestArray, right.isHighestArray);
        }
        int compare = 0;
        int length = Integer.min(left.arrayLength, right.arrayLength);
        for (int index = 0; compare == 0 && index < length; ++index) {
            compare = this.arrayElementComparator.compare(left, right, index);
        }
        return compare == 0 ? Integer.compare(left.arrayLength, right.arrayLength) : compare;
    }

    @Override
    Value asValue(GenericKeyState state) {
        T[] array = this.arrayCreator.apply(state.arrayLength);
        for (int i = 0; i < state.arrayLength; ++i) {
            array[i] = this.valueFactory.from(state, i);
        }
        return Values.of(array);
    }

    @Override
    void putValue(PageCursor cursor, GenericKeyState state) {
        AbstractArrayType.putArray(cursor, state, this.arrayElementWriter);
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKeyState into) {
        return AbstractArrayType.readArray(cursor, this.arrayType, this.arrayElementReader, into);
    }

    @Override
    void initializeAsLowest(GenericKeyState state) {
        state.initializeArrayMeta(0);
        this.initializeArray(state, 0, this.arrayType);
    }

    @Override
    void initializeAsHighest(GenericKeyState state) {
        state.initializeArrayMeta(0);
        this.initializeArray(state, 0, this.arrayType);
        state.isHighestArray = true;
    }

    int arrayKeySize(GenericKeyState key, int elementSize) {
        return 2 + key.arrayLength * elementSize;
    }

    static void putArrayHeader(PageCursor cursor, short arrayLength) {
        cursor.putShort(arrayLength);
    }

    static void putArrayItems(PageCursor cursor, GenericKeyState key, ArrayElementWriter itemWriter) {
        for (int i = 0; i < key.arrayLength; ++i) {
            itemWriter.write(cursor, key, i);
        }
    }

    static void putArray(PageCursor cursor, GenericKeyState key, ArrayElementWriter writer) {
        AbstractArrayType.putArrayHeader(cursor, GenericKeyState.toNonNegativeShortExact(key.arrayLength));
        AbstractArrayType.putArrayItems(cursor, key, writer);
    }

    static boolean readArray(PageCursor cursor, ValueWriter.ArrayType type, ArrayElementReader reader, GenericKeyState into) {
        if (!AbstractArrayType.setArrayLengthWhenReading(into, cursor, cursor.getShort())) {
            return false;
        }
        into.beginArray(into.arrayLength, type);
        for (int i = 0; i < into.arrayLength; ++i) {
            if (reader.readFrom(cursor, into)) continue;
            return false;
        }
        into.endArray();
        return true;
    }

    static boolean setArrayLengthWhenReading(GenericKeyState state, PageCursor cursor, short arrayLength) {
        state.arrayLength = arrayLength;
        if (state.arrayLength < 0 || state.arrayLength > 4096) {
            GenericKeyState.setCursorException(cursor, "non-valid array length, " + state.arrayLength);
            return false;
        }
        return true;
    }

    @FunctionalInterface
    static interface ArrayElementValueFactory<T> {
        public T from(GenericKeyState var1, int var2);
    }

    @FunctionalInterface
    static interface ArrayElementWriter {
        public void write(PageCursor var1, GenericKeyState var2, int var3);
    }

    @FunctionalInterface
    static interface ArrayElementReader {
        public boolean readFrom(PageCursor var1, GenericKeyState var2);
    }

    @FunctionalInterface
    static interface ArrayElementComparator {
        public int compare(GenericKeyState var1, GenericKeyState var2, int var3);
    }
}

