/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.kernel.api.ExplicitIndex;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.impl.api.ExplicitIndexProvider;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.spi.explicitindex.ExplicitIndexProviderTransaction;
import org.neo4j.kernel.spi.explicitindex.IndexCommandFactory;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;
import org.neo4j.storageengine.api.StorageCommand;

public class ExplicitIndexTransactionStateImpl
implements ExplicitIndexTransactionState,
IndexCommandFactory {
    private final Map<String, ExplicitIndexProviderTransaction> transactions = new HashMap<String, ExplicitIndexProviderTransaction>();
    private final IndexConfigStore indexConfigStore;
    private final ExplicitIndexProvider providerLookup;
    private IndexDefineCommand defineCommand;
    private final Map<String, List<IndexCommand>> nodeCommands = new HashMap<String, List<IndexCommand>>();
    private final Map<String, List<IndexCommand>> relationshipCommands = new HashMap<String, List<IndexCommand>>();

    public ExplicitIndexTransactionStateImpl(IndexConfigStore indexConfigStore, ExplicitIndexProvider explicitIndexProvider) {
        this.indexConfigStore = indexConfigStore;
        this.providerLookup = explicitIndexProvider;
    }

    @Override
    public ExplicitIndex nodeChanges(String indexName) throws ExplicitIndexNotFoundKernelException {
        Map<String, String> configuration = this.indexConfigStore.get(Node.class, indexName);
        if (configuration == null) {
            throw new ExplicitIndexNotFoundKernelException("Node index '" + indexName + " not found", new Object[0]);
        }
        String providerName = configuration.get("provider");
        IndexImplementation provider = this.providerLookup.getProviderByName(providerName);
        ExplicitIndexProviderTransaction transaction = this.transactions.computeIfAbsent(providerName, k -> provider.newTransaction(this));
        return transaction.nodeIndex(indexName, configuration);
    }

    @Override
    public ExplicitIndex relationshipChanges(String indexName) throws ExplicitIndexNotFoundKernelException {
        Map<String, String> configuration = this.indexConfigStore.get(Relationship.class, indexName);
        if (configuration == null) {
            throw new ExplicitIndexNotFoundKernelException("Relationship index '" + indexName + " not found", new Object[0]);
        }
        String providerName = configuration.get("provider");
        IndexImplementation provider = this.providerLookup.getProviderByName(providerName);
        ExplicitIndexProviderTransaction transaction = this.transactions.get(providerName);
        if (transaction == null) {
            transaction = provider.newTransaction(this);
            this.transactions.put(providerName, transaction);
        }
        return transaction.relationshipIndex(indexName, configuration);
    }

    @Override
    public void extractCommands(Collection<StorageCommand> target) {
        if (this.defineCommand != null) {
            target.add(this.defineCommand);
            this.extractCommands(target, this.nodeCommands);
            this.extractCommands(target, this.relationshipCommands);
        }
        for (ExplicitIndexProviderTransaction providerTransaction : this.transactions.values()) {
            providerTransaction.close();
        }
    }

    private void extractCommands(Collection<StorageCommand> target, Map<String, List<IndexCommand>> commandMap) {
        if (commandMap != null) {
            for (List<IndexCommand> commands : commandMap.values()) {
                target.addAll(commands);
            }
        }
    }

    private IndexDefineCommand definitions() {
        if (this.defineCommand == null) {
            this.defineCommand = new IndexDefineCommand();
        }
        return this.defineCommand;
    }

    private void addCommand(String indexName, IndexCommand command) {
        this.addCommand(indexName, command, false);
    }

    private void addCommand(String indexName, IndexCommand command, boolean clearFirst) {
        List commands;
        if (command.getEntityType() == IndexEntityType.Node.id()) {
            commands = this.nodeCommands.computeIfAbsent(indexName, k -> new ArrayList());
        } else if (command.getEntityType() == IndexEntityType.Relationship.id()) {
            commands = this.relationshipCommands.computeIfAbsent(indexName, k -> new ArrayList());
        } else {
            throw new IllegalArgumentException("" + command.getEntityType());
        }
        if (clearFirst) {
            commands.clear();
        }
        commands.add(command);
    }

    @Override
    public void addNode(String indexName, long id, String key, Object value) {
        IndexCommand.AddNodeCommand command = new IndexCommand.AddNodeCommand();
        command.init(this.definitions().getOrAssignIndexNameId(indexName), id, this.definitions().getOrAssignKeyId(key), value);
        this.addCommand(indexName, command);
    }

    @Override
    public void addRelationship(String indexName, long id, String key, Object value, long startNode, long endNode) {
        IndexCommand.AddRelationshipCommand command = new IndexCommand.AddRelationshipCommand();
        command.init(this.definitions().getOrAssignIndexNameId(indexName), id, this.definitions().getOrAssignKeyId(key), value, startNode, endNode);
        this.addCommand(indexName, command);
    }

    @Override
    public void removeNode(String indexName, long id, String keyOrNull, Object valueOrNull) {
        IndexCommand.RemoveCommand command = new IndexCommand.RemoveCommand();
        command.init(this.definitions().getOrAssignIndexNameId(indexName), IndexEntityType.Node.id(), id, this.definitions().getOrAssignKeyId(keyOrNull), valueOrNull);
        this.addCommand(indexName, command);
    }

    @Override
    public void removeRelationship(String indexName, long id, String keyOrNull, Object valueOrNull) {
        IndexCommand.RemoveCommand command = new IndexCommand.RemoveCommand();
        command.init(this.definitions().getOrAssignIndexNameId(indexName), IndexEntityType.Relationship.id(), id, this.definitions().getOrAssignKeyId(keyOrNull), valueOrNull);
        this.addCommand(indexName, command);
    }

    @Override
    public void deleteIndex(IndexEntityType entityType, String indexName) {
        IndexCommand.DeleteCommand command = new IndexCommand.DeleteCommand();
        command.init(this.definitions().getOrAssignIndexNameId(indexName), entityType.id());
        this.addCommand(indexName, command, true);
    }

    @Override
    public void createIndex(IndexEntityType entityType, String indexName, Map<String, String> config) {
        IndexCommand.CreateCommand command = new IndexCommand.CreateCommand();
        command.init(this.definitions().getOrAssignIndexNameId(indexName), entityType.id(), config);
        this.addCommand(indexName, command);
    }

    @Override
    public boolean hasChanges() {
        return this.defineCommand != null;
    }

    @Override
    public boolean checkIndexExistence(IndexEntityType entityType, String indexName, Map<String, String> config) {
        Map<String, String> configuration = this.indexConfigStore.get(entityType.entityClass(), indexName);
        if (configuration == null) {
            return false;
        }
        String providerName = configuration.get("provider");
        IndexImplementation provider = this.providerLookup.getProviderByName(providerName);
        ExplicitIndexStore.assertConfigMatches(provider, indexName, configuration, config);
        return true;
    }
}

