/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.LabelIndexWriterStep;
import org.neo4j.unsafe.impl.batchimport.NodeCountsProcessor;
import org.neo4j.unsafe.impl.batchimport.RecordIdIterator;
import org.neo4j.unsafe.impl.batchimport.RecordProcessorStep;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.staging.BatchFeedStep;
import org.neo4j.unsafe.impl.batchimport.staging.ReadRecordsStep;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class NodeCountsAndLabelIndexBuildStage
extends Stage {
    public static final String NAME = "Node counts and label index build";

    public NodeCountsAndLabelIndexBuildStage(Configuration config, NodeLabelsCache cache, NodeStore nodeStore, int highLabelId, CountsAccessor.Updater countsUpdater, ProgressReporter progressReporter, LabelScanStore labelIndex, StatsProvider ... additionalStatsProviders) {
        super(NAME, null, config, 3);
        this.add(new BatchFeedStep(this.control(), config, RecordIdIterator.allIn(nodeStore, config), nodeStore.getRecordSize()));
        this.add(new ReadRecordsStep<NodeRecord>(this.control(), config, false, nodeStore));
        this.add(new LabelIndexWriterStep(this.control(), config, labelIndex, nodeStore));
        this.add(new RecordProcessorStep<NodeRecord>(this.control(), "COUNT", config, new NodeCountsProcessor(nodeStore, cache, highLabelId, countsUpdater, progressReporter), true, additionalStatsProviders));
    }
}

