/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.util.SortedSet;
import java.util.TreeSet;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.LegacyCredential;

public class User {
    private final String name;
    private final Credential credential;
    private final SortedSet<String> flags;
    public static final String PASSWORD_CHANGE_REQUIRED = "password_change_required";

    private User(String name, Credential credential, SortedSet<String> flags) {
        this.name = name;
        this.credential = credential;
        this.flags = flags;
    }

    public String name() {
        return this.name;
    }

    public Credential credentials() {
        return this.credential;
    }

    public boolean hasFlag(String flag) {
        return this.flags.contains(flag);
    }

    public Iterable<String> getFlags() {
        return this.flags;
    }

    public boolean passwordChangeRequired() {
        return this.flags.contains(PASSWORD_CHANGE_REQUIRED);
    }

    public Builder augment() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        if (!this.flags.equals(user.flags)) {
            return false;
        }
        if (this.credential != null ? !this.credential.equals(user.credential) : user.credential != null) {
            return false;
        }
        return this.name != null ? this.name.equals(user.name) : user.name == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.credential != null ? this.credential.hashCode() : 0);
        result = 31 * result + this.flags.hashCode();
        return result;
    }

    public String toString() {
        return "User{name='" + this.name + '\'' + ", credentials=" + this.credential + ", flags=" + this.flags + '}';
    }

    public static class Builder {
        private String name;
        private Credential credential = LegacyCredential.INACCESSIBLE;
        private TreeSet<String> flags = new TreeSet();

        public Builder() {
        }

        public Builder(String name, Credential credential) {
            this.name = name;
            this.credential = credential;
        }

        public Builder(User base) {
            this.name = base.name;
            this.credential = base.credential;
            this.flags.addAll(base.flags);
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCredentials(Credential creds) {
            this.credential = creds;
            return this;
        }

        public Builder withFlag(String flag) {
            this.flags.add(flag);
            return this;
        }

        public Builder withoutFlag(String flag) {
            this.flags.remove(flag);
            return this;
        }

        public Builder withRequiredPasswordChange(boolean change) {
            if (change) {
                this.withFlag(User.PASSWORD_CHANGE_REQUIRED);
            } else {
                this.withoutFlag(User.PASSWORD_CHANGE_REQUIRED);
            }
            return this;
        }

        public User build() {
            return new User(this.name, this.credential, this.flags);
        }
    }
}

