/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.CapabilityValidator;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.TemporalIndexProvider;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class TemporalIndexPartReader<KEY extends NativeIndexSingleValueKey<KEY>>
extends NativeIndexReader<KEY, NativeIndexValue> {
    TemporalIndexPartReader(GBPTree<KEY, NativeIndexValue> tree, IndexLayout<KEY, NativeIndexValue> layout, IndexSamplingConfig samplingConfig, IndexDescriptor descriptor) {
        super(tree, layout, samplingConfig, descriptor);
    }

    @Override
    protected void validateQuery(IndexOrder indexOrder, IndexQuery[] predicates) {
        if (predicates.length != 1) {
            throw new UnsupportedOperationException();
        }
        CapabilityValidator.validateQuery(TemporalIndexProvider.CAPABILITY, indexOrder, predicates);
    }

    @Override
    protected boolean initializeRangeForQuery(KEY treeKeyFrom, KEY treeKeyTo, IndexQuery[] predicates) {
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exists: {
                ((NativeIndexSingleValueKey)((Object)treeKeyFrom)).initValueAsLowest(ValueGroup.UNKNOWN);
                ((NativeIndexSingleValueKey)((Object)treeKeyTo)).initValueAsHighest(ValueGroup.UNKNOWN);
                break;
            }
            case exact: {
                IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
                ((NativeIndexSingleValueKey)((Object)treeKeyFrom)).from(exactPredicate.value());
                ((NativeIndexSingleValueKey)((Object)treeKeyTo)).from(exactPredicate.value());
                break;
            }
            case range: {
                IndexQuery.RangePredicate rangePredicate = (IndexQuery.RangePredicate)predicate;
                this.initFromForRange(rangePredicate, treeKeyFrom);
                this.initToForRange(rangePredicate, treeKeyTo);
                break;
            }
            default: {
                throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
            }
        }
        return false;
    }

    private void initFromForRange(IndexQuery.RangePredicate<?> rangePredicate, KEY treeKeyFrom) {
        Value fromValue = rangePredicate.fromValue();
        if (fromValue == Values.NO_VALUE) {
            ((NativeIndexSingleValueKey)((Object)treeKeyFrom)).initValueAsLowest(ValueGroup.UNKNOWN);
        } else {
            ((NativeIndexKey)((Object)treeKeyFrom)).initialize(rangePredicate.fromInclusive() ? Long.MIN_VALUE : Long.MAX_VALUE);
            ((NativeIndexSingleValueKey)((Object)treeKeyFrom)).from(fromValue);
            ((NativeIndexKey)((Object)treeKeyFrom)).setCompareId(true);
        }
    }

    private void initToForRange(IndexQuery.RangePredicate<?> rangePredicate, KEY treeKeyTo) {
        Value toValue = rangePredicate.toValue();
        if (toValue == Values.NO_VALUE) {
            ((NativeIndexSingleValueKey)((Object)treeKeyTo)).initValueAsHighest(ValueGroup.UNKNOWN);
        } else {
            ((NativeIndexKey)((Object)treeKeyTo)).initialize(rangePredicate.toInclusive() ? Long.MAX_VALUE : Long.MIN_VALUE);
            ((NativeIndexSingleValueKey)((Object)treeKeyTo)).from(toValue);
            ((NativeIndexKey)((Object)treeKeyTo)).setCompareId(true);
        }
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return true;
    }
}

