/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.CapabilityValidator;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.StringIndexKey;
import org.neo4j.kernel.impl.index.schema.StringIndexProvider;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class StringIndexReader
extends NativeIndexReader<StringIndexKey, NativeIndexValue> {
    StringIndexReader(GBPTree<StringIndexKey, NativeIndexValue> tree, IndexLayout<StringIndexKey, NativeIndexValue> layout, IndexSamplingConfig samplingConfig, IndexDescriptor descriptor) {
        super(tree, layout, samplingConfig, descriptor);
    }

    @Override
    void validateQuery(IndexOrder indexOrder, IndexQuery[] predicates) {
        if (predicates.length != 1) {
            throw new UnsupportedOperationException();
        }
        CapabilityValidator.validateQuery(StringIndexProvider.CAPABILITY, indexOrder, predicates);
    }

    @Override
    boolean initializeRangeForQuery(StringIndexKey treeKeyFrom, StringIndexKey treeKeyTo, IndexQuery[] predicates) {
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exists: {
                treeKeyFrom.initValueAsLowest(ValueGroup.TEXT);
                treeKeyTo.initValueAsHighest(ValueGroup.TEXT);
                return false;
            }
            case exact: {
                IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
                treeKeyFrom.from(exactPredicate.value());
                treeKeyTo.from(exactPredicate.value());
                return false;
            }
            case range: {
                IndexQuery.RangePredicate rangePredicate = (IndexQuery.RangePredicate)predicate;
                StringIndexReader.initFromForRange(rangePredicate, treeKeyFrom);
                StringIndexReader.initToForRange(rangePredicate, treeKeyTo);
                return false;
            }
            case stringPrefix: {
                IndexQuery.StringPrefixPredicate prefixPredicate = (IndexQuery.StringPrefixPredicate)predicate;
                treeKeyFrom.initAsPrefixLow(prefixPredicate.prefix());
                treeKeyTo.initAsPrefixHigh(prefixPredicate.prefix());
                return false;
            }
            case stringSuffix: 
            case stringContains: {
                treeKeyFrom.initValueAsLowest(ValueGroup.TEXT);
                treeKeyTo.initValueAsHighest(ValueGroup.TEXT);
                return true;
            }
        }
        throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
    }

    private static void initFromForRange(IndexQuery.RangePredicate<?> rangePredicate, StringIndexKey treeKeyFrom) {
        Value fromValue = rangePredicate.fromValue();
        if (fromValue == Values.NO_VALUE) {
            treeKeyFrom.initValueAsLowest(ValueGroup.TEXT);
        } else {
            treeKeyFrom.initialize(rangePredicate.fromInclusive() ? Long.MIN_VALUE : Long.MAX_VALUE);
            treeKeyFrom.from(fromValue);
            treeKeyFrom.setCompareId(true);
        }
    }

    private static void initToForRange(IndexQuery.RangePredicate<?> rangePredicate, StringIndexKey treeKeyTo) {
        Value toValue = rangePredicate.toValue();
        if (toValue == Values.NO_VALUE) {
            treeKeyTo.initValueAsHighest(ValueGroup.TEXT);
        } else {
            treeKeyTo.initialize(rangePredicate.toInclusive() ? Long.MAX_VALUE : Long.MIN_VALUE);
            treeKeyTo.from(toValue);
            treeKeyTo.setCompareId(true);
        }
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return true;
    }
}

