/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKeyLengthValidator;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.StringIndexKey;
import org.neo4j.kernel.impl.index.schema.StringIndexReader;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.Value;

public class StringIndexAccessor
extends NativeIndexAccessor<StringIndexKey, NativeIndexValue> {
    private Validator<Value> validator;

    StringIndexAccessor(PageCache pageCache, FileSystemAbstraction fs, File storeFile, IndexLayout<StringIndexKey, NativeIndexValue> layout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        super(pageCache, fs, storeFile, layout, recoveryCleanupWorkCollector, monitor, descriptor, samplingConfig, GBPTree.NO_HEADER_WRITER);
        this.instantiateTree(recoveryCleanupWorkCollector, this.headerWriter);
    }

    @Override
    protected void afterTreeInstantiation(GBPTree<StringIndexKey, NativeIndexValue> tree) {
        this.validator = new NativeIndexKeyLengthValidator(tree.keyValueSizeCap(), this.layout);
    }

    @Override
    public IndexReader newReader() {
        this.assertOpen();
        return new StringIndexReader((GBPTree<StringIndexKey, NativeIndexValue>)this.tree, this.layout, this.samplingConfig, this.descriptor);
    }

    @Override
    public void validateBeforeCommit(Value[] tuple) {
        this.validator.validate(tuple[0]);
    }
}

