/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.List;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.schema.BridgingIndexProgressor;
import org.neo4j.kernel.impl.index.schema.CapabilityValidator;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class GenericNativeIndexReader
extends NativeIndexReader<CompositeGenericKey, NativeIndexValue> {
    private final IndexSpecificSpaceFillingCurveSettingsCache spaceFillingCurveSettings;
    private final SpaceFillingCurveConfiguration configuration;

    GenericNativeIndexReader(GBPTree<CompositeGenericKey, NativeIndexValue> tree, IndexLayout<CompositeGenericKey, NativeIndexValue> layout, IndexSamplingConfig samplingConfig, IndexDescriptor descriptor, IndexSpecificSpaceFillingCurveSettingsCache spaceFillingCurveSettings, SpaceFillingCurveConfiguration configuration) {
        super(tree, layout, samplingConfig, descriptor);
        this.spaceFillingCurveSettings = spaceFillingCurveSettings;
        this.configuration = configuration;
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        for (IndexQuery predicate : predicates) {
            ValueGroup valueGroup = predicate.valueGroup();
            if (valueGroup != ValueGroup.GEOMETRY_ARRAY && valueGroup != ValueGroup.GEOMETRY) continue;
            return false;
        }
        return true;
    }

    @Override
    void validateQuery(IndexOrder indexOrder, IndexQuery[] predicates) {
        CapabilityValidator.validateQuery(GenericNativeIndexProvider.CAPABILITY, indexOrder, predicates);
    }

    @Override
    public void query(IndexProgressor.NodeValueClient client, IndexOrder indexOrder, boolean needsValues, IndexQuery ... query) {
        IndexQuery.GeometryRangePredicate geometryRangePredicate = this.getGeometryRangePredicateIfAny(query);
        if (geometryRangePredicate != null) {
            this.validateQuery(indexOrder, query);
            try {
                BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(client, this.descriptor.schema().getPropertyIds());
                client.initialize(this.descriptor, (IndexProgressor)multiProgressor, query, false);
                double[] from = geometryRangePredicate.from() == null ? null : geometryRangePredicate.from().coordinate();
                double[] to = geometryRangePredicate.to() == null ? null : geometryRangePredicate.to().coordinate();
                CoordinateReferenceSystem crs = geometryRangePredicate.crs();
                SpaceFillingCurve curve = this.spaceFillingCurveSettings.forCrs(crs, false);
                List ranges = curve.getTilesIntersectingEnvelope(from, to, this.configuration);
                for (SpaceFillingCurve.LongRange range : ranges) {
                    CompositeGenericKey treeKeyFrom = (CompositeGenericKey)((Object)this.layout.newKey());
                    CompositeGenericKey treeKeyTo = (CompositeGenericKey)((Object)this.layout.newKey());
                    this.initializeFromToKeys(treeKeyFrom, treeKeyTo);
                    boolean needFiltering = this.initializeRangeForGeometrySubQuery(treeKeyFrom, treeKeyTo, query, crs, range);
                    this.startSeekForInitializedRange(multiProgressor, treeKeyFrom, treeKeyTo, query, needFiltering, needsValues);
                }
            }
            catch (IllegalArgumentException e) {
                client.initialize(this.descriptor, IndexProgressor.EMPTY, query, false);
            }
        } else {
            super.query(client, indexOrder, needsValues, query);
        }
    }

    private boolean initializeRangeForGeometrySubQuery(CompositeGenericKey treeKeyFrom, CompositeGenericKey treeKeyTo, IndexQuery[] query, CoordinateReferenceSystem crs, SpaceFillingCurve.LongRange range) {
        boolean needsFiltering = false;
        block7: for (int i = 0; i < query.length; ++i) {
            IndexQuery predicate = query[i];
            switch (predicate.type()) {
                case exists: {
                    treeKeyFrom.initValueAsLowest(i, ValueGroup.UNKNOWN);
                    treeKeyTo.initValueAsHighest(i, ValueGroup.UNKNOWN);
                    continue block7;
                }
                case exact: {
                    IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
                    treeKeyFrom.initFromValue(i, exactPredicate.value(), NativeIndexKey.Inclusion.NEUTRAL);
                    treeKeyTo.initFromValue(i, exactPredicate.value(), NativeIndexKey.Inclusion.NEUTRAL);
                    continue block7;
                }
                case range: {
                    if (this.isGeometryRangeQuery(predicate)) {
                        treeKeyFrom.initFromDerivedSpatialValue(i, crs, range.min, GenericNativeIndexReader.fromInclusion((IndexQuery.RangePredicate)predicate));
                        treeKeyTo.initFromDerivedSpatialValue(i, crs, range.max + 1L, GenericNativeIndexReader.toInclusion((IndexQuery.RangePredicate)predicate));
                        continue block7;
                    }
                    IndexQuery.RangePredicate rangePredicate = (IndexQuery.RangePredicate)predicate;
                    GenericNativeIndexReader.initFromForRange(i, rangePredicate, treeKeyFrom);
                    GenericNativeIndexReader.initToForRange(i, rangePredicate, treeKeyTo);
                    continue block7;
                }
                case stringPrefix: {
                    IndexQuery.StringPrefixPredicate prefixPredicate = (IndexQuery.StringPrefixPredicate)predicate;
                    treeKeyFrom.initAsPrefixLow(i, prefixPredicate.prefix());
                    treeKeyTo.initAsPrefixHigh(i, prefixPredicate.prefix());
                    continue block7;
                }
                case stringSuffix: 
                case stringContains: {
                    treeKeyFrom.initValueAsLowest(i, ValueGroup.TEXT);
                    treeKeyTo.initValueAsHighest(i, ValueGroup.TEXT);
                    needsFiltering = true;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
                }
            }
        }
        return needsFiltering;
    }

    @Override
    boolean initializeRangeForQuery(CompositeGenericKey treeKeyFrom, CompositeGenericKey treeKeyTo, IndexQuery[] query) {
        return this.initializeRangeForGeometrySubQuery(treeKeyFrom, treeKeyTo, query, null, null);
    }

    private static void initFromForRange(int stateSlot, IndexQuery.RangePredicate<?> rangePredicate, CompositeGenericKey treeKeyFrom) {
        Value fromValue = rangePredicate.fromValue();
        if (fromValue == Values.NO_VALUE) {
            treeKeyFrom.initValueAsLowest(stateSlot, ValueGroup.UNKNOWN);
        } else {
            treeKeyFrom.initFromValue(stateSlot, fromValue, GenericNativeIndexReader.fromInclusion(rangePredicate));
            treeKeyFrom.setCompareId(true);
        }
    }

    private static void initToForRange(int stateSlot, IndexQuery.RangePredicate<?> rangePredicate, CompositeGenericKey treeKeyTo) {
        Value toValue = rangePredicate.toValue();
        if (toValue == Values.NO_VALUE) {
            treeKeyTo.initValueAsHighest(stateSlot, ValueGroup.UNKNOWN);
        } else {
            treeKeyTo.initFromValue(stateSlot, toValue, GenericNativeIndexReader.toInclusion(rangePredicate));
            treeKeyTo.setCompareId(true);
        }
    }

    private static NativeIndexKey.Inclusion fromInclusion(IndexQuery.RangePredicate<?> rangePredicate) {
        return rangePredicate.fromInclusive() ? NativeIndexKey.Inclusion.LOW : NativeIndexKey.Inclusion.HIGH;
    }

    private static NativeIndexKey.Inclusion toInclusion(IndexQuery.RangePredicate<?> rangePredicate) {
        return rangePredicate.toInclusive() ? NativeIndexKey.Inclusion.HIGH : NativeIndexKey.Inclusion.LOW;
    }

    private IndexQuery.GeometryRangePredicate getGeometryRangePredicateIfAny(IndexQuery[] predicates) {
        for (IndexQuery predicate : predicates) {
            if (!this.isGeometryRangeQuery(predicate)) continue;
            return (IndexQuery.GeometryRangePredicate)predicate;
        }
        return null;
    }

    private boolean isGeometryRangeQuery(IndexQuery predicate) {
        return predicate instanceof IndexQuery.GeometryRangePredicate;
    }
}

