/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.GenericIndexKeyValidator;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsWriter;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.Value;

class GenericNativeIndexAccessor
extends NativeIndexAccessor<CompositeGenericKey, NativeIndexValue> {
    private final IndexSpecificSpaceFillingCurveSettingsCache spaceFillingCurveSettings;
    private final SpaceFillingCurveConfiguration configuration;
    private Validator<Value[]> validator;

    GenericNativeIndexAccessor(PageCache pageCache, FileSystemAbstraction fs, File storeFile, IndexLayout<CompositeGenericKey, NativeIndexValue> layout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, IndexSpecificSpaceFillingCurveSettingsCache spaceFillingCurveSettings, SpaceFillingCurveConfiguration configuration) throws IOException {
        super(pageCache, fs, storeFile, layout, recoveryCleanupWorkCollector, monitor, descriptor, samplingConfig, new SpaceFillingCurveSettingsWriter(spaceFillingCurveSettings));
        this.spaceFillingCurveSettings = spaceFillingCurveSettings;
        this.configuration = configuration;
        this.instantiateTree(recoveryCleanupWorkCollector, this.headerWriter);
    }

    @Override
    protected void afterTreeInstantiation(GBPTree<CompositeGenericKey, NativeIndexValue> tree) {
        this.validator = new GenericIndexKeyValidator(tree.keyValueSizeCap(), (Layout<CompositeGenericKey, NativeIndexValue>)this.layout, this.spaceFillingCurveSettings, this.pageCache.pageSize());
    }

    @Override
    public IndexReader newReader() {
        return new GenericNativeIndexReader((GBPTree<CompositeGenericKey, NativeIndexValue>)this.tree, this.layout, this.samplingConfig, this.descriptor, this.spaceFillingCurveSettings, this.configuration);
    }

    @Override
    public void validateBeforeCommit(Value[] tuple) {
        this.validator.validate(tuple);
    }

    @Override
    public void force(IOLimiter ioLimiter) {
        this.tree.checkpoint(ioLimiter, (Consumer)this.headerWriter);
    }
}

