/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.ssl;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Group;
import org.neo4j.kernel.configuration.GroupSettingSupport;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.ssl.ClientAuth;

@Group(value="dbms.ssl.policy")
public class SslPolicyConfig
implements LoadableConfig {
    public static final List<String> TLS_VERSION_DEFAULTS = Collections.singletonList("TLSv1.2");
    public static final List<String> CIPHER_SUITES_DEFAULTS = null;
    @Description(value="The mandatory base directory for cryptographic objects of this policy. It is also possible to override each individual configuration with absolute paths.")
    public final Setting<File> base_directory;
    @Description(value="Allows the generation of a private key and associated self-signed certificate. Only performed when both objects cannot be found.")
    public final Setting<Boolean> allow_key_generation;
    @Description(value="Makes this policy trust all remote parties. Enabling this is not recommended and the trusted directory will be ignored.")
    public final Setting<Boolean> trust_all;
    @Description(value="Private PKCS#8 key in PEM format.")
    public final Setting<File> private_key;
    @Internal
    @Description(value="The password for the private key.")
    public final Setting<String> private_key_password;
    @Description(value="X.509 certificate (chain) of this server in PEM format.")
    public final Setting<File> public_certificate;
    @Description(value="Path to directory of X.509 certificates in PEM format for trusted parties.")
    public final Setting<File> trusted_dir;
    @Description(value="Path to directory of CRLs (Certificate Revocation Lists) in PEM format.")
    public final Setting<File> revoked_dir;
    @Description(value="Client authentication stance.")
    public final Setting<ClientAuth> client_auth;
    @Description(value="Restrict allowed TLS protocol versions.")
    public final Setting<List<String>> tls_versions;
    @Description(value="Restrict allowed ciphers.")
    public final Setting<List<String>> ciphers;
    @Description(value="When true, this node will verify the hostname of every other instance it connects to by comparing the address it used to connect with it and the patterns described in the remote hosts public certificate Subject Alternative Names")
    public final Setting<Boolean> verify_hostname;

    public SslPolicyConfig() {
        this("<policyname>");
    }

    public SslPolicyConfig(String policyName) {
        GroupSettingSupport group = new GroupSettingSupport(SslPolicyConfig.class, policyName);
        this.base_directory = group.scope(Settings.pathSetting("base_directory", Settings.NO_DEFAULT));
        this.allow_key_generation = group.scope(Settings.setting("allow_key_generation", Settings.BOOLEAN, "false"));
        this.trust_all = group.scope(Settings.setting("trust_all", Settings.BOOLEAN, "false"));
        this.private_key = group.scope(this.derivedDefault("private_key", this.base_directory, "private.key"));
        this.public_certificate = group.scope(this.derivedDefault("public_certificate", this.base_directory, "public.crt"));
        this.trusted_dir = group.scope(this.derivedDefault("trusted_dir", this.base_directory, "trusted"));
        this.revoked_dir = group.scope(this.derivedDefault("revoked_dir", this.base_directory, "revoked"));
        this.private_key_password = group.scope(Settings.setting("private_key_password", Settings.STRING, Settings.NO_DEFAULT));
        this.client_auth = group.scope(Settings.setting("client_auth", Settings.options(ClientAuth.class, true), ClientAuth.REQUIRE.name()));
        this.tls_versions = group.scope(Settings.setting("tls_versions", Settings.STRING_LIST, this.joinList(TLS_VERSION_DEFAULTS)));
        this.ciphers = group.scope(Settings.setting("ciphers", Settings.STRING_LIST, this.joinList(CIPHER_SUITES_DEFAULTS)));
        this.verify_hostname = group.scope(Settings.setting("verify_hostname", Settings.BOOLEAN, "false"));
    }

    private Setting<File> derivedDefault(String settingName, Setting<File> baseDirectory, String defaultFilename) {
        return Settings.derivedSetting(settingName, baseDirectory, base -> new File((File)base, defaultFilename), Settings.PATH);
    }

    private String joinList(List<String> list) {
        if (list == null) {
            return null;
        }
        return String.join((CharSequence)",", list);
    }
}

