/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.state.storeview.PropertyAwareEntityStoreScan;

public class StoreViewNodeStoreScan<FAILURE extends Exception>
extends PropertyAwareEntityStoreScan<NodeRecord, FAILURE> {
    private final NodeStore nodeStore;
    private final Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor;
    private final Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor;
    protected final int[] labelIds;

    public StoreViewNodeStoreScan(NodeStore nodeStore, LockService locks, PropertyStore propertyStore, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, int[] labelIds, IntPredicate propertyKeyIdFilter) {
        super(nodeStore, propertyStore, propertyKeyIdFilter, id -> locks.acquireNodeLock(id, LockService.LockType.READ_LOCK));
        this.nodeStore = nodeStore;
        this.labelUpdateVisitor = labelUpdateVisitor;
        this.propertyUpdatesVisitor = propertyUpdatesVisitor;
        this.labelIds = labelIds;
    }

    @Override
    public void process(NodeRecord node) throws FAILURE {
        EntityUpdates.Builder updates;
        long[] labels = NodeLabelsField.parseLabelsField(node).get(this.nodeStore);
        if (labels.length == 0 && this.labelIds.length != 0) {
            return;
        }
        if (this.labelUpdateVisitor != null) {
            this.labelUpdateVisitor.visit((Object)NodeLabelUpdate.labelChanges(node.getId(), PrimitiveLongCollections.EMPTY_LONG_ARRAY, labels));
        }
        if (this.propertyUpdatesVisitor != null && StoreViewNodeStoreScan.containsAnyEntityToken(this.labelIds, labels) && this.hasRelevantProperty(node, updates = EntityUpdates.forEntity(node.getId()).withTokens(labels))) {
            this.propertyUpdatesVisitor.visit((Object)updates.build());
        }
    }
}

