/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordNodeCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReader;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.format.CapabilityType;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.ReadOnlyIdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.DirectRecordStoreMigrator;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.participant.AbstractStoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.participant.StoreMigratorFileOperation;
import org.neo4j.kernel.impl.storemigration.participant.StoreScanAsInputIterator;
import org.neo4j.kernel.impl.storemigration.participant.StoreScanChunk;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.impl.util.monitoring.SilentProgressReporter;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.BatchImporterFactory;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappers;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.unsafe.impl.batchimport.staging.CoarseBoundedProgressExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;

public class StoreMigrator
extends AbstractStoreMigrationParticipant {
    private static final char TX_LOG_COUNTERS_SEPARATOR = 'A';
    private final Config config;
    private final LogService logService;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;

    public StoreMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, Config config, LogService logService) {
        super("Store files");
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
        this.logService = logService;
    }

    @Override
    public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progressReporter, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        File neoStore = directoryLayout.metadataStore();
        long lastTxId = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
        TransactionId lastTxInfo = this.extractTransactionIdInformation(neoStore, lastTxId);
        LogPosition lastTxLogPosition = this.extractTransactionLogPosition(neoStore, directoryLayout, lastTxId);
        this.writeLastTxInformation(migrationLayout, lastTxInfo);
        this.writeLastTxLogPosition(migrationLayout, lastTxLogPosition);
        if (versionToMigrateFrom.equals("vE.H.0")) {
            versionToMigrateFrom = "vE.H.0b";
        }
        RecordFormats oldFormat = RecordFormatSelector.selectForVersion(versionToMigrateFrom);
        RecordFormats newFormat = RecordFormatSelector.selectForVersion(versionToMigrateTo);
        if (FormatFamily.isHigherFamilyFormat(newFormat, oldFormat) || FormatFamily.isSameFamily(oldFormat, newFormat) && StoreMigrator.isDifferentCapabilities(oldFormat, newFormat)) {
            this.migrateWithBatchImporter(directoryLayout, migrationLayout, lastTxId, lastTxInfo.checksum(), lastTxLogPosition.getLogVersion(), lastTxLogPosition.getByteOffset(), progressReporter, oldFormat, newFormat);
        }
        LogPosition logPosition = this.readLastTxLogPosition(migrationLayout);
        this.updateOrAddNeoStoreFieldsAsPartOfMigration(migrationLayout, directoryLayout, versionToMigrateTo, logPosition);
    }

    private static boolean isDifferentCapabilities(RecordFormats oldFormat, RecordFormats newFormat) {
        return !oldFormat.hasCompatibleCapabilities(newFormat, CapabilityType.FORMAT);
    }

    void writeLastTxInformation(DatabaseLayout migrationStructure, TransactionId txInfo) throws IOException {
        StoreMigrator.writeTxLogCounters(this.fileSystem, StoreMigrator.lastTxInformationFile(migrationStructure), txInfo.transactionId(), txInfo.checksum(), txInfo.commitTimestamp());
    }

    void writeLastTxLogPosition(DatabaseLayout migrationStructure, LogPosition lastTxLogPosition) throws IOException {
        StoreMigrator.writeTxLogCounters(this.fileSystem, StoreMigrator.lastTxLogPositionFile(migrationStructure), lastTxLogPosition.getLogVersion(), lastTxLogPosition.getByteOffset());
    }

    TransactionId readLastTxInformation(DatabaseLayout migrationStructure) throws IOException {
        long[] counters = StoreMigrator.readTxLogCounters(this.fileSystem, StoreMigrator.lastTxInformationFile(migrationStructure), 3);
        return new TransactionId(counters[0], counters[1], counters[2]);
    }

    LogPosition readLastTxLogPosition(DatabaseLayout migrationStructure) throws IOException {
        long[] counters = StoreMigrator.readTxLogCounters(this.fileSystem, StoreMigrator.lastTxLogPositionFile(migrationStructure), 2);
        return new LogPosition(counters[0], counters[1]);
    }

    private static void writeTxLogCounters(FileSystemAbstraction fs, File file, long ... counters) throws IOException {
        try (Writer writer = fs.openAsWriter(file, StandardCharsets.UTF_8, false);){
            writer.write(StringUtils.join((long[])counters, (char)'A'));
        }
    }

    private static long[] readTxLogCounters(FileSystemAbstraction fs, File file, int numberOfCounters) throws IOException {
        try (BufferedReader reader = new BufferedReader(fs.openAsReader(file, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            String[] split = StringUtils.split((String)line, (char)'A');
            if (split.length != numberOfCounters) {
                throw new IllegalArgumentException("Unexpected number of tx counters '" + numberOfCounters + "', file contains: '" + line + "'");
            }
            long[] counters = new long[numberOfCounters];
            for (int i = 0; i < split.length; ++i) {
                counters[i] = Long.parseLong(split[i]);
            }
            long[] lArray = counters;
            return lArray;
        }
    }

    private static File lastTxInformationFile(DatabaseLayout migrationStructure) {
        return migrationStructure.file("lastxinformation");
    }

    private static File lastTxLogPositionFile(DatabaseLayout migrationStructure) {
        return migrationStructure.file("lastxlogposition");
    }

    TransactionId extractTransactionIdInformation(File neoStore, long lastTransactionId) throws IOException {
        long checksum = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM);
        long commitTimestamp = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP);
        if (checksum != -1L && commitTimestamp != -1L) {
            return new TransactionId(lastTransactionId, checksum, commitTimestamp);
        }
        return StoreMigrator.specificTransactionInformationSupplier(lastTransactionId);
    }

    private static TransactionId specificTransactionInformationSupplier(long lastTransactionId) {
        return lastTransactionId == 1L ? new TransactionId(lastTransactionId, 0L, 0L) : new TransactionId(lastTransactionId, 1L, 1L);
    }

    LogPosition extractTransactionLogPosition(File neoStore, DatabaseLayout sourceDirectoryStructure, long lastTxId) throws IOException {
        long lastClosedTxLogVersion = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION);
        long lastClosedTxLogByteOffset = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
        if (lastClosedTxLogVersion != -1L && lastClosedTxLogByteOffset != -1L) {
            return new LogPosition(lastClosedTxLogVersion, lastClosedTxLogByteOffset);
        }
        if (lastTxId == 1L) {
            return new LogPosition(0L, 16L);
        }
        LogFiles logFiles = LogFilesBuilder.activeFilesBuilder(sourceDirectoryStructure, this.fileSystem, this.pageCache).withConfig(this.config).build();
        long logVersion = logFiles.getHighestLogVersion();
        if (logVersion == -1L) {
            return new LogPosition(0L, 16L);
        }
        long offset = this.fileSystem.getFileSize(logFiles.getHighestLogFile());
        return new LogPosition(logVersion, offset);
    }

    private void migrateWithBatchImporter(final DatabaseLayout sourceDirectoryStructure, DatabaseLayout migrationDirectoryStructure, long lastTxId, long lastTxChecksum, long lastTxLogVersion, long lastTxLogByteOffset, ProgressReporter progressReporter, RecordFormats oldFormat, RecordFormats newFormat) throws IOException {
        this.prepareBatchImportMigration(sourceDirectoryStructure, migrationDirectoryStructure, oldFormat, newFormat);
        boolean requiresDynamicStoreMigration = !newFormat.dynamic().equals(oldFormat.dynamic());
        boolean requiresPropertyMigration = !newFormat.property().equals(oldFormat.property()) || requiresDynamicStoreMigration;
        File badFile = sourceDirectoryStructure.file("bad.log");
        try (NeoStores legacyStore = this.instantiateLegacyStore(oldFormat, sourceDirectoryStructure);
             BufferedOutputStream badOutput = new BufferedOutputStream(new FileOutputStream(badFile, false));){
            Configuration.Overridden importConfig = new Configuration.Overridden(this.config){

                @Override
                public boolean highIO() {
                    return FileUtils.highIODevice((Path)sourceDirectoryStructure.databaseDirectory().toPath(), (boolean)super.highIO());
                }
            };
            AdditionalInitialIds additionalInitialIds = StoreMigrator.readAdditionalIds(lastTxId, lastTxChecksum, lastTxLogVersion, lastTxLogByteOffset);
            BatchImporter importer = BatchImporterFactory.withHighestPriority().instantiate(migrationDirectoryStructure, this.fileSystem, this.pageCache, importConfig, this.logService, ExecutionSupervisors.withDynamicProcessorAssignment(StoreMigrator.migrationBatchImporterMonitor(legacyStore, progressReporter, importConfig), importConfig), additionalInitialIds, this.config, newFormat, ImportLogic.NO_MONITOR);
            InputIterable nodes = () -> StoreMigrator.legacyNodesAsInput(legacyStore, requiresPropertyMigration);
            InputIterable relationships = () -> StoreMigrator.legacyRelationshipsAsInput(legacyStore, requiresPropertyMigration);
            long propertyStoreSize = StoreMigrator.storeSize(legacyStore.getPropertyStore()) / 2L + StoreMigrator.storeSize(legacyStore.getPropertyStore().getStringStore()) / 2L + StoreMigrator.storeSize(legacyStore.getPropertyStore().getArrayStore()) / 2L;
            Input.Estimates estimates = Inputs.knownEstimates(legacyStore.getNodeStore().getNumberOfIdsInUse(), legacyStore.getRelationshipStore().getNumberOfIdsInUse(), legacyStore.getPropertyStore().getNumberOfIdsInUse(), legacyStore.getPropertyStore().getNumberOfIdsInUse(), propertyStoreSize / 2L, propertyStoreSize / 2L, 0L);
            importer.doImport(Inputs.input(nodes, relationships, IdMappers.actual(), Collectors.badCollector(badOutput, 0L), estimates));
            ArrayList<DatabaseFile> storesToDeleteFromMigratedDirectory = new ArrayList<DatabaseFile>();
            storesToDeleteFromMigratedDirectory.add(DatabaseFile.METADATA_STORE);
            if (!requiresPropertyMigration) {
                storesToDeleteFromMigratedDirectory.addAll(Arrays.asList(DatabaseFile.PROPERTY_STORE, DatabaseFile.PROPERTY_STRING_STORE, DatabaseFile.PROPERTY_ARRAY_STORE));
            }
            if (!requiresDynamicStoreMigration) {
                storesToDeleteFromMigratedDirectory.addAll(Arrays.asList(DatabaseFile.NODE_LABEL_STORE, DatabaseFile.LABEL_TOKEN_STORE, DatabaseFile.LABEL_TOKEN_NAMES_STORE, DatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, DatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, DatabaseFile.PROPERTY_KEY_TOKEN_STORE, DatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, DatabaseFile.SCHEMA_STORE));
            }
            StoreMigratorFileOperation.fileOperation(FileOperation.DELETE, this.fileSystem, migrationDirectoryStructure, migrationDirectoryStructure, storesToDeleteFromMigratedDirectory, true, null);
        }
    }

    private static long storeSize(CommonAbstractStore<? extends AbstractBaseRecord, ? extends StoreHeader> store) {
        return store.getNumberOfIdsInUse() * (long)store.getRecordSize();
    }

    private NeoStores instantiateLegacyStore(RecordFormats format, DatabaseLayout directoryStructure) {
        return new StoreFactory(directoryStructure, this.config, new ReadOnlyIdGeneratorFactory(), this.pageCache, this.fileSystem, format, (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY, new OpenOption[0]).openAllNeoStores(true);
    }

    private void prepareBatchImportMigration(DatabaseLayout sourceDirectoryStructure, DatabaseLayout migrationStrcuture, RecordFormats oldFormat, RecordFormats newFormat) throws IOException {
        this.createStore(migrationStrcuture, newFormat);
        DatabaseFile[] storesFilesToMigrate = new DatabaseFile[]{DatabaseFile.LABEL_TOKEN_STORE, DatabaseFile.LABEL_TOKEN_NAMES_STORE, DatabaseFile.PROPERTY_KEY_TOKEN_STORE, DatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, DatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, DatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, DatabaseFile.NODE_LABEL_STORE};
        if (newFormat.dynamic().equals(oldFormat.dynamic())) {
            StoreMigratorFileOperation.fileOperation(FileOperation.COPY, this.fileSystem, sourceDirectoryStructure, migrationStrcuture, Arrays.asList(storesFilesToMigrate), true, ExistingTargetStrategy.FAIL);
        } else {
            DirectRecordStoreMigrator migrator = new DirectRecordStoreMigrator(this.pageCache, this.fileSystem, this.config);
            StoreType[] storesToMigrate = new StoreType[]{StoreType.LABEL_TOKEN, StoreType.LABEL_TOKEN_NAME, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY_KEY_TOKEN_NAME, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN_NAME, StoreType.NODE_LABEL, StoreType.SCHEMA};
            SilentProgressReporter progressReporter = SilentProgressReporter.INSTANCE;
            migrator.migrate(sourceDirectoryStructure, oldFormat, migrationStrcuture, newFormat, progressReporter, storesToMigrate, StoreType.NODE);
        }
    }

    private void createStore(DatabaseLayout migrationDirectoryStructure, RecordFormats newFormat) {
        ReadOnlyIdGeneratorFactory idGeneratorFactory = new ReadOnlyIdGeneratorFactory(this.fileSystem);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        StoreFactory storeFactory = new StoreFactory(migrationDirectoryStructure, this.config, idGeneratorFactory, this.pageCache, this.fileSystem, newFormat, (LogProvider)logProvider, EmptyVersionContextSupplier.EMPTY, new OpenOption[0]);
        try (NeoStores neoStores = storeFactory.openAllNeoStores(true);){
            neoStores.getMetaDataStore();
            neoStores.getLabelTokenStore();
            neoStores.getNodeStore();
            neoStores.getPropertyStore();
            neoStores.getRelationshipGroupStore();
            neoStores.getRelationshipStore();
            neoStores.getSchemaStore();
        }
    }

    private static AdditionalInitialIds readAdditionalIds(final long lastTxId, final long lastTxChecksum, final long lastTxLogVersion, final long lastTxLogByteOffset) {
        return new AdditionalInitialIds(){

            @Override
            public long lastCommittedTransactionId() {
                return lastTxId;
            }

            @Override
            public long lastCommittedTransactionChecksum() {
                return lastTxChecksum;
            }

            @Override
            public long lastCommittedTransactionLogVersion() {
                return lastTxLogVersion;
            }

            @Override
            public long lastCommittedTransactionLogByteOffset() {
                return lastTxLogByteOffset;
            }
        };
    }

    private static ExecutionMonitor migrationBatchImporterMonitor(NeoStores legacyStore, ProgressReporter progressReporter, Configuration config) {
        return new BatchImporterProgressMonitor(legacyStore.getNodeStore().getHighId(), legacyStore.getRelationshipStore().getHighId(), config, progressReporter);
    }

    private static InputIterator legacyRelationshipsAsInput(final NeoStores legacyStore, final boolean requiresPropertyMigration) {
        return new StoreScanAsInputIterator<RelationshipRecord>((RecordStore)legacyStore.getRelationshipStore()){

            @Override
            public InputChunk newChunk() {
                return new RelationshipRecordChunk(new RecordStorageReader(legacyStore), requiresPropertyMigration);
            }
        };
    }

    private static InputIterator legacyNodesAsInput(final NeoStores legacyStore, final boolean requiresPropertyMigration) {
        return new StoreScanAsInputIterator<NodeRecord>((RecordStore)legacyStore.getNodeStore()){

            @Override
            public InputChunk newChunk() {
                return new NodeRecordChunk(new RecordStorageReader(legacyStore), requiresPropertyMigration);
            }
        };
    }

    @Override
    public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToUpgradeFrom, String versionToUpgradeTo) throws IOException {
        StoreMigratorFileOperation.fileOperation(FileOperation.MOVE, this.fileSystem, migrationLayout, directoryLayout, Iterables.iterable((Object[])DatabaseFile.values()), true, ExistingTargetStrategy.OVERWRITE);
    }

    private void updateOrAddNeoStoreFieldsAsPartOfMigration(DatabaseLayout migrationStructure, DatabaseLayout sourceDirectoryStructure, String versionToMigrateTo, LogPosition lastClosedTxLogPosition) throws IOException {
        File storeDirNeoStore = sourceDirectoryStructure.metadataStore();
        File migrationDirNeoStore = migrationStructure.metadataStore();
        StoreMigratorFileOperation.fileOperation(FileOperation.COPY, this.fileSystem, sourceDirectoryStructure, migrationStructure, Iterables.iterable((Object[])new DatabaseFile[]{DatabaseFile.METADATA_STORE}), true, ExistingTargetStrategy.SKIP);
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_ID, MetaDataStore.getRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_ID));
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.UPGRADE_TIME, System.currentTimeMillis());
        TransactionId lastTxInfo = this.readLastTxInformation(migrationStructure);
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, lastTxInfo.checksum());
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM, lastTxInfo.checksum());
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, lastTxInfo.commitTimestamp());
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, lastTxInfo.commitTimestamp());
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, lastClosedTxLogPosition.getLogVersion());
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, lastClosedTxLogPosition.getByteOffset());
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.STORE_VERSION, MetaDataStore.versionStringToLong(versionToMigrateTo));
    }

    @Override
    public void cleanup(DatabaseLayout migrationLayout) throws IOException {
        this.fileSystem.deleteRecursively(migrationLayout.databaseDirectory());
    }

    public String toString() {
        return "Kernel StoreMigrator";
    }

    private static class BatchImporterProgressMonitor
    extends CoarseBoundedProgressExecutionMonitor {
        private final ProgressReporter progressReporter;

        BatchImporterProgressMonitor(long highNodeId, long highRelationshipId, Configuration configuration, ProgressReporter progressReporter) {
            super(highNodeId, highRelationshipId, configuration);
            this.progressReporter = progressReporter;
            this.progressReporter.start(this.total());
        }

        @Override
        protected void progress(long progress) {
            this.progressReporter.progress(progress);
        }
    }

    private static class RelationshipRecordChunk
    extends StoreScanChunk<StorageRelationshipScanCursor> {
        RelationshipRecordChunk(RecordStorageReader storageReader, boolean requiresPropertyMigration) {
            super(storageReader.allocateRelationshipScanCursor(), storageReader, requiresPropertyMigration);
        }

        @Override
        protected void read(StorageRelationshipScanCursor cursor, long id) {
            cursor.single(id);
        }

        @Override
        protected void visitRecord(StorageRelationshipScanCursor record, InputEntityVisitor visitor) {
            visitor.startId(record.sourceNodeReference());
            visitor.endId(record.targetNodeReference());
            visitor.type(record.type());
            this.visitProperties(record, visitor);
        }
    }

    private static class NodeRecordChunk
    extends StoreScanChunk<RecordNodeCursor> {
        NodeRecordChunk(RecordStorageReader storageReader, boolean requiresPropertyMigration) {
            super(storageReader.allocateNodeCursor(), storageReader, requiresPropertyMigration);
        }

        @Override
        protected void read(RecordNodeCursor cursor, long id) {
            cursor.single(id);
        }

        @Override
        protected void visitRecord(RecordNodeCursor record, InputEntityVisitor visitor) {
            visitor.id(record.nodeReference());
            visitor.labelField(record.getLabelField());
            this.visitProperties(record, visitor);
        }
    }
}

