/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_2_10;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_2_4;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV3_0;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV3_0_2;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.storageengine.api.CommandReader;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class RecordStorageCommandReaderFactory
implements CommandReaderFactory {
    private final CommandReader[] readers = new CommandReader[11];

    public RecordStorageCommandReaderFactory() {
        LogEntryVersion[] versions;
        this.readers[-LogEntryVersion.V2_3.byteCode()] = new PhysicalLogCommandReaderV2_2_4();
        this.readers[-LogEntryVersion.V3_0.byteCode()] = new PhysicalLogCommandReaderV3_0();
        this.readers[-LogEntryVersion.V2_3_5.byteCode()] = new PhysicalLogCommandReaderV2_2_10();
        this.readers[-LogEntryVersion.V3_0_2.byteCode()] = new PhysicalLogCommandReaderV3_0_2();
        this.readers[-LogEntryVersion.V3_0_10.byteCode()] = new PhysicalLogCommandReaderV3_0_2();
        for (LogEntryVersion version : versions = LogEntryVersion.values()) {
            CommandReader versionReader = this.readers[Math.abs(version.byteCode())];
            if (versionReader != null) continue;
            throw new IllegalStateException("Version " + (Object)((Object)version) + " not handled");
        }
    }

    public CommandReader byVersion(byte version) {
        byte key = (byte)Math.abs(version);
        if (key >= this.readers.length) {
            throw new IllegalArgumentException("Unsupported version:" + version);
        }
        return this.readers[key];
    }
}

