/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.values.storable.ValueGroup;

class GenericLayout
extends IndexLayout<CompositeGenericKey> {
    static final Comparator<Type> TYPE_COMPARATOR;
    private final int numberOfSlots;
    static final Type[] TYPES;
    static final Type[] TYPE_BY_ID;
    static final Type LOWEST_TYPE_BY_VALUE_GROUP;
    static final Type HIGHEST_TYPE_BY_VALUE_GROUP;
    static final Type[] TYPE_BY_GROUP;

    GenericLayout(int numberOfSlots) {
        super("NSIL", 0, 1);
        this.numberOfSlots = numberOfSlots;
    }

    public CompositeGenericKey newKey() {
        return new CompositeGenericKey(this.numberOfSlots);
    }

    public CompositeGenericKey copyKey(CompositeGenericKey key, CompositeGenericKey into) {
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        into.copyValuesFrom(key);
        return into;
    }

    public int keySize(CompositeGenericKey key) {
        return key.size();
    }

    public void writeKey(PageCursor cursor, CompositeGenericKey key) {
        key.write(cursor);
    }

    public void readKey(PageCursor cursor, CompositeGenericKey into, int keySize) {
        into.read(cursor, keySize);
    }

    @Override
    public boolean fixedSize() {
        return false;
    }

    public void minimalSplitter(CompositeGenericKey left, CompositeGenericKey right, CompositeGenericKey into) {
        CompositeGenericKey.minimalSplitter(left, right, into);
    }

    static {
        Type type;
        int n;
        TYPE_COMPARATOR = Comparator.comparing(t -> ((Type)t).valueGroup);
        TYPES = Type.values();
        TYPE_BY_ID = new Type[TYPES.length];
        LOWEST_TYPE_BY_VALUE_GROUP = Collections.min(Arrays.asList(TYPES), TYPE_COMPARATOR);
        HIGHEST_TYPE_BY_VALUE_GROUP = Collections.max(Arrays.asList(TYPES), TYPE_COMPARATOR);
        TYPE_BY_GROUP = new Type[ValueGroup.values().length];
        Type[] typeArray = TYPES;
        int n2 = typeArray.length;
        for (n = 0; n < n2; ++n) {
            GenericLayout.TYPE_BY_ID[type.typeId] = type = typeArray[n];
        }
        typeArray = TYPES;
        n2 = typeArray.length;
        for (n = 0; n < n2; ++n) {
            GenericLayout.TYPE_BY_GROUP[((Type)type).valueGroup.ordinal()] = type = typeArray[n];
        }
    }

    static enum Type {
        ZONED_DATE_TIME(ValueGroup.ZONED_DATE_TIME, 0),
        LOCAL_DATE_TIME(ValueGroup.LOCAL_DATE_TIME, 1),
        DATE(ValueGroup.DATE, 2),
        ZONED_TIME(ValueGroup.ZONED_TIME, 3),
        LOCAL_TIME(ValueGroup.LOCAL_TIME, 4),
        DURATION(ValueGroup.DURATION, 5),
        TEXT(ValueGroup.TEXT, 6),
        BOOLEAN(ValueGroup.BOOLEAN, 7),
        NUMBER(ValueGroup.NUMBER, 8),
        ZONED_DATE_TIME_ARRAY(ValueGroup.ZONED_DATE_TIME_ARRAY, 9),
        LOCAL_DATE_TIME_ARRAY(ValueGroup.LOCAL_DATE_TIME_ARRAY, 10),
        DATE_ARRAY(ValueGroup.DATE_ARRAY, 11),
        ZONED_TIME_ARRAY(ValueGroup.ZONED_TIME_ARRAY, 12),
        LOCAL_TIME_ARRAY(ValueGroup.LOCAL_TIME_ARRAY, 13),
        DURATION_ARRAY(ValueGroup.DURATION_ARRAY, 14),
        TEXT_ARRAY(ValueGroup.TEXT_ARRAY, 15),
        BOOLEAN_ARRAY(ValueGroup.BOOLEAN_ARRAY, 16),
        NUMBER_ARRAY(ValueGroup.NUMBER_ARRAY, 17);

        private final ValueGroup valueGroup;
        final byte typeId;

        private Type(ValueGroup valueGroup, byte typeId) {
            this.valueGroup = valueGroup;
            this.typeId = typeId;
        }
    }
}

