/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction0;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongLongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.LongLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.map.primitive.ImmutableLongLongMap;
import org.eclipse.collections.api.map.primitive.LongLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongLongMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongLongPair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedLongLongMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableLongLongMap;
import org.eclipse.collections.impl.primitive.AbstractLongIterable;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.util.collection.Memory;
import org.neo4j.kernel.impl.util.collection.MemoryAllocator;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

class LinearProbeLongLongHashMap
extends AbstractLongIterable
implements MutableLongLongMap,
Resource {
    @VisibleForTesting
    static final int DEFAULT_CAPACITY = 32;
    @VisibleForTesting
    static final double REMOVALS_FACTOR = 0.25;
    private static final double LOAD_FACTOR = 0.75;
    private static final long EMPTY_KEY = 0L;
    private static final long REMOVED_KEY = 1L;
    private static final long EMPTY_VALUE = 0L;
    private static final long ENTRY_SIZE = 16L;
    private final MemoryAllocator allocator;
    private Memory memory;
    private int capacity;
    private long modCount;
    private int resizeOccupancyThreshold;
    private int resizeRemovalsThreshold;
    private int removals;
    private int entriesInMemory;
    private boolean hasZeroKey;
    private boolean hasOneKey;
    private long zeroValue;
    private long oneValue;

    LinearProbeLongLongHashMap(MemoryAllocator allocator) {
        this.allocator = Objects.requireNonNull(allocator);
        this.allocateMemory(32);
    }

    public void put(long key, long value) {
        ++this.modCount;
        if (LinearProbeLongLongHashMap.isSentinelKey(key)) {
            this.putForSentinelKey(key, value);
            return;
        }
        int idx = this.indexOf(key);
        long keyAtIdx = this.getKeyAt(idx);
        if (keyAtIdx == key) {
            this.setValueAt(idx, value);
            return;
        }
        if (keyAtIdx == 1L) {
            --this.removals;
        }
        this.setKeyAt(idx, key);
        this.setValueAt(idx, value);
        ++this.entriesInMemory;
        if (this.entriesInMemory >= this.resizeOccupancyThreshold) {
            this.growAndRehash();
        }
    }

    public void putAll(LongLongMap map) {
        ++this.modCount;
        map.forEachKeyValue(this::put);
    }

    public long get(long key) {
        return this.getIfAbsent(key, 0L);
    }

    public long getIfAbsent(long key, long ifAbsent) {
        if (LinearProbeLongLongHashMap.isSentinelKey(key)) {
            return this.getForSentinelKey(key, ifAbsent);
        }
        int idx = this.indexOf(key);
        long keyAtIdx = this.getKeyAt(idx);
        if (keyAtIdx == key) {
            return this.getValueAt(idx);
        }
        return ifAbsent;
    }

    public long getIfAbsentPut(long key, long value) {
        return this.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> value);
    }

    public long getIfAbsentPut(long key, LongFunction0 supplier) {
        if (LinearProbeLongLongHashMap.isSentinelKey(key)) {
            return this.getIfAbsentPutForSentinelKey(key, supplier);
        }
        int idx = this.indexOf(key);
        long keyAtIdx = this.getKeyAt(idx);
        if (keyAtIdx == key) {
            return this.getValueAt(idx);
        }
        ++this.modCount;
        long value = supplier.value();
        if (keyAtIdx == 1L) {
            --this.removals;
        }
        this.setKeyAt(idx, key);
        this.setValueAt(idx, value);
        ++this.entriesInMemory;
        if (this.entriesInMemory >= this.resizeOccupancyThreshold) {
            this.growAndRehash();
        }
        return value;
    }

    public long getIfAbsentPutWithKey(long key, LongToLongFunction function) {
        return this.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> function.valueOf(key));
    }

    public <P> long getIfAbsentPutWith(long key, LongFunction<? super P> function, P parameter) {
        return this.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> function.longValueOf(parameter));
    }

    public long getOrThrow(long key) {
        return this.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> {
            throw new IllegalStateException("Key not found: " + key);
        });
    }

    public void removeKey(long key) {
        this.removeKeyIfAbsent(key, 0L);
    }

    public void remove(long key) {
        this.removeKeyIfAbsent(key, 0L);
    }

    public long removeKeyIfAbsent(long key, long ifAbsent) {
        ++this.modCount;
        if (LinearProbeLongLongHashMap.isSentinelKey(key)) {
            return this.removeForSentinelKey(key, ifAbsent);
        }
        int idx = this.indexOf(key);
        long keyAtIdx = this.getKeyAt(idx);
        if (keyAtIdx != key) {
            return ifAbsent;
        }
        this.setKeyAt(idx, 1L);
        --this.entriesInMemory;
        ++this.removals;
        long oldValue = this.getValueAt(idx);
        if (this.removals >= this.resizeRemovalsThreshold) {
            this.rehashWithoutGrow();
        }
        return oldValue;
    }

    public boolean containsKey(long key) {
        if (LinearProbeLongLongHashMap.isSentinelKey(key)) {
            return key == 0L && this.hasZeroKey || key == 1L && this.hasOneKey;
        }
        int idx = this.indexOf(key);
        long keyAtIdx = this.getKeyAt(idx);
        return key == keyAtIdx;
    }

    public boolean containsValue(long value) {
        if (this.hasZeroKey && this.zeroValue == value) {
            return true;
        }
        if (this.hasOneKey && this.oneValue == value) {
            return true;
        }
        for (int i = 0; i < this.capacity; ++i) {
            long key = this.getKeyAt(i);
            if (LinearProbeLongLongHashMap.isSentinelKey(key) || this.getValueAt(i) != value) continue;
            return true;
        }
        return false;
    }

    public long updateValue(long key, long initialValueIfAbsent, LongToLongFunction function) {
        ++this.modCount;
        if (LinearProbeLongLongHashMap.isSentinelKey(key)) {
            return this.updateValueForSentinelKey(key, initialValueIfAbsent, function);
        }
        int idx = this.indexOf(key);
        long keyAtIdx = this.getKeyAt(idx);
        if (keyAtIdx == key) {
            long newValue = function.applyAsLong(this.getValueAt(idx));
            this.setValueAt(idx, newValue);
            return newValue;
        }
        if (keyAtIdx == 1L) {
            --this.removals;
        }
        long value = function.applyAsLong(initialValueIfAbsent);
        this.setKeyAt(idx, key);
        this.setValueAt(idx, value);
        ++this.entriesInMemory;
        if (this.entriesInMemory >= this.resizeOccupancyThreshold) {
            this.growAndRehash();
        }
        return value;
    }

    public long addToValue(long key, long toBeAdded) {
        return this.updateValue(key, 0L, (LongToLongFunction & Serializable)v -> v + toBeAdded);
    }

    public void forEachKey(LongProcedure procedure) {
        if (this.hasZeroKey) {
            procedure.value(0L);
        }
        if (this.hasOneKey) {
            procedure.value(1L);
        }
        int left = this.entriesInMemory;
        for (int i = 0; i < this.capacity && left > 0; ++i) {
            long key = this.getKeyAt(i);
            if (LinearProbeLongLongHashMap.isSentinelKey(key)) continue;
            procedure.value(key);
            --left;
        }
    }

    public void forEachValue(LongProcedure procedure) {
        this.forEachKeyValue((LongLongProcedure & Serializable)(key, value) -> procedure.value(value));
    }

    public void forEachKeyValue(LongLongProcedure procedure) {
        if (this.hasZeroKey) {
            procedure.value(0L, this.zeroValue);
        }
        if (this.hasOneKey) {
            procedure.value(1L, this.oneValue);
        }
        int left = this.entriesInMemory;
        for (int i = 0; i < this.capacity && left > 0; ++i) {
            long key = this.getKeyAt(i);
            if (LinearProbeLongLongHashMap.isSentinelKey(key)) continue;
            long value = this.getValueAt(i);
            procedure.value(key, value);
            --left;
        }
    }

    public MutableLongCollection values() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void clear() {
        ++this.modCount;
        this.hasZeroKey = false;
        this.hasOneKey = false;
        this.entriesInMemory = 0;
        this.removals = 0;
        this.memory.free();
        this.allocateMemory(32);
    }

    public MutableLongLongMap flipUniqueValues() {
        throw new UnsupportedOperationException("not implemented");
    }

    public MutableLongLongMap select(LongLongPredicate predicate) {
        throw new UnsupportedOperationException("not implemented");
    }

    public MutableLongLongMap reject(LongLongPredicate predicate) {
        throw new UnsupportedOperationException("not implemented");
    }

    public MutableLongLongMap withKeyValue(long key, long value) {
        this.put(key, value);
        return this;
    }

    public MutableLongLongMap withoutKey(long key) {
        this.removeKey(key);
        return this;
    }

    public MutableLongLongMap withoutAllKeys(LongIterable keys) {
        keys.each(this::removeKey);
        return this;
    }

    public MutableLongLongMap asUnmodifiable() {
        return new UnmodifiableLongLongMap((MutableLongLongMap)this);
    }

    public MutableLongLongMap asSynchronized() {
        return new SynchronizedLongLongMap((MutableLongLongMap)this);
    }

    public LazyLongIterable keysView() {
        throw new UnsupportedOperationException("not implemented");
    }

    public RichIterable<LongLongPair> keyValuesView() {
        return new KeyValuesView();
    }

    public ImmutableLongLongMap toImmutable() {
        throw new UnsupportedOperationException("not implemented");
    }

    public MutableLongSet keySet() {
        throw new UnsupportedOperationException("not implemented");
    }

    public MutableLongIterator longIterator() {
        return new KeysIterator();
    }

    public long[] toArray() {
        MutableInt idx = new MutableInt();
        long[] array = new long[this.size()];
        this.each((LongProcedure & Serializable)element -> {
            array[idx.getAndIncrement()] = element;
        });
        return array;
    }

    public boolean contains(long value) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    public void each(LongProcedure procedure) {
        if (this.hasZeroKey) {
            procedure.value(0L);
        }
        if (this.hasOneKey) {
            procedure.value(1L);
        }
        int left = this.entriesInMemory;
        for (int i = 0; i < this.capacity && left > 0; ++i) {
            long key = this.getKeyAt(i);
            if (LinearProbeLongLongHashMap.isSentinelKey(key)) continue;
            procedure.value(key);
            --left;
        }
    }

    public MutableLongBag select(LongPredicate predicate) {
        throw new UnsupportedOperationException("not implemented");
    }

    public MutableLongBag reject(LongPredicate predicate) {
        throw new UnsupportedOperationException("not implemented");
    }

    public <V> MutableBag<V> collect(LongToObjectFunction<? extends V> function) {
        throw new UnsupportedOperationException("not implemented");
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        throw new UnsupportedOperationException("not implemented");
    }

    public int count(LongPredicate predicate) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean anySatisfy(LongPredicate predicate) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean allSatisfy(LongPredicate predicate) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        throw new UnsupportedOperationException("not implemented");
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException("not implemented");
    }

    public long sum() {
        throw new UnsupportedOperationException("not implemented");
    }

    public long max() {
        throw new UnsupportedOperationException("not implemented");
    }

    public long min() {
        throw new UnsupportedOperationException("not implemented");
    }

    public int size() {
        return this.entriesInMemory + (this.hasOneKey ? 1 : 0) + (this.hasZeroKey ? 1 : 0);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void close() {
        ++this.modCount;
        if (this.memory != null) {
            this.memory.free();
            this.memory = null;
        }
    }

    @VisibleForTesting
    void rehashWithoutGrow() {
        this.rehash(this.capacity);
    }

    @VisibleForTesting
    void growAndRehash() {
        int newCapacity = this.capacity * 2;
        if (newCapacity < this.capacity) {
            throw new RuntimeException("Map reached capacity limit");
        }
        this.rehash(newCapacity);
    }

    @VisibleForTesting
    int hashAndMask(long element) {
        long h = SpreadFunctions.longSpreadOne((long)element);
        return Long.hashCode(h) & this.capacity - 1;
    }

    int indexOf(long element) {
        int idx = this.hashAndMask(element);
        int firstRemovedIdx = -1;
        for (int i = 0; i < this.capacity; ++i) {
            long keyAtIdx = this.getKeyAt(idx);
            if (keyAtIdx == element) {
                return idx;
            }
            if (keyAtIdx == 0L) {
                return firstRemovedIdx == -1 ? idx : firstRemovedIdx;
            }
            if (keyAtIdx == 1L && firstRemovedIdx == -1) {
                firstRemovedIdx = idx;
            }
            idx = idx + 1 & this.capacity - 1;
        }
        throw new AssertionError((Object)("Failed to determine index for " + element));
    }

    private long updateValueForSentinelKey(long key, long initialValueIfAbsent, LongToLongFunction function) {
        if (key == 0L) {
            long newValue = function.applyAsLong(this.hasZeroKey ? this.zeroValue : initialValueIfAbsent);
            this.hasZeroKey = true;
            this.zeroValue = newValue;
            return newValue;
        }
        if (key == 1L) {
            long newValue = function.applyAsLong(this.hasOneKey ? this.oneValue : initialValueIfAbsent);
            this.hasOneKey = true;
            this.oneValue = newValue;
            return newValue;
        }
        throw new AssertionError((Object)("Invalid sentinel key: " + key));
    }

    private void rehash(int newCapacity) {
        int prevCapacity = this.capacity;
        Memory prevMemory = this.memory;
        this.entriesInMemory = 0;
        this.removals = 0;
        this.allocateMemory(newCapacity);
        for (int i = 0; i < prevCapacity; ++i) {
            long key = prevMemory.readLong((long)i * 16L);
            if (LinearProbeLongLongHashMap.isSentinelKey(key)) continue;
            long value = prevMemory.readLong((long)i * 16L + 8L);
            this.put(key, value);
        }
        prevMemory.free();
    }

    private static boolean isSentinelKey(long key) {
        return key == 0L || key == 1L;
    }

    private void allocateMemory(int newCapacity) {
        Preconditions.checkArgument((newCapacity > 1 && Integer.bitCount(newCapacity) == 1 ? 1 : 0) != 0, (String)"Capacity must be power of 2", (Object[])new Object[0]);
        this.capacity = newCapacity;
        this.resizeOccupancyThreshold = (int)((double)newCapacity * 0.75);
        this.resizeRemovalsThreshold = (int)((double)newCapacity * 0.25);
        this.memory = this.allocator.allocate((long)newCapacity * 16L);
    }

    private long removeForSentinelKey(long key, long ifAbsent) {
        if (key == 0L) {
            long result = this.hasZeroKey ? this.zeroValue : ifAbsent;
            this.hasZeroKey = false;
            return result;
        }
        if (key == 1L) {
            long result = this.hasOneKey ? this.oneValue : ifAbsent;
            this.hasOneKey = false;
            return result;
        }
        throw new AssertionError((Object)("Invalid sentinel key: " + key));
    }

    private long getForSentinelKey(long key, long ifAbsent) {
        if (key == 0L) {
            return this.hasZeroKey ? this.zeroValue : ifAbsent;
        }
        if (key == 1L) {
            return this.hasOneKey ? this.oneValue : ifAbsent;
        }
        throw new AssertionError((Object)("Invalid sentinel key: " + key));
    }

    private long getIfAbsentPutForSentinelKey(long key, LongFunction0 supplier) {
        if (key == 0L) {
            if (!this.hasZeroKey) {
                ++this.modCount;
                this.hasZeroKey = true;
                this.zeroValue = supplier.value();
            }
            return this.zeroValue;
        }
        if (key == 1L) {
            if (!this.hasOneKey) {
                ++this.modCount;
                this.hasOneKey = true;
                this.oneValue = supplier.value();
            }
            return this.oneValue;
        }
        throw new AssertionError((Object)("Invalid sentinel key: " + key));
    }

    private void setKeyAt(int idx, long key) {
        this.memory.writeLong((long)idx * 16L, key);
    }

    private long getKeyAt(int idx) {
        return this.memory.readLong((long)idx * 16L);
    }

    private void setValueAt(int idx, long value) {
        this.memory.writeLong((long)idx * 16L + 8L, value);
    }

    private long getValueAt(int idx) {
        return this.memory.readLong((long)idx * 16L + 8L);
    }

    private void putForSentinelKey(long key, long value) {
        if (key == 0L) {
            this.hasZeroKey = true;
            this.zeroValue = value;
        } else if (key == 1L) {
            this.hasOneKey = true;
            this.oneValue = value;
        } else {
            throw new AssertionError((Object)("Invalid sentinel key: " + key));
        }
    }

    private void validateIteratorState(long iteratorModCount) {
        if (iteratorModCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    private class KeysIterator
    implements MutableLongIterator {
        private final long modCount;
        private int visited;
        private int idx;
        private boolean handledZero;
        private boolean handledOne;

        private KeysIterator() {
            this.modCount = LinearProbeLongLongHashMap.this.modCount;
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("iterator is exhausted");
            }
            ++this.visited;
            if (!this.handledZero) {
                this.handledZero = true;
                if (LinearProbeLongLongHashMap.this.hasZeroKey) {
                    return 0L;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (LinearProbeLongLongHashMap.this.hasOneKey) {
                    return 1L;
                }
            }
            long key = LinearProbeLongLongHashMap.this.getKeyAt(this.idx);
            while (LinearProbeLongLongHashMap.isSentinelKey(key)) {
                ++this.idx;
                key = LinearProbeLongLongHashMap.this.getKeyAt(this.idx);
            }
            ++this.idx;
            return key;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            LinearProbeLongLongHashMap.this.validateIteratorState(this.modCount);
            return this.visited < LinearProbeLongLongHashMap.this.size();
        }
    }

    private class KeyValuesIterator
    implements Iterator<LongLongPair> {
        private final long modCount;
        private int visited;
        private int idx;
        private boolean handledZero;
        private boolean handledOne;

        private KeyValuesIterator() {
            this.modCount = LinearProbeLongLongHashMap.this.modCount;
        }

        @Override
        public LongLongPair next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("iterator is exhausted");
            }
            ++this.visited;
            if (!this.handledZero) {
                this.handledZero = true;
                if (LinearProbeLongLongHashMap.this.hasZeroKey) {
                    return PrimitiveTuples.pair((long)0L, (long)LinearProbeLongLongHashMap.this.zeroValue);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (LinearProbeLongLongHashMap.this.hasOneKey) {
                    return PrimitiveTuples.pair((long)1L, (long)LinearProbeLongLongHashMap.this.oneValue);
                }
            }
            long key = LinearProbeLongLongHashMap.this.getKeyAt(this.idx);
            while (LinearProbeLongLongHashMap.isSentinelKey(key)) {
                ++this.idx;
                key = LinearProbeLongLongHashMap.this.getKeyAt(this.idx);
            }
            long value = LinearProbeLongLongHashMap.this.getValueAt(this.idx);
            ++this.idx;
            return PrimitiveTuples.pair((long)key, (long)value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            LinearProbeLongLongHashMap.this.validateIteratorState(this.modCount);
            return this.visited != LinearProbeLongLongHashMap.this.size();
        }
    }

    private class KeyValuesView
    extends AbstractLazyIterable<LongLongPair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super LongLongPair> procedure) {
            throw new UnsupportedOperationException();
        }

        public void forEachWithIndex(ObjectIntProcedure<? super LongLongPair> objectIntProcedure) {
            throw new UnsupportedOperationException();
        }

        public <P> void forEachWith(Procedure2<? super LongLongPair, ? super P> procedure, P parameter) {
            throw new UnsupportedOperationException();
        }

        public Iterator<LongLongPair> iterator() {
            return new KeyValuesIterator();
        }
    }
}

