/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.util.Collection;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.WritableChannel;

public class LogEntryWriter {
    private final FlushableChannel channel;
    private final Visitor<StorageCommand, IOException> serializer;

    public LogEntryWriter(FlushableChannel channel) {
        this.channel = channel;
        this.serializer = new StorageCommandSerializer(channel);
    }

    protected void writeLogEntryHeader(byte type) throws IOException {
        this.channel.put(LogEntryVersion.CURRENT.byteCode()).put(type);
    }

    public void writeStartEntry(LogEntryStart entry) throws IOException {
        this.writeStartEntry(entry.getMasterId(), entry.getLocalId(), entry.getTimeWritten(), entry.getLastCommittedTxWhenTransactionStarted(), entry.getAdditionalHeader());
    }

    public void writeStartEntry(int masterId, int authorId, long timeWritten, long latestCommittedTxWhenStarted, byte[] additionalHeaderData) throws IOException {
        this.writeLogEntryHeader((byte)1);
        this.channel.putInt(masterId).putInt(authorId).putLong(timeWritten).putLong(latestCommittedTxWhenStarted).putInt(additionalHeaderData.length).put(additionalHeaderData, additionalHeaderData.length);
    }

    public void writeCommitEntry(LogEntryCommit entry) throws IOException {
        this.writeCommitEntry(entry.getTxId(), entry.getTimeWritten());
    }

    public void writeCommitEntry(long transactionId, long timeWritten) throws IOException {
        this.writeLogEntryHeader((byte)5);
        this.channel.putLong(transactionId).putLong(timeWritten);
    }

    public void serialize(TransactionRepresentation tx) throws IOException {
        tx.accept(this.serializer);
    }

    public void serialize(CommittedTransactionRepresentation tx) throws IOException {
        this.writeStartEntry(tx.getStartEntry());
        this.serialize(tx.getTransactionRepresentation());
        this.writeCommitEntry(tx.getCommitEntry());
    }

    public void serialize(Collection<StorageCommand> commands) throws IOException {
        for (StorageCommand command : commands) {
            this.serializer.visit((Object)command);
        }
    }

    public void writeCheckPointEntry(LogPosition logPosition) throws IOException {
        this.writeLogEntryHeader((byte)7);
        this.channel.putLong(logPosition.getLogVersion()).putLong(logPosition.getByteOffset());
    }

    private class StorageCommandSerializer
    implements Visitor<StorageCommand, IOException> {
        private final FlushableChannel channel;

        StorageCommandSerializer(FlushableChannel channel) {
            this.channel = channel;
        }

        public boolean visit(StorageCommand command) throws IOException {
            LogEntryWriter.this.writeLogEntryHeader((byte)3);
            command.serialize((WritableChannel)this.channel);
            return false;
        }
    }
}

