/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.NoSuchFileException;
import java.util.Optional;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.scan.FullLabelStream;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.ReadOnlyIdGeneratorFactory;
import org.neo4j.kernel.impl.storemigration.participant.AbstractStoreMigrationParticipant;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class NativeLabelScanStoreMigrator
extends AbstractStoreMigrationParticipant {
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final Config config;
    private boolean nativeLabelScanStoreMigrated;

    public NativeLabelScanStoreMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, Config config) {
        super("Native label scan index");
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
    }

    @Override
    public void migrate(File storeDir, File migrationDir, ProgressReporter progressReporter, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        if (this.isNativeLabelScanStoreMigrationRequired(storeDir)) {
            StoreFactory storeFactory = this.getStoreFactory(storeDir, versionToMigrateFrom);
            try (NeoStores neoStores = storeFactory.openAllNeoStores();
                 Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
                neoStores.verifyStoreOk();
                this.deleteNativeIndexFile(migrationDir);
                progressReporter.start(neoStores.getNodeStore().getNumberOfIdsInUse());
                NativeLabelScanStore nativeLabelScanStore = this.getNativeLabelScanStore(migrationDir, progressReporter, neoStores);
                lifespan.add((Lifecycle)nativeLabelScanStore);
            }
            this.nativeLabelScanStoreMigrated = true;
        }
    }

    @Override
    public void moveMigratedFiles(File migrationDir, File storeDir, String versionToUpgradeFrom, String versionToMigrateTo) throws IOException {
        if (this.nativeLabelScanStoreMigrated) {
            File nativeLabelIndex = new File(migrationDir, "neostore.labelscanstore.db");
            this.moveNativeIndexFile(storeDir, nativeLabelIndex);
            this.deleteLuceneLabelIndex(NativeLabelScanStoreMigrator.getLuceneStoreDirectory(storeDir));
        }
    }

    private void deleteNativeIndexFile(File storeDir) throws IOException {
        Optional indexFile = this.fileSystem.streamFilesRecursive(NativeLabelScanStore.getLabelScanStoreFile(storeDir)).findFirst();
        if (indexFile.isPresent()) {
            try {
                ((FileHandle)indexFile.get()).delete();
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
    }

    private void moveNativeIndexFile(File storeDir, File nativeLabelIndex) throws IOException {
        Optional nativeIndexFileHandle = this.fileSystem.streamFilesRecursive(nativeLabelIndex).findFirst();
        if (nativeIndexFileHandle.isPresent()) {
            ((FileHandle)nativeIndexFileHandle.get()).rename(new File(storeDir, "neostore.labelscanstore.db"), new CopyOption[0]);
        }
    }

    private NativeLabelScanStore getNativeLabelScanStore(File migrationDir, ProgressReporter progressReporter, NeoStores neoStores) {
        NeoStoreIndexStoreView neoStoreIndexStoreView = new NeoStoreIndexStoreView(LockService.NO_LOCK_SERVICE, neoStores);
        return new NativeLabelScanStore(this.pageCache, migrationDir, this.fileSystem, new MonitoredFullLabelStream(neoStoreIndexStoreView, progressReporter), false, new Monitors(), RecoveryCleanupWorkCollector.IMMEDIATE);
    }

    private StoreFactory getStoreFactory(File storeDir, String versionToMigrateFrom) {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        RecordFormats recordFormats = RecordFormatSelector.selectForVersion(versionToMigrateFrom);
        ReadOnlyIdGeneratorFactory idGeneratorFactory = new ReadOnlyIdGeneratorFactory(this.fileSystem);
        return new StoreFactory(this.config.get(GraphDatabaseSettings.active_database), storeDir, this.config, idGeneratorFactory, this.pageCache, this.fileSystem, recordFormats, (LogProvider)logProvider, EmptyVersionContextSupplier.EMPTY);
    }

    private boolean isNativeLabelScanStoreMigrationRequired(File storeDir) throws IOException {
        return this.fileSystem.streamFilesRecursive(new File(storeDir, "neostore.labelscanstore.db")).noneMatch(Predicates.alwaysTrue());
    }

    private void deleteLuceneLabelIndex(File indexRootDirectory) throws IOException {
        this.fileSystem.deleteRecursively(indexRootDirectory);
    }

    private static File getLuceneStoreDirectory(File storeRootDir) {
        return new File(new File(new File(storeRootDir, "schema"), "label"), "lucene");
    }

    private static class MonitoredFullLabelStream
    extends FullLabelStream {
        private final ProgressReporter progressReporter;

        MonitoredFullLabelStream(IndexStoreView indexStoreView, ProgressReporter progressReporter) {
            super(indexStoreView);
            this.progressReporter = progressReporter;
        }

        @Override
        public boolean visit(NodeLabelUpdate update) throws IOException {
            boolean visit = super.visit(update);
            this.progressReporter.progress(1L);
            return visit;
        }
    }
}

