/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.impl.UnmodifiableMap;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.newapi.NodeWithPropertyValues;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSetsImpl;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

class TxStateIndexChanges {
    TxStateIndexChanges() {
    }

    static LongDiffSets indexUpdatesForScan(ReadableTransactionState txState, IndexDescriptor descriptor) {
        UnmodifiableMap updates = txState.getIndexUpdates(descriptor.schema());
        if (updates == null) {
            return LongDiffSets.EMPTY;
        }
        MutableLongDiffSetsImpl diffs = new MutableLongDiffSetsImpl();
        for (LongDiffSets diffSet : updates.values()) {
            diffs.addAll((LongIterable)diffSet.getAdded());
            diffs.removeAll((LongIterable)diffSet.getRemoved());
        }
        return diffs;
    }

    static ReadableDiffSets<NodeWithPropertyValues> indexUpdatesWithValuesForScan(ReadableTransactionState txState, IndexDescriptor descriptor) {
        UnmodifiableMap updates = txState.getIndexUpdates(descriptor.schema());
        if (updates == null) {
            return ReadableDiffSets.Empty.instance();
        }
        DiffSets<NodeWithPropertyValues> diffs = new DiffSets<NodeWithPropertyValues>();
        for (Map.Entry entry : updates.entrySet()) {
            Value[] values = ((ValueTuple)entry.getKey()).getValues();
            LongDiffSets diffSets = (LongDiffSets)entry.getValue();
            diffSets.getAdded().each((LongProcedure & Serializable)nodeId -> diffs.add((Object)new NodeWithPropertyValues(nodeId, values)));
            diffSets.getRemoved().each((LongProcedure & Serializable)nodeId -> diffs.remove((Object)new NodeWithPropertyValues(nodeId, values)));
        }
        return diffs;
    }

    static LongDiffSets indexUpdatesForSuffixOrContains(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery query) {
        if (descriptor.schema().getPropertyIds().length != 1) {
            throw new IllegalStateException("Suffix and contains queries are only supported for single property queries");
        }
        UnmodifiableMap updates = txState.getIndexUpdates(descriptor.schema());
        if (updates == null) {
            return LongDiffSets.EMPTY;
        }
        MutableLongDiffSetsImpl diffs = new MutableLongDiffSetsImpl();
        for (Map.Entry entry : updates.entrySet()) {
            if (!query.acceptsValue(((ValueTuple)entry.getKey()).getOnlyValue())) continue;
            LongDiffSets diffsets = (LongDiffSets)entry.getValue();
            diffs.addAll((LongIterable)diffsets.getAdded());
            diffs.removeAll((LongIterable)diffsets.getRemoved());
        }
        return diffs;
    }

    static ReadableDiffSets<NodeWithPropertyValues> indexUpdatesWithValuesForSuffixOrContains(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery query) {
        if (descriptor.schema().getPropertyIds().length != 1) {
            throw new IllegalStateException("Suffix and contains queries are only supported for single property queries");
        }
        UnmodifiableMap updates = txState.getIndexUpdates(descriptor.schema());
        if (updates == null) {
            return ReadableDiffSets.Empty.instance();
        }
        DiffSets<NodeWithPropertyValues> diffs = new DiffSets<NodeWithPropertyValues>();
        for (Map.Entry entry : updates.entrySet()) {
            ValueTuple key = (ValueTuple)entry.getKey();
            if (!query.acceptsValue(key.getOnlyValue())) continue;
            Value[] values = key.getValues();
            LongDiffSets diffSets = (LongDiffSets)entry.getValue();
            diffSets.getAdded().each((LongProcedure & Serializable)nodeId -> diffs.add((Object)new NodeWithPropertyValues(nodeId, values)));
            diffSets.getRemoved().each((LongProcedure & Serializable)nodeId -> diffs.remove((Object)new NodeWithPropertyValues(nodeId, values)));
        }
        return diffs;
    }

    static LongDiffSets indexUpdatesForSeek(ReadableTransactionState txState, IndexDescriptor descriptor, ValueTuple values) {
        UnmodifiableMap updates = txState.getIndexUpdates(descriptor.schema());
        if (updates != null) {
            LongDiffSets indexUpdatesForSeek = (LongDiffSets)updates.get((Object)values);
            return indexUpdatesForSeek == null ? LongDiffSets.EMPTY : indexUpdatesForSeek;
        }
        return LongDiffSets.EMPTY;
    }

    static LongDiffSets indexUpdatesForRangeSeek(ReadableTransactionState txState, IndexDescriptor descriptor, ValueGroup valueGroup, Value lower, boolean includeLower, Value upper, boolean includeUpper) {
        boolean selectedIncludeUpper;
        ValueTuple selectedUpper;
        boolean selectedIncludeLower;
        ValueTuple selectedLower;
        if (lower == null || upper == null) {
            throw new IllegalStateException("Use Values.NO_VALUE to encode the lack of a bound");
        }
        NavigableMap sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return LongDiffSets.EMPTY;
        }
        if (lower == Values.NO_VALUE) {
            selectedLower = ValueTuple.of((Value[])new Value[]{Values.minValue((ValueGroup)valueGroup, (Value)upper)});
            selectedIncludeLower = true;
        } else {
            selectedLower = ValueTuple.of((Value[])new Value[]{lower});
            selectedIncludeLower = includeLower;
        }
        if (upper == Values.NO_VALUE) {
            selectedUpper = ValueTuple.of((Value[])new Value[]{Values.maxValue((ValueGroup)valueGroup, (Value)lower)});
            selectedIncludeUpper = false;
        } else {
            selectedUpper = ValueTuple.of((Value[])new Value[]{upper});
            selectedIncludeUpper = includeUpper;
        }
        return TxStateIndexChanges.indexUpdatesForRangeSeek(sortedUpdates, selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper);
    }

    private static LongDiffSets indexUpdatesForRangeSeek(NavigableMap<ValueTuple, ? extends LongDiffSets> sortedUpdates, ValueTuple lower, boolean includeLower, ValueTuple upper, boolean includeUpper) {
        MutableLongDiffSetsImpl diffs = new MutableLongDiffSetsImpl();
        Collection inRange = sortedUpdates.subMap(lower, includeLower, upper, includeUpper).values();
        for (LongDiffSets diffForSpecificValue : inRange) {
            diffs.addAll((LongIterable)diffForSpecificValue.getAdded());
            diffs.removeAll((LongIterable)diffForSpecificValue.getRemoved());
        }
        return diffs;
    }

    static ReadableDiffSets<NodeWithPropertyValues> indexUpdatesWithValuesForRangeSeek(ReadableTransactionState txState, IndexDescriptor descriptor, ValueGroup valueGroup, Value lower, boolean includeLower, Value upper, boolean includeUpper) {
        boolean selectedIncludeUpper;
        ValueTuple selectedUpper;
        boolean selectedIncludeLower;
        ValueTuple selectedLower;
        if (lower == null || upper == null) {
            throw new IllegalStateException("Use Values.NO_VALUE to encode the lack of a bound");
        }
        NavigableMap sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return ReadableDiffSets.Empty.instance();
        }
        if (lower == Values.NO_VALUE) {
            selectedLower = ValueTuple.of((Value[])new Value[]{Values.minValue((ValueGroup)valueGroup, (Value)upper)});
            selectedIncludeLower = true;
        } else {
            selectedLower = ValueTuple.of((Value[])new Value[]{lower});
            selectedIncludeLower = includeLower;
        }
        if (upper == Values.NO_VALUE) {
            selectedUpper = ValueTuple.of((Value[])new Value[]{Values.maxValue((ValueGroup)valueGroup, (Value)lower)});
            selectedIncludeUpper = false;
        } else {
            selectedUpper = ValueTuple.of((Value[])new Value[]{upper});
            selectedIncludeUpper = includeUpper;
        }
        return TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek(sortedUpdates, selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper);
    }

    private static ReadableDiffSets<NodeWithPropertyValues> indexUpdatesWithValuesForRangeSeek(NavigableMap<ValueTuple, ? extends LongDiffSets> sortedUpdates, ValueTuple selectedLower, boolean selectedIncludeLower, ValueTuple selectedUpper, boolean selectedIncludeUpper) {
        DiffSets<NodeWithPropertyValues> diffs = new DiffSets<NodeWithPropertyValues>();
        NavigableMap<ValueTuple, ? extends LongDiffSets> inRange = sortedUpdates.subMap(selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper);
        for (Map.Entry entry : inRange.entrySet()) {
            ValueTuple values = (ValueTuple)entry.getKey();
            Value[] valuesArray = values.getValues();
            LongDiffSets diffForSpecificValue = (LongDiffSets)entry.getValue();
            diffForSpecificValue.getAdded().each((LongProcedure & Serializable)nodeId -> diffs.add((Object)new NodeWithPropertyValues(nodeId, valuesArray)));
            diffForSpecificValue.getRemoved().each((LongProcedure & Serializable)nodeId -> diffs.remove((Object)new NodeWithPropertyValues(nodeId, valuesArray)));
        }
        return diffs;
    }

    static LongDiffSets indexUpdatesForRangeSeekByPrefix(ReadableTransactionState txState, IndexDescriptor descriptor, String prefix) {
        Map.Entry entry;
        ValueTuple key;
        NavigableMap sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return LongDiffSets.EMPTY;
        }
        ValueTuple floor = ValueTuple.of((Value[])new Value[]{Values.stringValue((String)prefix)});
        MutableLongDiffSetsImpl diffs = new MutableLongDiffSetsImpl();
        Iterator iterator = sortedUpdates.tailMap(floor).entrySet().iterator();
        while (iterator.hasNext() && ((TextValue)(key = (entry = iterator.next()).getKey()).getOnlyValue()).stringValue().startsWith(prefix)) {
            LongDiffSets diffSets = (LongDiffSets)entry.getValue();
            diffs.addAll((LongIterable)diffSets.getAdded());
            diffs.removeAll((LongIterable)diffSets.getRemoved());
        }
        return diffs;
    }

    static ReadableDiffSets<NodeWithPropertyValues> indexUpdatesWithValuesForRangeSeekByPrefix(ReadableTransactionState txState, IndexDescriptor descriptor, String prefix) {
        Map.Entry entry;
        ValueTuple key;
        NavigableMap sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return ReadableDiffSets.Empty.instance();
        }
        ValueTuple floor = ValueTuple.of((Value[])new Value[]{Values.stringValue((String)prefix)});
        DiffSets<NodeWithPropertyValues> diffs = new DiffSets<NodeWithPropertyValues>();
        Iterator iterator = sortedUpdates.tailMap(floor).entrySet().iterator();
        while (iterator.hasNext() && ((TextValue)(key = (entry = iterator.next()).getKey()).getOnlyValue()).stringValue().startsWith(prefix)) {
            LongDiffSets diffSets = (LongDiffSets)entry.getValue();
            Value[] values = key.getValues();
            diffSets.getAdded().each((LongProcedure & Serializable)nodeId -> diffs.add((Object)new NodeWithPropertyValues(nodeId, values)));
            diffSets.getRemoved().each((LongProcedure & Serializable)nodeId -> diffs.remove((Object)new NodeWithPropertyValues(nodeId, values)));
        }
        return diffs;
    }
}

