/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.NodeWithPropertyValues;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.TxStateIndexChanges;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueGroup;

final class DefaultNodeValueIndexCursor
extends IndexCursor<IndexProgressor>
implements NodeValueIndexCursor,
IndexProgressor.NodeValueClient {
    private Read read;
    private Resource resource;
    private long node;
    private IndexQuery[] query;
    private Value[] values;
    private LongIterator added = ImmutableEmptyLongIterator.INSTANCE;
    private Iterator<NodeWithPropertyValues> addedWithValues = Collections.emptyIterator();
    private LongSet removed = LongSets.immutable.empty();
    private boolean needsValues;
    private final DefaultCursors pool;

    DefaultNodeValueIndexCursor(DefaultCursors pool) {
        this.pool = pool;
        this.node = -1L;
    }

    public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query, boolean needsValues) {
        assert (query != null && query.length > 0);
        super.initialize(progressor);
        this.needsValues = needsValues;
        this.query = query;
        IndexQuery firstPredicate = query[0];
        switch (firstPredicate.type()) {
            case exact: {
                this.seekQuery(descriptor, query);
                break;
            }
            case exists: {
                this.scanQuery(descriptor);
                break;
            }
            case range: {
                assert (query.length == 1);
                this.rangeQuery(descriptor, (IndexQuery.RangePredicate)firstPredicate);
                break;
            }
            case stringPrefix: {
                assert (query.length == 1);
                this.prefixQuery(descriptor, (IndexQuery.StringPrefixPredicate)firstPredicate);
                break;
            }
            case stringSuffix: 
            case stringContains: {
                assert (query.length == 1);
                this.suffixOrContainsQuery(descriptor, firstPredicate);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Query not supported: " + Arrays.toString(query));
            }
        }
    }

    private boolean isRemoved(long reference) {
        return this.removed.contains(reference);
    }

    public boolean acceptNode(long reference, Value[] values) {
        if (this.isRemoved(reference)) {
            return false;
        }
        this.node = reference;
        this.values = values;
        return true;
    }

    public boolean needsValues() {
        return this.needsValues;
    }

    public boolean next() {
        if (!this.needsValues && this.added.hasNext()) {
            this.node = this.added.next();
            this.values = null;
            return true;
        }
        if (this.needsValues && this.addedWithValues.hasNext()) {
            NodeWithPropertyValues nodeWithPropertyValues = this.addedWithValues.next();
            this.node = nodeWithPropertyValues.getNodeId();
            this.values = nodeWithPropertyValues.getValues();
            return true;
        }
        return this.innerNext();
    }

    public void setRead(Read read, Resource resource) {
        this.read = read;
        this.resource = resource;
    }

    public void node(NodeCursor cursor) {
        this.read.singleNode(this.node, cursor);
    }

    public long nodeReference() {
        return this.node;
    }

    public int numberOfProperties() {
        return this.query == null ? 0 : this.query.length;
    }

    public int propertyKey(int offset) {
        return this.query[offset].propertyKeyId();
    }

    public boolean hasValue() {
        return this.values != null;
    }

    public Value propertyValue(int offset) {
        return this.values[offset];
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            super.close();
            this.node = -1L;
            this.query = null;
            this.values = null;
            this.read = null;
            this.added = ImmutableEmptyLongIterator.INSTANCE;
            this.addedWithValues = Collections.emptyIterator();
            this.removed = LongSets.immutable.empty();
            try {
                if (this.resource != null) {
                    this.resource.close();
                    this.resource = null;
                }
            }
            finally {
                this.pool.accept(this);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return super.isClosed();
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeValueIndexCursor[closed state]";
        }
        String keys = this.query == null ? "unknown" : Arrays.toString(Arrays.stream(this.query).map(IndexQuery::propertyKeyId).toArray(Integer[]::new));
        return "NodeValueIndexCursor[node=" + this.node + ", open state with: keys=" + keys + ", values=" + Arrays.toString(this.values) + ", underlying record=" + super.toString() + "]";
    }

    private void prefixQuery(IndexDescriptor descriptor, IndexQuery.StringPrefixPredicate predicate) {
        if (this.read.hasTxStateWithChanges()) {
            TransactionState txState = this.read.txState();
            if (this.needsValues) {
                ReadableDiffSets<NodeWithPropertyValues> changes = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeekByPrefix(txState, descriptor, predicate.prefix());
                this.addedWithValues = changes.getAdded().iterator();
                this.removed = this.removed(txState, changes.getRemoved());
            } else {
                LongDiffSets changes = TxStateIndexChanges.indexUpdatesForRangeSeekByPrefix(txState, descriptor, predicate.prefix());
                this.added = changes.augment((LongIterator)ImmutableEmptyLongIterator.INSTANCE);
                this.removed = this.removed(txState, changes);
            }
        }
    }

    private void rangeQuery(IndexDescriptor descriptor, IndexQuery.RangePredicate<?> predicate) {
        ValueGroup valueGroup = predicate.valueGroup();
        ValueCategory category = valueGroup.category();
        boolean bl = this.needsValues = this.needsValues && (category == ValueCategory.TEXT || category == ValueCategory.NUMBER || category == ValueCategory.TEMPORAL);
        if (this.read.hasTxStateWithChanges()) {
            TransactionState txState = this.read.txState();
            if (this.needsValues) {
                ReadableDiffSets<NodeWithPropertyValues> changes = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek(txState, descriptor, valueGroup, predicate.fromValue(), predicate.fromInclusive(), predicate.toValue(), predicate.toInclusive());
                this.addedWithValues = changes.getAdded().iterator();
                this.removed = this.removed(txState, changes.getRemoved());
            } else {
                LongDiffSets changes = TxStateIndexChanges.indexUpdatesForRangeSeek(txState, descriptor, valueGroup, predicate.fromValue(), predicate.fromInclusive(), predicate.toValue(), predicate.toInclusive());
                this.added = changes.augment((LongIterator)ImmutableEmptyLongIterator.INSTANCE);
                this.removed = this.removed(txState, changes);
            }
        }
    }

    private void scanQuery(IndexDescriptor descriptor) {
        if (this.read.hasTxStateWithChanges()) {
            TransactionState txState = this.read.txState();
            if (this.needsValues) {
                ReadableDiffSets<NodeWithPropertyValues> changes = TxStateIndexChanges.indexUpdatesWithValuesForScan(txState, descriptor);
                this.addedWithValues = changes.getAdded().iterator();
                this.removed = this.removed(txState, changes.getRemoved());
            } else {
                LongDiffSets changes = TxStateIndexChanges.indexUpdatesForScan(txState, descriptor);
                this.added = changes.augment((LongIterator)ImmutableEmptyLongIterator.INSTANCE);
                this.removed = this.removed(txState, changes);
            }
        }
    }

    private void suffixOrContainsQuery(IndexDescriptor descriptor, IndexQuery query) {
        if (this.read.hasTxStateWithChanges()) {
            TransactionState txState = this.read.txState();
            if (this.needsValues) {
                ReadableDiffSets<NodeWithPropertyValues> changes = TxStateIndexChanges.indexUpdatesWithValuesForSuffixOrContains(txState, descriptor, query);
                this.addedWithValues = changes.getAdded().iterator();
                this.removed = this.removed(txState, changes.getRemoved());
            } else {
                LongDiffSets changes = TxStateIndexChanges.indexUpdatesForSuffixOrContains(txState, descriptor, query);
                this.added = changes.augment((LongIterator)ImmutableEmptyLongIterator.INSTANCE);
                this.removed = this.removed(txState, changes);
            }
        }
    }

    private void seekQuery(IndexDescriptor descriptor, IndexQuery[] query) {
        this.needsValues = false;
        IndexQuery.ExactPredicate[] exactPreds = DefaultNodeValueIndexCursor.assertOnlyExactPredicates(query);
        if (this.read.hasTxStateWithChanges()) {
            TransactionState txState = this.read.txState();
            LongDiffSets changes = TxStateIndexChanges.indexUpdatesForSeek(txState, descriptor, IndexQuery.asValueTuple((IndexQuery.ExactPredicate[])exactPreds));
            this.added = changes.augment((LongIterator)ImmutableEmptyLongIterator.INSTANCE);
            this.removed = this.removed(txState, changes);
        }
    }

    private LongSet removed(TransactionState txState, LongDiffSets changes) {
        return PrimitiveLongCollections.mergeToSet((LongIterable)txState.addedAndRemovedNodes().getRemoved(), (LongIterable)changes.getRemoved());
    }

    private LongSet removed(TransactionState txState, Set<NodeWithPropertyValues> removed) {
        LongSet removedFromTXState = txState.addedAndRemovedNodes().getRemoved();
        LongHashSet set = new LongHashSet(removedFromTXState.size() + removed.size());
        set.addAll((LongIterable)removedFromTXState);
        for (NodeWithPropertyValues nodeWithPropertyValues : removed) {
            set.add(nodeWithPropertyValues.getNodeId());
        }
        return set;
    }

    private static IndexQuery.ExactPredicate[] assertOnlyExactPredicates(IndexQuery[] predicates) {
        IndexQuery.ExactPredicate[] exactPredicates;
        if (predicates.getClass() == IndexQuery.ExactPredicate[].class) {
            exactPredicates = (IndexQuery.ExactPredicate[])predicates;
        } else {
            exactPredicates = new IndexQuery.ExactPredicate[predicates.length];
            for (int i = 0; i < predicates.length; ++i) {
                if (!(predicates[i] instanceof IndexQuery.ExactPredicate)) {
                    throw new IllegalArgumentException("Query not supported: " + Arrays.toString(predicates));
                }
                exactPredicates[i] = (IndexQuery.ExactPredicate)predicates[i];
            }
        }
        return exactPredicates;
    }

    public void release() {
    }
}

