/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.StringIndexKey;

class StringLayout
extends IndexLayout<StringIndexKey> {
    StringLayout() {
        super("USI", 0, 1);
    }

    public StringIndexKey newKey() {
        return new StringIndexKey();
    }

    public StringIndexKey copyKey(StringIndexKey key, StringIndexKey into) {
        into.copyFrom(key);
        return into;
    }

    public int keySize(StringIndexKey key) {
        return key.size();
    }

    public void writeKey(PageCursor cursor, StringIndexKey key) {
        cursor.putLong(key.getEntityId());
        cursor.putBytes(key.bytes, 0, key.bytesLength);
    }

    public void readKey(PageCursor cursor, StringIndexKey into, int keySize) {
        if (keySize < 8) {
            into.setEntityId(Long.MIN_VALUE);
            into.setBytesLength(0);
            cursor.setCursorException(String.format("Reading string index key with an unexpected keySize:%d", keySize));
            return;
        }
        into.setEntityId(cursor.getLong());
        int bytesLength = keySize - 8;
        into.setBytesLength(bytesLength);
        cursor.getBytes(into.bytes, 0, bytesLength);
    }

    @Override
    public boolean fixedSize() {
        return false;
    }

    public void minimalSplitter(StringIndexKey left, StringIndexKey right, StringIndexKey into) {
        int targetLength;
        int maxLength = Math.min(left.bytesLength, right.bytesLength);
        for (targetLength = 0; targetLength < maxLength; ++targetLength) {
            if (left.bytes[targetLength] == right.bytes[targetLength]) continue;
            ++targetLength;
            break;
        }
        into.copyFrom(right, targetLength);
    }

    public String toString() {
        return String.format("%s[version:%d.%d, identifier:%d]", ((Object)((Object)this)).getClass().getSimpleName(), this.majorVersion(), this.minorVersion(), this.identifier());
    }

    @Override
    int compareValue(StringIndexKey o1, StringIndexKey o2) {
        return o1.compareValueTo(o2);
    }
}

