/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;

abstract class IndexLayout<KEY extends NativeIndexKey<KEY>>
extends Layout.Adapter<KEY, NativeIndexValue> {
    private final long identifier;
    private final int majorVersion;
    private final int minorVersion;

    IndexLayout(long identifier, int majorVersion, int minorVersion) {
        this.identifier = identifier;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    IndexLayout(String layoutName, int majorVersion, int minorVersion) {
        this(Layout.namedIdentifier((String)layoutName, (int)0), majorVersion, minorVersion);
    }

    public NativeIndexValue newValue() {
        return NativeIndexValue.INSTANCE;
    }

    public int valueSize(NativeIndexValue nativeIndexValue) {
        return 0;
    }

    public void writeValue(PageCursor cursor, NativeIndexValue nativeIndexValue) {
    }

    public void readValue(PageCursor cursor, NativeIndexValue into, int valueSize) {
    }

    public boolean fixedSize() {
        return true;
    }

    public long identifier() {
        return this.identifier;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public final int compare(KEY o1, KEY o2) {
        int valueComparison = this.compareValue(o1, o2);
        if (valueComparison == 0 && ((NativeIndexKey)((Object)o1)).getCompareId() & ((NativeIndexKey)((Object)o2)).getCompareId()) {
            return Long.compare(((NativeIndexKey)((Object)o1)).getEntityId(), ((NativeIndexKey)((Object)o2)).getEntityId());
        }
        return valueComparison;
    }

    int compareValue(KEY o1, KEY o2) {
        return ((NativeIndexKey)((Object)o1)).compareValueTo(o2);
    }
}

