/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.neo4j.function.Suppliers;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class IndexPopulationJob
implements Runnable {
    private final IndexingService.Monitor monitor;
    private final boolean verifyBeforeFlipping;
    private final MultipleIndexPopulator multiPopulator;
    private final CountDownLatch doneSignal = new CountDownLatch(1);
    private volatile StoreScan<IndexPopulationFailedKernelException> storeScan;
    private volatile boolean cancelled;

    public IndexPopulationJob(MultipleIndexPopulator multiPopulator, IndexingService.Monitor monitor, boolean verifyBeforeFlipping) {
        this.multiPopulator = multiPopulator;
        this.monitor = monitor;
        this.verifyBeforeFlipping = verifyBeforeFlipping;
    }

    MultipleIndexPopulator.IndexPopulation addPopulator(IndexPopulator populator, CapableIndexDescriptor capableIndexDescriptor, String indexUserDescription, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory) {
        assert (this.storeScan == null) : "Population have already started, too late to add populators at this point";
        return this.multiPopulator.addPopulator(populator, capableIndexDescriptor, flipper, failedIndexProxyFactory, indexUserDescription);
    }

    @Override
    public void run() {
        String oldThreadName = Thread.currentThread().getName();
        try {
            block10: {
                if (!this.multiPopulator.hasPopulators()) {
                    return;
                }
                if (this.storeScan != null) {
                    throw new IllegalStateException("Population already started.");
                }
                Thread.currentThread().setName("Index populator");
                this.multiPopulator.create();
                this.multiPopulator.resetIndexCounts();
                this.monitor.indexPopulationScanStarting();
                this.indexAllEntities();
                this.monitor.indexPopulationScanComplete();
                if (!this.cancelled) break block10;
                this.multiPopulator.cancel();
                return;
            }
            try {
                this.multiPopulator.flipAfterPopulation(this.verifyBeforeFlipping);
            }
            catch (Throwable t) {
                this.multiPopulator.fail(t);
            }
        }
        finally {
            this.doneSignal.countDown();
            Thread.currentThread().setName(oldThreadName);
        }
    }

    private void indexAllEntities() throws IndexPopulationFailedKernelException {
        this.storeScan = this.multiPopulator.indexAllEntities();
        this.storeScan.run();
    }

    PopulationProgress getPopulationProgress() {
        if (this.storeScan == null) {
            return PopulationProgress.NONE;
        }
        return this.storeScan.getProgress();
    }

    public Future<Void> cancel() {
        if (this.storeScan != null) {
            this.cancelled = true;
            this.storeScan.stop();
        }
        return FutureAdapter.latchGuardedValue(Suppliers.singleton(null), this.doneSignal, "Index population job cancel");
    }

    void cancelPopulation(MultipleIndexPopulator.IndexPopulation population) {
        this.multiPopulator.cancelIndexPopulation(population);
    }

    public void update(IndexEntryUpdate<?> update) {
        this.multiPopulator.queueUpdate(update);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[populator:" + this.multiPopulator + "]";
    }

    public void awaitCompletion() throws InterruptedException {
        this.doneSignal.await();
    }
}

