/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.time.Duration;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.ReplacedBy;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Configuration options for Bolt connectors. \"(bolt-connector-key)\" is a placeholder for a unique name for the connector, for instance \"bolt-public\" or some other name that describes what the connector is for.")
public class BoltConnector
extends Connector {
    @Description(value="Encryption level to require this connector to use")
    public final Setting<EncryptionLevel> encryption_level;
    @Description(value="Address the connector should bind to. This setting is deprecated and will be replaced by `+listen_address+`")
    @Deprecated
    @ReplacedBy(value="dbms.connector.X.listen_address")
    public final Setting<ListenSocketAddress> address;
    @Description(value="Address the connector should bind to")
    public final Setting<ListenSocketAddress> listen_address;
    @Description(value="Advertised address for this connector")
    public final Setting<AdvertisedSocketAddress> advertised_address;
    @Description(value="The number of threads to keep in the thread pool bound to this connector, even if they are idle.")
    public final Setting<Integer> thread_pool_min_size;
    @Description(value="The maximum number of threads allowed in the thread pool bound to this connector.")
    public final Setting<Integer> thread_pool_max_size;
    @Description(value="The maximum time an idle thread in the thread pool bound to this connector will wait for new tasks.")
    public final Setting<Duration> thread_pool_keep_alive;
    @Description(value="The queue size of the thread pool bound to this connector (-1 for unbounded, 0 for direct handoff, > 0 for bounded)")
    @Internal
    public final Setting<Integer> unsupported_thread_pool_queue_size;

    public BoltConnector() {
        this("(bolt-connector-key)");
    }

    public BoltConnector(String key) {
        super(key);
        this.encryption_level = this.group.scope(Settings.setting("tls_level", Settings.options(EncryptionLevel.class), EncryptionLevel.OPTIONAL.name()));
        BaseSetting<ListenSocketAddress> legacyAddressSetting = Settings.listenAddress("address", 7687);
        Setting<ListenSocketAddress> listenAddressSetting = Settings.legacyFallback(legacyAddressSetting, Settings.listenAddress("listen_address", 7687));
        this.address = this.group.scope(legacyAddressSetting);
        this.listen_address = this.group.scope(listenAddressSetting);
        this.advertised_address = this.group.scope(Settings.advertisedAddress("advertised_address", listenAddressSetting));
        this.thread_pool_min_size = this.group.scope(Settings.setting("thread_pool_min_size", Settings.INTEGER, String.valueOf(5)));
        this.thread_pool_max_size = this.group.scope(Settings.setting("thread_pool_max_size", Settings.INTEGER, String.valueOf(400)));
        this.thread_pool_keep_alive = this.group.scope(Settings.setting("thread_pool_keep_alive", Settings.DURATION, "5m"));
        this.unsupported_thread_pool_queue_size = this.group.scope(Settings.setting("unsupported_thread_pool_queue_size", Settings.INTEGER, String.valueOf(0)));
    }

    public static enum EncryptionLevel {
        REQUIRED,
        OPTIONAL,
        DISABLED;

    }
}

