/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.impl.transaction.stats.TransactionCounters;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class DatabaseAvailability
extends LifecycleAdapter {
    private static final AvailabilityGuard.AvailabilityRequirement AVAILABILITY_REQUIREMENT = AvailabilityGuard.availabilityRequirement("Database available");
    private final AvailabilityGuard availabilityGuard;
    private final TransactionCounters transactionCounters;
    private final Clock clock;
    private final long awaitActiveTransactionDeadlineMillis;
    private volatile boolean started;

    public DatabaseAvailability(AvailabilityGuard availabilityGuard, TransactionCounters transactionCounters, Clock clock, long awaitActiveTransactionDeadlineMillis) {
        this.availabilityGuard = availabilityGuard;
        this.transactionCounters = transactionCounters;
        this.awaitActiveTransactionDeadlineMillis = awaitActiveTransactionDeadlineMillis;
        this.clock = clock;
        availabilityGuard.require(AVAILABILITY_REQUIREMENT);
    }

    public void start() {
        this.availabilityGuard.fulfill(AVAILABILITY_REQUIREMENT);
        this.started = true;
    }

    public void stop() {
        this.started = false;
        this.availabilityGuard.require(AVAILABILITY_REQUIREMENT);
        this.awaitTransactionsClosedWithinTimeout();
    }

    public boolean isStarted() {
        return this.started;
    }

    private void awaitTransactionsClosedWithinTimeout() {
        long deadline = this.clock.millis() + this.awaitActiveTransactionDeadlineMillis;
        while (this.transactionCounters.getNumberOfActiveTransactions() > 0L && this.clock.millis() < deadline) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }
}

