/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.logging.Log;

public enum DiagnosticsPhase {
    REQUESTED(true, false),
    EXPLICIT(true, false),
    INITIALIZED(false, true),
    STARTED(false, true),
    STOPPING(false, false),
    SHUTDOWN(false, false);

    private final boolean requested;
    private final boolean initial;

    private DiagnosticsPhase(boolean requested, boolean initial) {
        this.requested = requested;
        this.initial = initial;
    }

    void emitStart(Log log) {
        log.info("--- " + (Object)((Object)this) + " START ---");
    }

    void emitDone(Log log) {
        log.info("--- " + (Object)((Object)this) + " END ---");
    }

    void emitStart(Log log, DiagnosticsProvider provider) {
        log.info("--- " + (Object)((Object)this) + " for " + provider.getDiagnosticsIdentifier() + " START ---");
    }

    void emitDone(Log log, DiagnosticsProvider provider) {
        log.info("--- " + (Object)((Object)this) + " for " + provider.getDiagnosticsIdentifier() + " END ---");
    }

    public boolean isInitialization() {
        return this.initial;
    }

    public boolean isExplicitlyRequested() {
        return this.requested;
    }

    public String toString() {
        return this.name() + " diagnostics";
    }
}

