/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.IntPredicate;
import java.util.function.LongFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreIdIterator;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.values.storable.Value;

public abstract class PropertyAwareEntityStoreScan<RECORD extends PrimitiveRecord, FAILURE extends Exception>
implements StoreScan<FAILURE> {
    private final RecordStore<RECORD> store;
    private volatile boolean continueScanning;
    private long count;
    private long totalCount;
    private final IntPredicate propertyKeyIdFilter;
    private final LongFunction<Lock> lockFunction;
    private final PropertyStore propertyStore;
    private final RECORD record;

    protected PropertyAwareEntityStoreScan(RecordStore<RECORD> store, PropertyStore propertyStore, IntPredicate propertyKeyIdFilter, LongFunction<Lock> lockFunction) {
        this.store = store;
        this.propertyStore = propertyStore;
        this.record = (PrimitiveRecord)store.newRecord();
        this.totalCount = store.getHighId();
        this.propertyKeyIdFilter = propertyKeyIdFilter;
        this.lockFunction = lockFunction;
    }

    static boolean containsAnyEntityToken(int[] entityTokenFilter, long ... entityTokens) {
        for (long candidate : entityTokens) {
            if (!ArrayUtils.contains((int[])entityTokenFilter, (int)Math.toIntExact(candidate))) continue;
            return true;
        }
        return false;
    }

    boolean hasRelevantProperty(RECORD record, EntityUpdates.Builder updates) {
        boolean hasRelevantProperty = false;
        for (PropertyBlock property : this.properties(record)) {
            int propertyKeyId = property.getKeyIndexId();
            if (!this.propertyKeyIdFilter.test(propertyKeyId)) continue;
            Value value = this.valueOf(property);
            updates.added(propertyKeyId, value);
            hasRelevantProperty = true;
        }
        return hasRelevantProperty;
    }

    @Override
    public void run() throws FAILURE {
        try (PrimitiveLongResourceIterator entityIdIterator = this.getEntityIdIterator();){
            this.continueScanning = true;
            while (this.continueScanning && entityIdIterator.hasNext()) {
                long id = entityIdIterator.next();
                Lock ignored = this.lockFunction.apply(id);
                Throwable throwable = null;
                try {
                    ++this.count;
                    if (!((PrimitiveRecord)this.store.getRecord(id, this.record, RecordLoad.FORCE)).inUse()) continue;
                    this.process(this.record);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
        }
    }

    protected abstract void process(RECORD var1) throws FAILURE;

    protected Value valueOf(PropertyBlock property) {
        this.propertyStore.ensureHeavy(property);
        return property.getType().value(property, this.propertyStore);
    }

    protected Iterable<PropertyBlock> properties(RECORD relationship) {
        return () -> new PropertyBlockIterator(this, relationship);
    }

    @Override
    public void stop() {
        this.continueScanning = false;
    }

    @Override
    public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate<?> update, long currentlyIndexedNodeId) {
        if (update.getEntityId() <= currentlyIndexedNodeId) {
            updater.process(update);
        }
    }

    @Override
    public PopulationProgress getProgress() {
        if (this.totalCount > 0L) {
            return new PopulationProgress(this.count, this.totalCount);
        }
        return PopulationProgress.DONE;
    }

    protected PrimitiveLongResourceIterator getEntityIdIterator() {
        return PrimitiveLongCollections.resourceIterator((LongIterator)new StoreIdIterator(this.store), null);
    }

    protected static class PropertyBlockIterator
    extends PrefetchingIterator<PropertyBlock> {
        private final Iterator<PropertyRecord> records;
        private Iterator<PropertyBlock> blocks = Collections.emptyIterator();
        final /* synthetic */ PropertyAwareEntityStoreScan this$0;

        PropertyBlockIterator(RECORD record) {
            this.this$0 = this$0;
            long firstPropertyId = ((PrimitiveRecord)record).getNextProp();
            this.records = firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue() ? Collections.emptyIterator() : ((PropertyAwareEntityStoreScan)this$0).propertyStore.getPropertyRecordChain(firstPropertyId).iterator();
        }

        protected PropertyBlock fetchNextOrNull() {
            while (!this.blocks.hasNext()) {
                if (!this.records.hasNext()) {
                    return null;
                }
                this.blocks = this.records.next().iterator();
            }
            return this.blocks.next();
        }
    }
}

