/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.ExplicitIndexProvider;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileIndexListing;
import org.neo4j.kernel.impl.util.MultiResource;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class NeoStoreFileListing {
    private final File storeDir;
    private final LogFiles logFiles;
    private final StorageEngine storageEngine;
    private static final Function<File, StoreFileMetadata> toNotAStoreTypeFile = file -> new StoreFileMetadata((File)file, 1);
    private static final Function<File, StoreFileMetadata> logFileMapper = file -> new StoreFileMetadata((File)file, 1, true);
    private final NeoStoreFileIndexListing neoStoreFileIndexListing;
    private final Collection<StoreFileProvider> additionalProviders;

    public NeoStoreFileListing(File storeDir, LogFiles logFiles, LabelScanStore labelScanStore, IndexingService indexingService, ExplicitIndexProvider explicitIndexProviders, StorageEngine storageEngine) {
        this.storeDir = storeDir;
        this.logFiles = logFiles;
        this.storageEngine = storageEngine;
        this.neoStoreFileIndexListing = new NeoStoreFileIndexListing(labelScanStore, indexingService, explicitIndexProviders);
        this.additionalProviders = new CopyOnWriteArraySet<StoreFileProvider>();
    }

    public StoreFileListingBuilder builder() {
        return new StoreFileListingBuilder();
    }

    public NeoStoreFileIndexListing getNeoStoreFileIndexListing() {
        return this.neoStoreFileIndexListing;
    }

    public void registerStoreFileProvider(StoreFileProvider provider) {
        this.additionalProviders.add(provider);
    }

    private void placeMetaDataStoreLast(List<StoreFileMetadata> files) {
        StoreFileMetadata file;
        Optional<StoreType> storeType;
        int index = 0;
        Iterator<StoreFileMetadata> iterator = files.iterator();
        while (!(!iterator.hasNext() || (storeType = StoreType.typeOf((file = iterator.next()).file().getName())).isPresent() && storeType.get().equals((Object)StoreType.META_DATA))) {
            ++index;
        }
        if (index < files.size() - 1) {
            StoreFileMetadata metaDataStoreFile = files.remove(index);
            files.add(metaDataStoreFile);
        }
    }

    private void gatherNonRecordStores(Collection<StoreFileMetadata> files, boolean includeLogs) {
        File[] indexFiles = this.storeDir.listFiles((dir, name) -> name.equals("index.db"));
        if (indexFiles != null) {
            for (File file : indexFiles) {
                files.add(toNotAStoreTypeFile.apply(file));
            }
        }
        if (includeLogs) {
            File[] logFiles;
            for (File logFile : logFiles = this.logFiles.logFiles()) {
                files.add(logFileMapper.apply(logFile));
            }
        }
    }

    public static List<StoreFileMetadata> getSnapshotFilesMetadata(ResourceIterator<File> snapshot) {
        return snapshot.stream().map(toNotAStoreTypeFile).collect(Collectors.toList());
    }

    private void gatherNeoStoreFiles(Collection<StoreFileMetadata> targetFiles) {
        targetFiles.addAll(this.storageEngine.listStorageFiles());
    }

    public class StoreFileListingBuilder {
        private boolean excludeLogFiles;
        private boolean excludeNonRecordStoreFiles;
        private boolean excludeNeoStoreFiles;
        private boolean excludeLabelScanStoreFiles;
        private boolean excludeSchemaIndexStoreFiles;
        private boolean excludeExplicitIndexStoreFiles;
        private boolean excludeAdditionalProviders;

        private StoreFileListingBuilder() {
        }

        private void excludeAll(boolean initiateInclusive) {
            this.excludeAdditionalProviders = this.excludeExplicitIndexStoreFiles = initiateInclusive;
            this.excludeSchemaIndexStoreFiles = this.excludeExplicitIndexStoreFiles;
            this.excludeLabelScanStoreFiles = this.excludeExplicitIndexStoreFiles;
            this.excludeNeoStoreFiles = this.excludeExplicitIndexStoreFiles;
            this.excludeNonRecordStoreFiles = this.excludeExplicitIndexStoreFiles;
            this.excludeLogFiles = this.excludeExplicitIndexStoreFiles;
        }

        public StoreFileListingBuilder excludeAll() {
            this.excludeAll(true);
            return this;
        }

        public StoreFileListingBuilder includeAll() {
            this.excludeAll(false);
            return this;
        }

        public StoreFileListingBuilder excludeLogFiles() {
            this.excludeLogFiles = true;
            return this;
        }

        public StoreFileListingBuilder excludeNonRecordStoreFiles() {
            this.excludeNonRecordStoreFiles = true;
            return this;
        }

        public StoreFileListingBuilder excludeNeoStoreFiles() {
            this.excludeNeoStoreFiles = true;
            return this;
        }

        public StoreFileListingBuilder excludeLabelScanStoreFiles() {
            this.excludeLabelScanStoreFiles = true;
            return this;
        }

        public StoreFileListingBuilder excludeSchemaIndexStoreFiles() {
            this.excludeSchemaIndexStoreFiles = true;
            return this;
        }

        public StoreFileListingBuilder excludeExplicitIndexStoreFiles() {
            this.excludeExplicitIndexStoreFiles = true;
            return this;
        }

        public StoreFileListingBuilder excludeAdditionalProviders() {
            this.excludeAdditionalProviders = true;
            return this;
        }

        public StoreFileListingBuilder includeLogFiles() {
            this.excludeLogFiles = false;
            return this;
        }

        public StoreFileListingBuilder includeNonRecordStoreFiles() {
            this.excludeNonRecordStoreFiles = false;
            return this;
        }

        public StoreFileListingBuilder includeNeoStoreFiles() {
            this.excludeNeoStoreFiles = false;
            return this;
        }

        public StoreFileListingBuilder includeLabelScanStoreFiles() {
            this.excludeLabelScanStoreFiles = false;
            return this;
        }

        public StoreFileListingBuilder includeSchemaIndexStoreFiles() {
            this.excludeSchemaIndexStoreFiles = false;
            return this;
        }

        public StoreFileListingBuilder includeExplicitIndexStoreStoreFiles() {
            this.excludeExplicitIndexStoreFiles = false;
            return this;
        }

        public StoreFileListingBuilder includeAdditionalProviders() {
            this.excludeAdditionalProviders = false;
            return this;
        }

        public ResourceIterator<StoreFileMetadata> build() throws IOException {
            ArrayList<StoreFileMetadata> files = new ArrayList<StoreFileMetadata>();
            ArrayList<Resource> resources = new ArrayList<Resource>();
            try {
                if (!this.excludeNonRecordStoreFiles) {
                    NeoStoreFileListing.this.gatherNonRecordStores(files, !this.excludeLogFiles);
                }
                if (!this.excludeNeoStoreFiles) {
                    NeoStoreFileListing.this.gatherNeoStoreFiles(files);
                }
                if (!this.excludeLabelScanStoreFiles) {
                    resources.add(NeoStoreFileListing.this.neoStoreFileIndexListing.gatherLabelScanStoreFiles(files));
                }
                if (!this.excludeSchemaIndexStoreFiles) {
                    resources.add(NeoStoreFileListing.this.neoStoreFileIndexListing.gatherSchemaIndexFiles(files));
                }
                if (!this.excludeExplicitIndexStoreFiles) {
                    resources.add(NeoStoreFileListing.this.neoStoreFileIndexListing.gatherExplicitIndexFiles(files));
                }
                if (!this.excludeAdditionalProviders) {
                    for (StoreFileProvider additionalProvider : NeoStoreFileListing.this.additionalProviders) {
                        resources.add(additionalProvider.addFilesTo(files));
                    }
                }
                NeoStoreFileListing.this.placeMetaDataStoreLast(files);
            }
            catch (IOException e) {
                try {
                    IOUtils.closeAll(resources);
                }
                catch (IOException e1) {
                    e = (IOException)Exceptions.chain((Throwable)e, (Throwable)e1);
                }
                throw e;
            }
            return Iterators.resourceIterator(files.iterator(), (Resource)new MultiResource(resources));
        }
    }

    public static interface StoreFileProvider {
        public Resource addFilesTo(Collection<StoreFileMetadata> var1) throws IOException;
    }
}

