/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.newapi.References;
import org.neo4j.kernel.impl.newapi.RelationshipReferenceEncoding;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordRelationshipCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordRelationshipGroupCursor;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;

class RecordRelationshipTraversalCursor
extends RecordRelationshipCursor
implements StorageRelationshipTraversalCursor {
    private long originNodeReference;
    private long next;
    private Record buffer;
    private PageCursor pageCursor;
    private final RecordRelationshipGroupCursor group;
    private GroupState groupState;
    private boolean open;

    RecordRelationshipTraversalCursor(RelationshipStore relationshipStore, RelationshipGroupStore groupStore) {
        super(relationshipStore);
        this.group = new RecordRelationshipGroupCursor(relationshipStore, groupStore);
    }

    @Override
    public void init(long nodeReference, long reference) {
        RelationshipReferenceEncoding encoding = RelationshipReferenceEncoding.parseEncoding(reference);
        switch (encoding) {
            case NONE: {
                this.chain(nodeReference, reference);
                break;
            }
            case GROUP: {
                this.groups(nodeReference, References.clearEncoding(reference));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown encoding " + (Object)((Object)encoding));
            }
        }
        this.open = true;
    }

    private void chain(long nodeReference, long reference) {
        if (this.pageCursor == null) {
            this.pageCursor = this.relationshipPage(reference);
        }
        this.setId(-1L);
        this.groupState = GroupState.NONE;
        this.originNodeReference = nodeReference;
        this.next = reference;
    }

    private void groups(long nodeReference, long groupReference) {
        this.setId(-1L);
        this.next = -1L;
        this.groupState = GroupState.INCOMING;
        this.originNodeReference = nodeReference;
        this.group.direct(nodeReference, groupReference);
    }

    @Override
    public long neighbourNodeReference() {
        long source = this.sourceNodeReference();
        long target = this.targetNodeReference();
        if (source == this.originNodeReference) {
            return target;
        }
        if (target == this.originNodeReference) {
            return source;
        }
        throw new IllegalStateException("NOT PART OF CHAIN");
    }

    @Override
    public long originNodeReference() {
        return this.originNodeReference;
    }

    @Override
    public boolean next() {
        if (this.hasBufferedData()) {
            return this.nextBuffered();
        }
        do {
            if (this.traversingDenseNode()) {
                this.traverseDenseNode();
            }
            if (this.next == -1L) {
                this.reset();
                return false;
            }
            this.relationshipFull(this, this.next, this.pageCursor);
            this.computeNext();
        } while (!this.inUse());
        return true;
    }

    private boolean nextBuffered() {
        this.buffer = this.buffer.next;
        if (!this.hasBufferedData()) {
            this.reset();
            return false;
        }
        this.copyFromBuffer();
        return true;
    }

    private void traverseDenseNode() {
        block5: while (this.next == -1L) {
            switch (this.groupState) {
                case INCOMING: {
                    boolean hasNext = this.group.next();
                    if (!hasNext) {
                        assert (this.next == -1L);
                        return;
                    }
                    this.next = this.group.incomingRawId();
                    if (this.pageCursor == null) {
                        this.pageCursor = this.relationshipPage(Math.max(this.next, 0L));
                    }
                    this.groupState = GroupState.OUTGOING;
                    continue block5;
                }
                case OUTGOING: {
                    this.next = this.group.outgoingRawId();
                    this.groupState = GroupState.LOOP;
                    continue block5;
                }
                case LOOP: {
                    this.next = this.group.loopsRawId();
                    this.groupState = GroupState.INCOMING;
                    continue block5;
                }
            }
            throw new IllegalStateException("We cannot get here, but checkstyle forces this!");
        }
    }

    private void computeNext() {
        long source = this.sourceNodeReference();
        long target = this.targetNodeReference();
        if (source == this.originNodeReference) {
            this.next = this.getFirstNextRel();
        } else if (target == this.originNodeReference) {
            this.next = this.getSecondNextRel();
        } else {
            throw new IllegalStateException("NOT PART OF CHAIN! " + this);
        }
    }

    private void copyFromBuffer() {
        this.setId(this.buffer.id);
        this.setType(this.buffer.type);
        this.setNextProp(this.buffer.nextProp);
        this.setFirstNode(this.buffer.firstNode);
        this.setSecondNode(this.buffer.secondNode);
    }

    private boolean traversingDenseNode() {
        return this.groupState != GroupState.NONE;
    }

    @Override
    public void close() {
        if (this.open) {
            this.open = false;
            this.buffer = null;
            this.reset();
        }
    }

    private void reset() {
        this.next = -1L;
        this.setId(-1L);
        this.groupState = GroupState.NONE;
        this.buffer = null;
    }

    @Override
    public void release() {
        if (this.pageCursor != null) {
            this.pageCursor.close();
            this.pageCursor = null;
        }
        this.group.release();
    }

    @Override
    public String toString() {
        if (!this.open) {
            return "RelationshipTraversalCursor[closed state]";
        }
        String dense = "denseNode=" + this.traversingDenseNode();
        String mode = "mode=";
        mode = this.hasBufferedData() ? mode + "bufferedData" : mode + "regular";
        return "RelationshipTraversalCursor[id=" + this.getId() + ", open state with: " + dense + ", next=" + this.next + ", " + mode + ", underlying record=" + super.toString() + "]";
    }

    private boolean hasBufferedData() {
        return this.buffer != null;
    }

    static class Record {
        final long id;
        final int type;
        final long nextProp;
        final long firstNode;
        final long secondNode;
        final Record next;

        Record(RelationshipRecord record, Record next) {
            if (record != null) {
                this.id = record.getId();
                this.type = record.getType();
                this.nextProp = record.getNextProp();
                this.firstNode = record.getFirstNode();
                this.secondNode = record.getSecondNode();
            } else {
                this.id = -1L;
                this.type = -1;
                this.nextProp = -1L;
                this.firstNode = -1L;
                this.secondNode = -1L;
            }
            this.next = next;
        }
    }

    private static enum GroupState {
        INCOMING,
        OUTGOING,
        LOOP,
        NONE;

    }
}

