/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.FilteringNativeHitIndexProgressor;
import org.neo4j.kernel.impl.index.schema.FilteringNativeHitIterator;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.NativeHitIndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeHitIterator;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;

abstract class NativeIndexReader<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
implements IndexReader {
    protected final IndexDescriptor descriptor;
    final Layout<KEY, VALUE> layout;
    final Set<RawCursor<Hit<KEY, VALUE>, IOException>> openSeekers;
    private final GBPTree<KEY, VALUE> tree;
    private final IndexSamplingConfig samplingConfig;

    NativeIndexReader(GBPTree<KEY, VALUE> tree, Layout<KEY, VALUE> layout, IndexSamplingConfig samplingConfig, IndexDescriptor descriptor) {
        this.tree = tree;
        this.layout = layout;
        this.samplingConfig = samplingConfig;
        this.descriptor = descriptor;
        this.openSeekers = new HashSet<RawCursor<Hit<KEY, VALUE>, IOException>>();
    }

    public void close() {
        this.ensureOpenSeekersClosed();
    }

    @Override
    public IndexSampler createSampler() {
        FullScanNonUniqueIndexSampler<KEY, VALUE> sampler = new FullScanNonUniqueIndexSampler<KEY, VALUE>(this.tree, this.layout, this.samplingConfig);
        return sampler::result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        NativeIndexKey treeKeyFrom = (NativeIndexKey)((Object)this.layout.newKey());
        NativeIndexKey treeKeyTo = (NativeIndexKey)((Object)this.layout.newKey());
        treeKeyFrom.initialize(nodeId);
        treeKeyTo.initialize(nodeId);
        for (int i = 0; i < propertyValues.length; ++i) {
            treeKeyFrom.initFromValue(i, propertyValues[i], NativeIndexKey.Inclusion.NEUTRAL);
            treeKeyTo.initFromValue(i, propertyValues[i], NativeIndexKey.Inclusion.NEUTRAL);
        }
        try (RawCursor seeker = this.tree.seek((Object)treeKeyFrom, (Object)treeKeyTo);){
            long count = 0L;
            while (seeker.next()) {
                if (((NativeIndexKey)((Object)((Hit)seeker.get()).key())).getEntityId() != nodeId) continue;
                ++count;
            }
            long l = count;
            return l;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) {
        NativeIndexKey treeKeyFrom = (NativeIndexKey)((Object)this.layout.newKey());
        NativeIndexKey treeKeyTo = (NativeIndexKey)((Object)this.layout.newKey());
        treeKeyFrom.initialize(Long.MIN_VALUE);
        treeKeyTo.initialize(Long.MAX_VALUE);
        boolean needFilter = this.initializeRangeForQuery(treeKeyFrom, treeKeyTo, predicates);
        if (this.isBackwardsSeek(treeKeyFrom, treeKeyTo)) {
            return PrimitiveLongResourceCollections.emptyIterator();
        }
        try {
            RawCursor seeker = this.tree.seek((Object)treeKeyFrom, (Object)treeKeyTo);
            this.openSeekers.add(seeker);
            return this.getHitIterator(seeker, needFilter, predicates);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private PrimitiveLongResourceIterator getHitIterator(RawCursor<Hit<KEY, VALUE>, IOException> seeker, boolean needFilter, IndexQuery[] predicates) {
        return needFilter ? new FilteringNativeHitIterator<KEY, VALUE>(seeker, this.openSeekers, predicates) : new NativeHitIterator<KEY, VALUE>(seeker, this.openSeekers);
    }

    @Override
    public void query(IndexProgressor.NodeValueClient cursor, IndexOrder indexOrder, IndexQuery ... predicates) {
        this.validateQuery(indexOrder, predicates);
        NativeIndexKey treeKeyFrom = (NativeIndexKey)((Object)this.layout.newKey());
        NativeIndexKey treeKeyTo = (NativeIndexKey)((Object)this.layout.newKey());
        treeKeyFrom.initialize(Long.MIN_VALUE);
        treeKeyTo.initialize(Long.MAX_VALUE);
        boolean needFilter = this.initializeRangeForQuery(treeKeyFrom, treeKeyTo, predicates);
        this.startSeekForInitializedRange(cursor, treeKeyFrom, treeKeyTo, predicates, needFilter);
    }

    @Override
    public abstract boolean hasFullValuePrecision(IndexQuery ... var1);

    abstract void validateQuery(IndexOrder var1, IndexQuery[] var2);

    abstract boolean initializeRangeForQuery(KEY var1, KEY var2, IndexQuery[] var3);

    void startSeekForInitializedRange(IndexProgressor.NodeValueClient client, KEY treeKeyFrom, KEY treeKeyTo, IndexQuery[] query, boolean needFilter) {
        if (this.isBackwardsSeek(treeKeyFrom, treeKeyTo)) {
            client.initialize(this.descriptor, IndexProgressor.EMPTY, query);
            return;
        }
        try {
            RawCursor<Hit<KEY, VALUE>, IOException> seeker = this.makeIndexSeeker(treeKeyFrom, treeKeyTo);
            IndexProgressor hitProgressor = this.getIndexProgressor(seeker, client, needFilter, query);
            client.initialize(this.descriptor, hitProgressor, query);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    RawCursor<Hit<KEY, VALUE>, IOException> makeIndexSeeker(KEY treeKeyFrom, KEY treeKeyTo) throws IOException {
        RawCursor seeker = this.tree.seek(treeKeyFrom, treeKeyTo);
        this.openSeekers.add(seeker);
        return seeker;
    }

    private IndexProgressor getIndexProgressor(RawCursor<Hit<KEY, VALUE>, IOException> seeker, IndexProgressor.NodeValueClient client, boolean needFilter, IndexQuery[] query) {
        return needFilter ? new FilteringNativeHitIndexProgressor<KEY, VALUE>(seeker, client, this.openSeekers, query) : new NativeHitIndexProgressor<KEY, VALUE>(seeker, client, this.openSeekers);
    }

    private boolean isBackwardsSeek(KEY treeKeyFrom, KEY treeKeyTo) {
        return this.layout.compare(treeKeyFrom, treeKeyTo) > 0;
    }

    private void ensureOpenSeekersClosed() {
        try {
            IOUtils.closeAll(this.openSeekers);
            this.openSeekers.clear();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

