/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValueIndexAccessor;

class LabelScanValueIterator
extends LabelScanValueIndexAccessor
implements PrimitiveLongResourceIterator {
    private boolean hasNextDecided;
    private boolean hasNext;
    protected long next;

    public boolean hasNext() {
        if (!this.hasNextDecided) {
            this.hasNext = this.fetchNext();
            this.hasNextDecided = true;
        }
        return this.hasNext;
    }

    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements in " + this);
        }
        this.hasNextDecided = false;
        return this.next;
    }

    LabelScanValueIterator(RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor, Collection<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> toRemoveFromWhenClosed) {
        super(toRemoveFromWhenClosed, cursor);
    }

    protected boolean fetchNext() {
        Hit hit;
        while (true) {
            if (this.bits != 0L) {
                int delta = Long.numberOfTrailingZeros(this.bits);
                this.bits &= this.bits - 1L;
                this.next = this.baseNodeId + (long)delta;
                this.hasNext = true;
                return true;
            }
            try {
                if (!this.cursor.next()) {
                    this.close();
                    return false;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            hit = (Hit)this.cursor.get();
            this.baseNodeId = ((LabelScanKey)hit.key()).idRange * 64L;
            this.bits = ((LabelScanValue)hit.value()).bits;
            assert (this.keysInOrder((LabelScanKey)hit.key()));
        }
    }
}

