/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class AbstractIndexKeyLengthValidator
implements Validator<Value> {
    protected final int maxByteLength;
    private final int checkThreshold;

    protected AbstractIndexKeyLengthValidator(int maxByteLength) {
        this.maxByteLength = maxByteLength;
        this.checkThreshold = maxByteLength / 5;
    }

    @Override
    public void validate(Value value) {
        if (value == null || value == Values.NO_VALUE) {
            throw new IllegalArgumentException("Null value");
        }
        if (Values.isTextValue((Object)value) && ((TextValue)value).length() >= this.checkThreshold) {
            int length = this.indexKeyLength(value);
            this.validateLength(length);
        }
    }

    void validateLength(int byteLength) {
        if (byteLength > this.maxByteLength) {
            throw new IllegalArgumentException("Property value size is too large for index. Please see index documentation for limitations.");
        }
    }

    protected abstract int indexKeyLength(Value var1);
}

