/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.index;

import java.util.Optional;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;

public class IndexDescriptorFactory {
    private IndexDescriptorFactory() {
    }

    public static IndexDescriptor forSchema(SchemaDescriptor schema) {
        return IndexDescriptorFactory.forSchema(schema, IndexProvider.UNDECIDED);
    }

    public static IndexDescriptor forSchema(SchemaDescriptor schema, IndexProvider.Descriptor providerDescriptor) {
        return IndexDescriptorFactory.forSchema(schema, Optional.empty(), providerDescriptor);
    }

    public static IndexDescriptor forSchema(SchemaDescriptor schema, Optional<String> name, IndexProvider.Descriptor providerDescriptor) {
        return new IndexDescriptor(schema, IndexDescriptor.Type.GENERAL, name, providerDescriptor);
    }

    public static IndexDescriptor uniqueForSchema(SchemaDescriptor schema) {
        return IndexDescriptorFactory.uniqueForSchema(schema, IndexProvider.UNDECIDED);
    }

    public static IndexDescriptor uniqueForSchema(SchemaDescriptor schema, IndexProvider.Descriptor providerDescriptor) {
        return IndexDescriptorFactory.uniqueForSchema(schema, Optional.empty(), providerDescriptor);
    }

    public static IndexDescriptor uniqueForSchema(SchemaDescriptor schema, Optional<String> name, IndexProvider.Descriptor providerDescriptor) {
        return new IndexDescriptor(schema, IndexDescriptor.Type.UNIQUE, name, providerDescriptor);
    }
}

