/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.File;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.schema.index.StoreIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexReader;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;

class FusionIndexAccessor
extends FusionIndexBase<IndexAccessor>
implements IndexAccessor {
    private final StoreIndexDescriptor descriptor;
    private final FusionIndexProvider.DropAction dropAction;

    FusionIndexAccessor(SlotSelector slotSelector, InstanceSelector<IndexAccessor> instanceSelector, StoreIndexDescriptor descriptor, FusionIndexProvider.DropAction dropAction) {
        super(slotSelector, instanceSelector);
        this.descriptor = descriptor;
        this.dropAction = dropAction;
    }

    @Override
    public void drop() {
        this.instanceSelector.forAll(IndexAccessor::drop);
        this.dropAction.drop(this.descriptor.getId());
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        LazyInstanceSelector<IndexUpdater> updaterSelector = new LazyInstanceSelector<IndexUpdater>(slot -> ((IndexAccessor)this.instanceSelector.select((IndexSlot)((Object)slot))).newUpdater(mode));
        return new FusionIndexUpdater(this.slotSelector, updaterSelector);
    }

    @Override
    public void force(IOLimiter ioLimiter) {
        this.instanceSelector.forAll(accessor -> accessor.force(ioLimiter));
    }

    @Override
    public void refresh() {
        this.instanceSelector.forAll(IndexAccessor::refresh);
    }

    @Override
    public void close() {
        this.instanceSelector.close(IndexAccessor::close);
    }

    @Override
    public IndexReader newReader() {
        LazyInstanceSelector<IndexReader> readerSelector = new LazyInstanceSelector<IndexReader>(slot -> ((IndexAccessor)this.instanceSelector.select((IndexSlot)((Object)slot))).newReader());
        return new FusionIndexReader(this.slotSelector, readerSelector, this.descriptor);
    }

    @Override
    public BoundedIterable<Long> newAllEntriesReader() {
        final Iterable entries = this.instanceSelector.transform(IndexAccessor::newAllEntriesReader);
        return new BoundedIterable<Long>(){

            @Override
            public long maxCount() {
                long sum = 0L;
                for (BoundedIterable entry : entries) {
                    long maxCount = entry.maxCount();
                    if (maxCount == -1L) {
                        return -1L;
                    }
                    sum += maxCount;
                }
                return sum;
            }

            @Override
            public void close() throws Exception {
                FusionIndexBase.forAll(AutoCloseable::close, entries);
            }

            @Override
            public Iterator<Long> iterator() {
                return Iterables.concat((Iterable)entries).iterator();
            }
        };
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        return Iterators.concatResourceIterators(this.instanceSelector.transform(IndexAccessor::snapshotFiles).iterator());
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
        for (IndexSlot slot : IndexSlot.values()) {
            ((IndexAccessor)this.instanceSelector.select(slot)).verifyDeferredConstraints(nodePropertyAccessor);
        }
    }

    @Override
    public boolean isDirty() {
        return Iterables.stream(this.instanceSelector.transform(IndexAccessor::isDirty)).anyMatch(Boolean::booleanValue);
    }

    @Override
    public void validateBeforeCommit(Value[] tuple) {
        ((IndexAccessor)this.instanceSelector.select(this.slotSelector.selectSlot(tuple, GROUP_OF))).validateBeforeCommit(tuple);
    }
}

