/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.schema.index.StoreIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexCache;
import org.neo4j.kernel.impl.index.schema.SpatialIndexFiles;
import org.neo4j.kernel.impl.index.schema.SpatialIndexKey;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPartReader;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPopulatingUpdater;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;

class SpatialIndexPopulator
extends SpatialIndexCache<PartPopulator>
implements IndexPopulator {
    SpatialIndexPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, SpatialIndexFiles spatialIndexFiles, PageCache pageCache, FileSystemAbstraction fs, IndexProvider.Monitor monitor, SpaceFillingCurveConfiguration configuration) {
        super(new PartFactory(pageCache, fs, spatialIndexFiles, descriptor, monitor, samplingConfig, configuration));
    }

    @Override
    public synchronized void create() {
        FusionIndexBase.forAll(NativeIndexPopulator::clear, this);
        if (!this.iterator().hasNext()) {
            this.select(CoordinateReferenceSystem.WGS84);
        }
    }

    @Override
    public synchronized void drop() {
        FusionIndexBase.forAll(NativeIndexPopulator::drop, this);
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException {
        HashMap<CoordinateReferenceSystem, List> batchMap = new HashMap<CoordinateReferenceSystem, List>();
        for (IndexEntryUpdate<?> indexEntryUpdate : updates) {
            PointValue point = (PointValue)indexEntryUpdate.values()[0];
            List batch = batchMap.computeIfAbsent(point.getCoordinateReferenceSystem(), k -> new ArrayList());
            batch.add(indexEntryUpdate);
        }
        for (Map.Entry entry : batchMap.entrySet()) {
            PartPopulator partPopulator = (PartPopulator)this.select((CoordinateReferenceSystem)entry.getKey());
            partPopulator.add((Collection)entry.getValue());
        }
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
    }

    @Override
    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
        return new SpatialIndexPopulatingUpdater(this, accessor);
    }

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully) {
        this.closeInstantiateCloseLock();
        for (NativeIndexPopulator part : this) {
            part.close(populationCompletedSuccessfully);
        }
    }

    @Override
    public synchronized void markAsFailed(String failure) {
        for (NativeIndexPopulator part : this) {
            part.markAsFailed(failure);
        }
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        Value[] values = update.values();
        assert (values.length == 1);
        ((PartPopulator)this.uncheckedSelect(((PointValue)values[0]).getCoordinateReferenceSystem())).includeSample(update);
    }

    @Override
    public IndexSample sampleResult() {
        ArrayList<IndexSample> samples = new ArrayList<IndexSample>();
        for (PartPopulator partPopulator : this) {
            samples.add(partPopulator.sampleResult());
        }
        return FusionIndexSampler.combineSamples(samples);
    }

    static class PartFactory
    implements SpatialIndexCache.Factory<PartPopulator> {
        private final PageCache pageCache;
        private final FileSystemAbstraction fs;
        private final SpatialIndexFiles spatialIndexFiles;
        private final StoreIndexDescriptor descriptor;
        private final IndexProvider.Monitor monitor;
        private final IndexSamplingConfig samplingConfig;
        private final SpaceFillingCurveConfiguration configuration;

        PartFactory(PageCache pageCache, FileSystemAbstraction fs, SpatialIndexFiles spatialIndexFiles, StoreIndexDescriptor descriptor, IndexProvider.Monitor monitor, IndexSamplingConfig samplingConfig, SpaceFillingCurveConfiguration configuration) {
            this.pageCache = pageCache;
            this.fs = fs;
            this.spatialIndexFiles = spatialIndexFiles;
            this.descriptor = descriptor;
            this.monitor = monitor;
            this.samplingConfig = samplingConfig;
            this.configuration = configuration;
        }

        @Override
        public PartPopulator newSpatial(CoordinateReferenceSystem crs) {
            return this.create(this.spatialIndexFiles.forCrs(crs).getLayoutForNewIndex());
        }

        private PartPopulator create(SpatialIndexFiles.SpatialFileLayout fileLayout) {
            PartPopulator populator = new PartPopulator(this.pageCache, this.fs, fileLayout, this.monitor, this.descriptor, this.samplingConfig, this.configuration);
            populator.create();
            return populator;
        }
    }

    static class PartPopulator
    extends NativeIndexPopulator<SpatialIndexKey, NativeIndexValue> {
        private final SpaceFillingCurveConfiguration configuration;
        private final SpaceFillingCurveSettings settings;

        PartPopulator(PageCache pageCache, FileSystemAbstraction fs, SpatialIndexFiles.SpatialFileLayout fileLayout, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, SpaceFillingCurveConfiguration configuration) {
            super(pageCache, fs, fileLayout.getIndexFile(), fileLayout.layout, monitor, descriptor, samplingConfig);
            this.configuration = configuration;
            this.settings = fileLayout.settings;
        }

        @Override
        IndexReader newReader() {
            return new SpatialIndexPartReader(this.tree, this.layout, this.samplingConfig, this.descriptor, this.configuration);
        }

        @Override
        public synchronized void create() {
            this.create(this.settings.headerWriter((byte)2));
        }

        @Override
        void markTreeAsOnline() {
            this.tree.checkpoint(IOLimiter.UNLIMITED, this.settings.headerWriter((byte)1));
        }
    }
}

