/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.schema.index.StoreIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeAllEntriesReader;
import org.neo4j.kernel.impl.index.schema.NativeIndex;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.schema.IndexReader;

public abstract class NativeIndexAccessor<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndex<KEY, VALUE>
implements IndexAccessor {
    private final NativeIndexUpdater<KEY, VALUE> singleUpdater;
    final IndexSamplingConfig samplingConfig;

    NativeIndexAccessor(PageCache pageCache, FileSystemAbstraction fs, File storeFile, Layout<KEY, VALUE> layout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        super(pageCache, fs, storeFile, layout, monitor, descriptor);
        this.singleUpdater = new NativeIndexUpdater<NativeIndexKey, NativeIndexValue>((NativeIndexKey)((Object)layout.newKey()), (NativeIndexValue)layout.newValue());
        this.samplingConfig = samplingConfig;
        this.instantiateTree(recoveryCleanupWorkCollector, GBPTree.NO_HEADER_WRITER);
    }

    @Override
    public void drop() {
        this.closeTree();
        try {
            this.fileSystem.deleteFileOrThrow(this.storeFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public NativeIndexUpdater<KEY, VALUE> newUpdater(IndexUpdateMode mode) {
        this.assertOpen();
        try {
            return this.singleUpdater.initialize(this.tree.writer());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void force(IOLimiter ioLimiter) {
        this.tree.checkpoint(ioLimiter);
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
        this.closeTree();
    }

    @Override
    public boolean isDirty() {
        return this.tree.wasDirtyOnStartup();
    }

    @Override
    public abstract IndexReader newReader();

    @Override
    public BoundedIterable<Long> newAllEntriesReader() {
        return new NativeAllEntriesReader(this.tree, this.layout);
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.storeFile));
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
    }
}

