/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.kernel.impl.newapi.RelationshipDirection;
import org.neo4j.storageengine.api.Direction;

public class RelationshipChangesForNode {
    private final DiffStrategy diffStrategy;
    private MutableIntObjectMap<MutableLongSet> outgoing;
    private MutableIntObjectMap<MutableLongSet> incoming;
    private MutableIntObjectMap<MutableLongSet> loops;

    public RelationshipChangesForNode(DiffStrategy diffStrategy) {
        this.diffStrategy = diffStrategy;
    }

    public void addRelationship(long relId, int typeId, Direction direction) {
        MutableIntObjectMap<MutableLongSet> relTypeToRelsMap = this.getTypeToRelMapForDirection(direction);
        MutableLongSet rels = (MutableLongSet)relTypeToRelsMap.getIfAbsentPut(typeId, LongHashSet::new);
        rels.add(relId);
    }

    public boolean removeRelationship(long relId, int typeId, Direction direction) {
        MutableIntObjectMap<MutableLongSet> relTypeToRelsMap = this.getTypeToRelMapForDirection(direction);
        MutableLongSet rels = (MutableLongSet)relTypeToRelsMap.get(typeId);
        if (rels != null && rels.remove(relId)) {
            if (rels.isEmpty()) {
                relTypeToRelsMap.remove(typeId);
            }
            return true;
        }
        return false;
    }

    public int augmentDegree(RelationshipDirection direction, int degree, int typeId) {
        switch (direction) {
            case INCOMING: {
                if (this.incoming == null || !this.incoming.containsKey(typeId)) break;
                return this.diffStrategy.augmentDegree(degree, ((MutableLongSet)this.incoming.get(typeId)).size());
            }
            case OUTGOING: {
                if (this.outgoing == null || !this.outgoing.containsKey(typeId)) break;
                return this.diffStrategy.augmentDegree(degree, ((MutableLongSet)this.outgoing.get(typeId)).size());
            }
            case LOOP: {
                if (this.loops == null || !this.loops.containsKey(typeId)) break;
                return this.diffStrategy.augmentDegree(degree, ((MutableLongSet)this.loops.get(typeId)).size());
            }
            default: {
                throw new IllegalArgumentException("Unknown direction: " + (Object)((Object)direction));
            }
        }
        return degree;
    }

    public void clear() {
        if (this.outgoing != null) {
            this.outgoing.clear();
        }
        if (this.incoming != null) {
            this.incoming.clear();
        }
        if (this.loops != null) {
            this.loops.clear();
        }
    }

    private MutableIntObjectMap<MutableLongSet> outgoing() {
        if (this.outgoing == null) {
            this.outgoing = new IntObjectHashMap();
        }
        return this.outgoing;
    }

    private MutableIntObjectMap<MutableLongSet> incoming() {
        if (this.incoming == null) {
            this.incoming = new IntObjectHashMap();
        }
        return this.incoming;
    }

    private MutableIntObjectMap<MutableLongSet> loops() {
        if (this.loops == null) {
            this.loops = new IntObjectHashMap();
        }
        return this.loops;
    }

    private MutableIntObjectMap<MutableLongSet> getTypeToRelMapForDirection(Direction direction) {
        MutableIntObjectMap<MutableLongSet> relTypeToRelsMap;
        switch (direction) {
            case INCOMING: {
                relTypeToRelsMap = this.incoming();
                break;
            }
            case OUTGOING: {
                relTypeToRelsMap = this.outgoing();
                break;
            }
            case BOTH: {
                relTypeToRelsMap = this.loops();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction: " + (Object)((Object)direction));
            }
        }
        return relTypeToRelsMap;
    }

    public LongIterator getRelationships() {
        return PrimitiveLongCollections.concat((LongIterator[])new LongIterator[]{RelationshipChangesForNode.primitiveIds(this.incoming), RelationshipChangesForNode.primitiveIds(this.outgoing), RelationshipChangesForNode.primitiveIds(this.loops)});
    }

    public LongIterator getRelationships(RelationshipDirection direction, int type) {
        switch (direction) {
            case INCOMING: {
                return this.incoming != null ? RelationshipChangesForNode.primitiveIdsByType(this.incoming, type) : ImmutableEmptyLongIterator.INSTANCE;
            }
            case OUTGOING: {
                return this.outgoing != null ? RelationshipChangesForNode.primitiveIdsByType(this.outgoing, type) : ImmutableEmptyLongIterator.INSTANCE;
            }
            case LOOP: {
                return this.loops != null ? RelationshipChangesForNode.primitiveIdsByType(this.loops, type) : ImmutableEmptyLongIterator.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + (Object)((Object)direction));
    }

    private static LongIterator primitiveIds(IntObjectMap<MutableLongSet> map) {
        if (map == null) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }
        int size = Math.toIntExact(map.sumOfInt(PrimitiveIterable::size));
        LongHashSet ids = new LongHashSet(size);
        map.values().forEach(arg_0 -> ((MutableLongSet)ids).addAll(arg_0));
        return ids.longIterator();
    }

    private static LongIterator primitiveIdsByType(IntObjectMap<MutableLongSet> map, int type) {
        LongSet relationships = (LongSet)map.get(type);
        return relationships == null ? ImmutableEmptyLongIterator.INSTANCE : relationships.freeze().longIterator();
    }

    public static enum DiffStrategy {
        REMOVE{

            @Override
            int augmentDegree(int degree, int diff) {
                return degree - diff;
            }
        }
        ,
        ADD{

            @Override
            int augmentDegree(int degree, int diff) {
                return degree + diff;
            }
        };


        abstract int augmentDegree(int var1, int var2);
    }
}

