/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.schema.index.CapableIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.UpdateCountingIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.values.storable.Value;

public class OnlineIndexProxy
implements IndexProxy {
    private final long indexId;
    private final CapableIndexDescriptor capableIndexDescriptor;
    final IndexAccessor accessor;
    private final IndexStoreView storeView;
    private final IndexCountsRemover indexCountsRemover;
    private boolean started;
    private final boolean forcedIdempotentMode;

    OnlineIndexProxy(CapableIndexDescriptor capableIndexDescriptor, IndexAccessor accessor, IndexStoreView storeView, boolean forcedIdempotentMode) {
        assert (accessor != null);
        this.indexId = capableIndexDescriptor.getId();
        this.capableIndexDescriptor = capableIndexDescriptor;
        this.accessor = accessor;
        this.storeView = storeView;
        this.forcedIdempotentMode = forcedIdempotentMode;
        this.indexCountsRemover = new IndexCountsRemover(storeView, this.indexId);
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        IndexUpdater actual = this.accessor.newUpdater(this.escalateModeIfNecessary(mode));
        return this.started ? this.updateCountingUpdater(actual) : actual;
    }

    private IndexUpdateMode escalateModeIfNecessary(IndexUpdateMode mode) {
        if (this.forcedIdempotentMode) {
            if (mode != IndexUpdateMode.ONLINE) {
                throw new IllegalArgumentException("Unexpected mode " + (Object)((Object)mode) + " given that " + this + " has been marked with forced idempotent mode. Expected mode " + (Object)((Object)IndexUpdateMode.ONLINE));
            }
            return IndexUpdateMode.ONLINE_IDEMPOTENT;
        }
        return mode;
    }

    private IndexUpdater updateCountingUpdater(IndexUpdater indexUpdater) {
        return new UpdateCountingIndexUpdater(this.storeView, this.indexId, indexUpdater);
    }

    @Override
    public void drop() {
        this.indexCountsRemover.remove();
        this.accessor.drop();
    }

    @Override
    public CapableIndexDescriptor getDescriptor() {
        return this.capableIndexDescriptor;
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.ONLINE;
    }

    @Override
    public void force(IOLimiter ioLimiter) {
        this.accessor.force(ioLimiter);
    }

    @Override
    public void refresh() {
        this.accessor.refresh();
    }

    @Override
    public void close() throws IOException {
        this.accessor.close();
    }

    @Override
    public IndexReader newReader() {
        return this.accessor.newReader();
    }

    @Override
    public boolean awaitStoreScanCompleted() {
        return false;
    }

    @Override
    public void activate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void validateBeforeCommit(Value[] tuple) {
        this.accessor.validateBeforeCommit(tuple);
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        throw new IllegalStateException(this + " is ONLINE");
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return PopulationProgress.DONE;
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        return this.accessor.snapshotFiles();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[accessor:" + this.accessor + ", descriptor:" + this.capableIndexDescriptor + "]";
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
        this.accessor.verifyDeferredConstraints(nodePropertyAccessor);
    }
}

