/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.index.CapableIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.storageengine.api.EntityType;

public final class IndexMap
implements Cloneable {
    private final MutableLongObjectMap<IndexProxy> indexesById;
    private final Map<SchemaDescriptor, IndexProxy> indexesByDescriptor;
    private final MutableObjectLongMap<SchemaDescriptor> indexIdsByDescriptor;
    private final MutableIntObjectMap<Set<SchemaDescriptor>> descriptorsByLabel;
    private final MutableIntObjectMap<Set<SchemaDescriptor>> descriptorsByReltype;
    private final MutableIntObjectMap<Set<SchemaDescriptor>> nodeDescriptorsByProperty;
    private final MutableIntObjectMap<Set<SchemaDescriptor>> relationshipDescriptorsByProperty;
    private final Set<SchemaDescriptor> descriptorsForAllLabels;
    private final Set<SchemaDescriptor> descriptorsForAllReltypes;

    public IndexMap() {
        this((MutableLongObjectMap<IndexProxy>)new LongObjectHashMap(), new HashMap<SchemaDescriptor, IndexProxy>(), (MutableObjectLongMap<SchemaDescriptor>)new ObjectLongHashMap());
    }

    IndexMap(MutableLongObjectMap<IndexProxy> indexesById) {
        this(indexesById, IndexMap.indexesByDescriptor(indexesById), IndexMap.indexIdsByDescriptor(indexesById));
    }

    private IndexMap(MutableLongObjectMap<IndexProxy> indexesById, Map<SchemaDescriptor, IndexProxy> indexesByDescriptor, MutableObjectLongMap<SchemaDescriptor> indexIdsByDescriptor) {
        this.indexesById = indexesById;
        this.indexesByDescriptor = indexesByDescriptor;
        this.indexIdsByDescriptor = indexIdsByDescriptor;
        this.descriptorsByLabel = new IntObjectHashMap();
        this.descriptorsByReltype = new IntObjectHashMap();
        this.nodeDescriptorsByProperty = new IntObjectHashMap();
        this.relationshipDescriptorsByProperty = new IntObjectHashMap();
        this.descriptorsForAllLabels = new HashSet<SchemaDescriptor>();
        this.descriptorsForAllReltypes = new HashSet<SchemaDescriptor>();
        for (SchemaDescriptor schema : indexesByDescriptor.keySet()) {
            this.addDescriptorToLookups(schema);
        }
    }

    public IndexProxy getIndexProxy(long indexId) {
        return (IndexProxy)this.indexesById.get(indexId);
    }

    public IndexProxy getIndexProxy(SchemaDescriptor descriptor) {
        return this.indexesByDescriptor.get(descriptor);
    }

    public long getIndexId(SchemaDescriptor descriptor) {
        return this.indexIdsByDescriptor.get((Object)descriptor);
    }

    public void putIndexProxy(IndexProxy indexProxy) {
        CapableIndexDescriptor descriptor = indexProxy.getDescriptor();
        SchemaDescriptor schema = descriptor.schema();
        this.indexesById.put(descriptor.getId(), (Object)indexProxy);
        this.indexesByDescriptor.put(schema, indexProxy);
        this.indexIdsByDescriptor.put((Object)schema, descriptor.getId());
        this.addDescriptorToLookups(schema);
    }

    public IndexProxy removeIndexProxy(long indexId) {
        IndexProxy removedProxy = (IndexProxy)this.indexesById.remove(indexId);
        if (removedProxy == null) {
            return null;
        }
        SchemaDescriptor schema = removedProxy.getDescriptor().schema();
        this.indexesByDescriptor.remove(schema);
        if (schema.entityType() == EntityType.NODE) {
            if (SchemaDescriptor.isAnyEntityTokenSchema((SchemaDescriptor)schema)) {
                this.descriptorsForAllLabels.remove(schema);
            }
            this.removeFromLookup(schema.getEntityTokenIds(), schema, this.descriptorsByLabel);
            this.removeFromLookup(schema.getPropertyIds(), schema, this.nodeDescriptorsByProperty);
        } else if (schema.entityType() == EntityType.RELATIONSHIP) {
            if (SchemaDescriptor.isAnyEntityTokenSchema((SchemaDescriptor)schema)) {
                this.descriptorsForAllReltypes.remove(schema);
            }
            this.removeFromLookup(schema.getEntityTokenIds(), schema, this.descriptorsByReltype);
            this.removeFromLookup(schema.getPropertyIds(), schema, this.relationshipDescriptorsByProperty);
        }
        return removedProxy;
    }

    void forEachIndexProxy(LongObjectProcedure<IndexProxy> consumer) {
        this.indexesById.forEachKeyValue(consumer);
    }

    public Iterable<IndexProxy> getAllIndexProxies() {
        return this.indexesById.values();
    }

    public Set<SchemaDescriptor> getRelatedIndexes(long[] changedEntityTokens, long[] unchangedEntityTokens, IntSet properties, EntityType entityType) {
        switch (entityType) {
            case NODE: {
                return this.getRelatedDescriptors(changedEntityTokens, unchangedEntityTokens, properties, (IntObjectMap<Set<SchemaDescriptor>>)this.descriptorsByLabel, this.descriptorsForAllLabels, (IntObjectMap<Set<SchemaDescriptor>>)this.nodeDescriptorsByProperty);
            }
            case RELATIONSHIP: {
                return this.getRelatedDescriptors(changedEntityTokens, unchangedEntityTokens, properties, (IntObjectMap<Set<SchemaDescriptor>>)this.descriptorsByReltype, this.descriptorsForAllReltypes, (IntObjectMap<Set<SchemaDescriptor>>)this.relationshipDescriptorsByProperty);
            }
        }
        throw new IllegalArgumentException("The given EntityType cannot be indexed: " + entityType);
    }

    public IndexMap clone() {
        return new IndexMap((MutableLongObjectMap<IndexProxy>)LongObjectHashMap.newMap(this.indexesById), this.cloneMap(this.indexesByDescriptor), (MutableObjectLongMap<SchemaDescriptor>)new ObjectLongHashMap(this.indexIdsByDescriptor));
    }

    public Iterator<SchemaDescriptor> descriptors() {
        return this.indexesByDescriptor.keySet().iterator();
    }

    public LongIterator indexIds() {
        return this.indexesById.keySet().longIterator();
    }

    public int size() {
        return this.indexesById.size();
    }

    private <K, V> Map<K, V> cloneMap(Map<K, V> map) {
        HashMap<K, V> shallowCopy = new HashMap<K, V>(map.size());
        shallowCopy.putAll(map);
        return shallowCopy;
    }

    private void addDescriptorToLookups(SchemaDescriptor schema) {
        block7: {
            block6: {
                if (schema.entityType() != EntityType.NODE) break block6;
                if (SchemaDescriptor.isAnyEntityTokenSchema((SchemaDescriptor)schema)) {
                    this.descriptorsForAllLabels.add(schema);
                }
                for (int entityTokenId : schema.getEntityTokenIds()) {
                    this.addToLookup(entityTokenId, schema, this.descriptorsByLabel);
                }
                for (int propertyId : schema.getPropertyIds()) {
                    this.addToLookup(propertyId, schema, this.nodeDescriptorsByProperty);
                }
                break block7;
            }
            if (schema.entityType() != EntityType.RELATIONSHIP) break block7;
            if (SchemaDescriptor.isAnyEntityTokenSchema((SchemaDescriptor)schema)) {
                this.descriptorsForAllReltypes.add(schema);
            }
            for (int entityTokenId : schema.getEntityTokenIds()) {
                this.addToLookup(entityTokenId, schema, this.descriptorsByReltype);
            }
            for (int propertyId : schema.getPropertyIds()) {
                this.addToLookup(propertyId, schema, this.relationshipDescriptorsByProperty);
            }
        }
    }

    private void addToLookup(int key, SchemaDescriptor schema, MutableIntObjectMap<Set<SchemaDescriptor>> lookup) {
        HashSet<SchemaDescriptor> descriptors = (HashSet<SchemaDescriptor>)lookup.get(key);
        if (descriptors == null) {
            descriptors = new HashSet<SchemaDescriptor>();
            lookup.put(key, descriptors);
        }
        descriptors.add(schema);
    }

    private void removeFromLookup(int[] keys, SchemaDescriptor schema, MutableIntObjectMap<Set<SchemaDescriptor>> lookup) {
        for (int key : keys) {
            Set descriptors = (Set)lookup.get(key);
            descriptors.remove(schema);
            if (!descriptors.isEmpty()) continue;
            lookup.remove(key);
        }
    }

    private static Map<SchemaDescriptor, IndexProxy> indexesByDescriptor(LongObjectMap<IndexProxy> indexesById) {
        return indexesById.toMap((Function & Serializable)indexProxy -> indexProxy.getDescriptor().schema(), Functions.identity());
    }

    private static MutableObjectLongMap<SchemaDescriptor> indexIdsByDescriptor(LongObjectMap<IndexProxy> indexesById) {
        ObjectLongHashMap map = new ObjectLongHashMap(indexesById.size());
        indexesById.forEachKeyValue((arg_0, arg_1) -> IndexMap.lambda$indexIdsByDescriptor$9c2f860d$1((MutableObjectLongMap)map, arg_0, arg_1));
        return map;
    }

    private Set<SchemaDescriptor> getRelatedDescriptors(long[] changedEntityTokens, long[] unchangedEntityTokens, IntSet properties, IntObjectMap<Set<SchemaDescriptor>> descriptorsByEntityToken, Set<SchemaDescriptor> descriptorsForAllEntityTokens, IntObjectMap<Set<SchemaDescriptor>> descriptorsByProperty) {
        Set<SchemaDescriptor> indexesByProperties = this.extractIndexesByProperties(properties, descriptorsByProperty);
        Set<SchemaDescriptor> indexesByUnchangedEntityTokens = this.extractIndexesByEntityTokens(unchangedEntityTokens, descriptorsByEntityToken);
        indexesByUnchangedEntityTokens.addAll(descriptorsForAllEntityTokens);
        indexesByProperties.retainAll(indexesByUnchangedEntityTokens);
        Set<SchemaDescriptor> descriptors = this.extractIndexesByEntityTokens(changedEntityTokens, descriptorsByEntityToken);
        if (changedEntityTokens.length > 0) {
            descriptors.addAll(descriptorsForAllEntityTokens);
        }
        descriptors.addAll(indexesByProperties);
        return descriptors;
    }

    private Set<SchemaDescriptor> extractIndexesByEntityTokens(long[] entityTokenIds, IntObjectMap<Set<SchemaDescriptor>> descriptors) {
        HashSet<SchemaDescriptor> set = new HashSet<SchemaDescriptor>();
        for (long label : entityTokenIds) {
            Set forLabel = (Set)descriptors.get((int)label);
            if (forLabel == null) continue;
            set.addAll(forLabel);
        }
        return set;
    }

    private Set<SchemaDescriptor> extractIndexesByProperties(IntSet properties, IntObjectMap<Set<SchemaDescriptor>> descriptorsByProperty) {
        HashSet<SchemaDescriptor> set = new HashSet<SchemaDescriptor>();
        IntIterator iterator = properties.intIterator();
        while (iterator.hasNext()) {
            Set forProperty = (Set)descriptorsByProperty.get(iterator.next());
            if (forProperty == null) continue;
            set.addAll(forProperty);
        }
        return set;
    }

    private static /* synthetic */ void lambda$indexIdsByDescriptor$9c2f860d$1(MutableObjectLongMap map, long id, IndexProxy indexProxy) {
        map.put((Object)indexProxy.getDescriptor().schema(), id);
    }
}

