/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityCacheReader;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;

public class InputRelationshipCacheReader
extends InputEntityCacheReader {
    public InputRelationshipCacheReader(StoreChannel channel, StoreChannel header) throws IOException {
        super(channel, header);
    }

    @Override
    public InputChunk newChunk() {
        return new InputRelationshipDeserializer();
    }

    class InputRelationshipDeserializer
    extends InputEntityCacheReader.InputEntityDeserializer {
        protected String previousType;

        InputRelationshipDeserializer() {
            super(InputRelationshipCacheReader.this);
        }

        @Override
        public boolean next(InputEntityVisitor visitor) throws IOException {
            if (!this.readProperties(visitor)) {
                return false;
            }
            Group startNodeGroup = this.readGroup(0);
            Group endNodeGroup = this.readGroup(1);
            Object startNodeId = this.readValue();
            Object endNodeId = this.readValue();
            visitor.startId(startNodeId, startNodeGroup);
            visitor.endId(endNodeId, endNodeGroup);
            byte typeMode = this.channel.get();
            switch (typeMode) {
                case 0: {
                    visitor.type(this.previousType);
                    break;
                }
                case 1: {
                    this.previousType = (String)this.readToken((byte)2);
                    visitor.type(this.previousType);
                    break;
                }
                case 2: {
                    visitor.type(this.channel.getInt());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized type mode " + typeMode);
                }
            }
            return true;
        }
    }
}

