/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregator;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.ComponentInjectionException;
import org.neo4j.kernel.api.exceptions.ResourceCloseFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.CallableUserAggregationFunction;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.FailedLoadAggregatedFunction;
import org.neo4j.kernel.api.proc.FailedLoadFunction;
import org.neo4j.kernel.api.proc.FailedLoadProcedure;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.FieldInjections;
import org.neo4j.kernel.impl.proc.MethodSignatureCompiler;
import org.neo4j.kernel.impl.proc.NamingRestrictions;
import org.neo4j.kernel.impl.proc.OutputMappers;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.PerformsWrites;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;
import org.neo4j.procedure.UserFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;

class ReflectiveProcedureCompiler {
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final OutputMappers outputMappers;
    private final MethodSignatureCompiler inputSignatureDeterminer;
    private final FieldInjections safeFieldInjections;
    private final FieldInjections allFieldInjections;
    private final Log log;
    private final TypeMappers typeMappers;
    private final ProcedureConfig config;
    private final NamingRestrictions restrictions;

    ReflectiveProcedureCompiler(TypeMappers typeMappers, ComponentRegistry safeComponents, ComponentRegistry allComponents, Log log, ProcedureConfig config) {
        this(new MethodSignatureCompiler(typeMappers), new OutputMappers(typeMappers), new FieldInjections(safeComponents), new FieldInjections(allComponents), log, typeMappers, config, ReflectiveProcedureCompiler::rejectEmptyNamespace);
    }

    private ReflectiveProcedureCompiler(MethodSignatureCompiler inputSignatureCompiler, OutputMappers outputMappers, FieldInjections safeFieldInjections, FieldInjections allFieldInjections, Log log, TypeMappers typeMappers, ProcedureConfig config, NamingRestrictions restrictions) {
        this.inputSignatureDeterminer = inputSignatureCompiler;
        this.outputMappers = outputMappers;
        this.safeFieldInjections = safeFieldInjections;
        this.allFieldInjections = allFieldInjections;
        this.log = log;
        this.typeMappers = typeMappers;
        this.config = config;
        this.restrictions = restrictions;
    }

    List<CallableUserFunction> compileFunction(Class<?> fcnDefinition) throws KernelException {
        try {
            List functionMethods = Arrays.stream(fcnDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(UserFunction.class)).collect(Collectors.toList());
            if (functionMethods.isEmpty()) {
                return Collections.emptyList();
            }
            MethodHandle constructor = this.constructor(fcnDefinition);
            ArrayList<CallableUserFunction> out = new ArrayList<CallableUserFunction>(functionMethods.size());
            for (Method method : functionMethods) {
                String definedName;
                String valueName;
                QualifiedName funcName = this.extractName(fcnDefinition, method, valueName = method.getAnnotation(UserFunction.class).value(), definedName = method.getAnnotation(UserFunction.class).name());
                if (this.config.isWhitelisted(funcName.toString())) {
                    out.add(this.compileFunction(fcnDefinition, constructor, method, funcName));
                    continue;
                }
                this.log.warn(String.format("The function '%s' is not on the whitelist and won't be loaded.", funcName.toString()));
            }
            out.sort(Comparator.comparing(a -> a.signature().name().toString()));
            return out;
        }
        catch (KernelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Failed to compile function defined in `%s`: %s", new Object[]{fcnDefinition.getSimpleName(), e.getMessage()});
        }
    }

    List<CallableUserAggregationFunction> compileAggregationFunction(Class<?> fcnDefinition) throws KernelException {
        try {
            List methods = Arrays.stream(fcnDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(UserAggregationFunction.class)).collect(Collectors.toList());
            if (methods.isEmpty()) {
                return Collections.emptyList();
            }
            MethodHandle constructor = this.constructor(fcnDefinition);
            ArrayList<CallableUserAggregationFunction> out = new ArrayList<CallableUserAggregationFunction>(methods.size());
            for (Method method : methods) {
                String definedName;
                String valueName;
                QualifiedName funcName = this.extractName(fcnDefinition, method, valueName = method.getAnnotation(UserAggregationFunction.class).value(), definedName = method.getAnnotation(UserAggregationFunction.class).name());
                if (this.config.isWhitelisted(funcName.toString())) {
                    out.add(this.compileAggregationFunction(fcnDefinition, constructor, method, funcName));
                    continue;
                }
                this.log.warn(String.format("The function '%s' is not on the whitelist and won't be loaded.", funcName.toString()));
            }
            out.sort(Comparator.comparing(a -> a.signature().name().toString()));
            return out;
        }
        catch (KernelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Failed to compile function defined in `%s`: %s", new Object[]{fcnDefinition.getSimpleName(), e.getMessage()});
        }
    }

    List<CallableProcedure> compileProcedure(Class<?> procDefinition, String warning, boolean fullAccess) throws KernelException {
        try {
            List procedureMethods = Arrays.stream(procDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(Procedure.class)).collect(Collectors.toList());
            if (procedureMethods.isEmpty()) {
                return Collections.emptyList();
            }
            MethodHandle constructor = this.constructor(procDefinition);
            ArrayList<CallableProcedure> out = new ArrayList<CallableProcedure>(procedureMethods.size());
            for (Method method : procedureMethods) {
                String valueName = method.getAnnotation(Procedure.class).value();
                String definedName = method.getAnnotation(Procedure.class).name();
                QualifiedName procName = this.extractName(procDefinition, method, valueName, definedName);
                if (fullAccess || this.config.isWhitelisted(procName.toString())) {
                    out.add(this.compileProcedure(procDefinition, constructor, method, warning, fullAccess, procName));
                    continue;
                }
                this.log.warn(String.format("The procedure '%s' is not on the whitelist and won't be loaded.", procName.toString()));
            }
            out.sort(Comparator.comparing(a -> a.signature().name().toString()));
            return out;
        }
        catch (KernelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Failed to compile procedure defined in `%s`: %s", new Object[]{procDefinition.getSimpleName(), e.getMessage()});
        }
    }

    private CallableProcedure compileProcedure(Class<?> procDefinition, MethodHandle constructor, Method method, String warning, boolean fullAccess, QualifiedName procName) throws ProcedureException {
        List<FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(method);
        OutputMappers.OutputMapper outputMapper = this.outputMappers.mapper(method);
        String description = this.description(method);
        Procedure procedure = method.getAnnotation(Procedure.class);
        Mode mode = procedure.mode();
        boolean admin = method.isAnnotationPresent(Admin.class);
        if (method.isAnnotationPresent(PerformsWrites.class)) {
            if (procedure.mode() != Mode.DEFAULT) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Conflicting procedure annotation, cannot use PerformsWrites and mode", new Object[0]);
            }
            mode = Mode.WRITE;
        }
        String deprecated = this.deprecated(method, () -> ((Procedure)procedure).deprecatedBy(), "Use of @Procedure(deprecatedBy) without @Deprecated in " + procName);
        List<FieldInjections.FieldSetter> setters = this.allFieldInjections.setters(procDefinition);
        if (!fullAccess && !this.config.fullAccessFor(procName.toString())) {
            try {
                setters = this.safeFieldInjections.setters(procDefinition);
            }
            catch (ComponentInjectionException e) {
                description = this.describeAndLogLoadFailure(procName);
                ProcedureSignature signature = new ProcedureSignature(procName, inputSignature, outputMapper.signature(), Mode.DEFAULT, admin, null, new String[0], description, warning, false);
                return new FailedLoadProcedure(signature);
            }
        }
        ProcedureSignature signature = new ProcedureSignature(procName, inputSignature, outputMapper.signature(), mode, admin, deprecated, this.config.rolesFor(procName.toString()), description, warning, false);
        return new ReflectiveProcedure(signature, constructor, method, outputMapper, setters);
    }

    private String describeAndLogLoadFailure(QualifiedName name) {
        String nameStr = name.toString();
        String description = nameStr + " is unavailable because it is sandboxed and has dependencies outside of the sandbox. Sandboxing is controlled by the " + GraphDatabaseSettings.procedure_unrestricted.name() + " setting. Only unrestrict procedures you can trust with access to database internals.";
        this.log.warn(description);
        return description;
    }

    private CallableUserFunction compileFunction(Class<?> procDefinition, MethodHandle constructor, Method method, QualifiedName procName) throws ProcedureException, IllegalAccessException {
        this.restrictions.verify(procName);
        List<FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(method);
        Class<?> returnType = method.getReturnType();
        TypeMappers.TypeChecker typeChecker = this.typeMappers.checkerFor(returnType);
        String description = this.description(method);
        UserFunction function = method.getAnnotation(UserFunction.class);
        String deprecated = this.deprecated(method, () -> ((UserFunction)function).deprecatedBy(), "Use of @UserFunction(deprecatedBy) without @Deprecated in " + procName);
        List<FieldInjections.FieldSetter> setters = this.allFieldInjections.setters(procDefinition);
        if (!this.config.fullAccessFor(procName.toString())) {
            try {
                setters = this.safeFieldInjections.setters(procDefinition);
            }
            catch (ComponentInjectionException e) {
                description = this.describeAndLogLoadFailure(procName);
                UserFunctionSignature signature = new UserFunctionSignature(procName, inputSignature, typeChecker.type(), deprecated, this.config.rolesFor(procName.toString()), description, false);
                return new FailedLoadFunction(signature);
            }
        }
        UserFunctionSignature signature = new UserFunctionSignature(procName, inputSignature, typeChecker.type(), deprecated, this.config.rolesFor(procName.toString()), description, false);
        return new ReflectiveUserFunction(signature, constructor, method, typeChecker, (ValueMapper<Object>)this.typeMappers, setters);
    }

    private CallableUserAggregationFunction compileAggregationFunction(Class<?> definition, MethodHandle constructor, Method method, QualifiedName funcName) throws ProcedureException, IllegalAccessException {
        this.restrictions.verify(funcName);
        Method update = null;
        Method result = null;
        Class<?> aggregator = method.getReturnType();
        for (Method m : aggregator.getDeclaredMethods()) {
            if (m.isAnnotationPresent(UserAggregationUpdate.class)) {
                if (update != null) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Class '%s' contains multiple methods annotated with '@%s'.", new Object[]{aggregator.getSimpleName(), UserAggregationUpdate.class.getSimpleName()});
                }
                update = m;
            }
            if (!m.isAnnotationPresent(UserAggregationResult.class)) continue;
            if (result != null) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Class '%s' contains multiple methods annotated with '@%s'.", new Object[]{aggregator.getSimpleName(), UserAggregationResult.class.getSimpleName()});
            }
            result = m;
        }
        if (result == null || update == null) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Class '%s' must contain methods annotated with both '@%s' as well as '@%s'.", new Object[]{aggregator.getSimpleName(), UserAggregationResult.class.getSimpleName(), UserAggregationUpdate.class.getSimpleName()});
        }
        if (update.getReturnType() != Void.TYPE) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Update method '%s' in %s has type '%s' but must have return type 'void'.", new Object[]{update.getName(), aggregator.getSimpleName(), update.getReturnType().getSimpleName()});
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation method '%s' in %s must be public.", new Object[]{method.getName(), definition.getSimpleName()});
        }
        if (!Modifier.isPublic(aggregator.getModifiers())) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation class '%s' must be public.", new Object[]{aggregator.getSimpleName()});
        }
        if (!Modifier.isPublic(update.getModifiers())) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation update method '%s' in %s must be public.", new Object[]{update.getName(), aggregator.getSimpleName()});
        }
        if (!Modifier.isPublic(result.getModifiers())) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation result method '%s' in %s must be public.", new Object[]{result.getName(), aggregator.getSimpleName()});
        }
        List<FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(update);
        Class<?> returnType = result.getReturnType();
        TypeMappers.TypeChecker valueConverter = this.typeMappers.checkerFor(returnType);
        MethodHandle creator = this.lookup.unreflect(method);
        MethodHandle resultMethod = this.lookup.unreflect(result);
        String description = this.description(method);
        UserAggregationFunction function = method.getAnnotation(UserAggregationFunction.class);
        String deprecated = this.deprecated(method, () -> ((UserAggregationFunction)function).deprecatedBy(), "Use of @UserAggregationFunction(deprecatedBy) without @Deprecated in " + funcName);
        List<FieldInjections.FieldSetter> setters = this.allFieldInjections.setters(definition);
        if (!this.config.fullAccessFor(funcName.toString())) {
            try {
                setters = this.safeFieldInjections.setters(definition);
            }
            catch (ComponentInjectionException e) {
                description = this.describeAndLogLoadFailure(funcName);
                UserFunctionSignature signature = new UserFunctionSignature(funcName, inputSignature, valueConverter.type(), deprecated, this.config.rolesFor(funcName.toString()), description, false);
                return new FailedLoadAggregatedFunction(signature);
            }
        }
        UserFunctionSignature signature = new UserFunctionSignature(funcName, inputSignature, valueConverter.type(), deprecated, this.config.rolesFor(funcName.toString()), description, false);
        return new ReflectiveUserAggregationFunction(signature, constructor, creator, update, resultMethod, valueConverter, setters);
    }

    private String deprecated(Method method, Supplier<String> supplier, String warning) {
        String deprecatedBy = supplier.get();
        String deprecated = null;
        if (method.isAnnotationPresent(Deprecated.class)) {
            deprecated = deprecatedBy;
        } else if (!deprecatedBy.isEmpty()) {
            this.log.warn(warning);
            deprecated = deprecatedBy;
        }
        return deprecated;
    }

    private String description(Method method) {
        if (method.isAnnotationPresent(Description.class)) {
            return method.getAnnotation(Description.class).value();
        }
        return null;
    }

    private MethodHandle constructor(Class<?> procDefinition) throws ProcedureException {
        try {
            return this.lookup.unreflectConstructor(procDefinition.getConstructor(new Class[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Unable to find a usable public no-argument constructor in the class `%s`. Please add a valid, public constructor, recompile the class and try again.", new Object[]{procDefinition.getSimpleName()});
        }
    }

    private QualifiedName extractName(Class<?> procDefinition, Method m, String valueName, String definedName) {
        String procName;
        String string = procName = definedName.trim().isEmpty() ? valueName : definedName;
        if (procName.trim().length() > 0) {
            String[] split = procName.split("\\.");
            if (split.length == 1) {
                return new QualifiedName(new String[0], split[0]);
            }
            int lastElement = split.length - 1;
            return new QualifiedName(Arrays.copyOf(split, lastElement), split[lastElement]);
        }
        Package pkg = procDefinition.getPackage();
        String[] namespace = pkg == null ? new String[]{} : pkg.getName().split("\\.");
        String name = m.getName();
        return new QualifiedName(namespace, name);
    }

    public ReflectiveProcedureCompiler withoutNamingRestrictions() {
        return new ReflectiveProcedureCompiler(this.inputSignatureDeterminer, this.outputMappers, this.safeFieldInjections, this.allFieldInjections, this.log, this.typeMappers, this.config, name -> {});
    }

    private static void rejectEmptyNamespace(QualifiedName name) throws ProcedureException {
        if (name.namespace() == null || name.namespace().length == 0) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "It is not allowed to define functions in the root namespace please use a namespace, e.g. `@UserFunction(\"org.example.com.%s\")", new Object[]{name.name()});
        }
    }

    private static int[] computeIndexesToMap(List<FieldSignature> inputSignature) {
        ArrayList<Integer> integers = new ArrayList<Integer>();
        for (int i2 = 0; i2 < inputSignature.size(); ++i2) {
            if (!inputSignature.get(i2).needsMapping()) continue;
            integers.add(i2);
        }
        return integers.stream().mapToInt(i -> i).toArray();
    }

    private static class ReflectiveUserAggregationFunction
    extends ReflectiveBase
    implements CallableUserAggregationFunction {
        private final TypeMappers.TypeChecker typeChecker;
        private final UserFunctionSignature signature;
        private final MethodHandle constructor;
        private final MethodHandle creator;
        private final Method updateMethod;
        private final MethodHandle resultMethod;
        private final int[] indexesToMap;

        ReflectiveUserAggregationFunction(UserFunctionSignature signature, MethodHandle constructor, MethodHandle creator, Method updateMethod, MethodHandle resultMethod, TypeMappers.TypeChecker typeChecker, List<FieldInjections.FieldSetter> fieldSetters) {
            super(null, fieldSetters);
            this.constructor = constructor;
            this.creator = creator;
            this.updateMethod = updateMethod;
            this.resultMethod = resultMethod;
            this.signature = signature;
            this.typeChecker = typeChecker;
            this.indexesToMap = ReflectiveProcedureCompiler.computeIndexesToMap(signature.inputSignature());
        }

        @Override
        public UserFunctionSignature signature() {
            return this.signature;
        }

        @Override
        public UserAggregator create(Context ctx) throws ProcedureException {
            try {
                Object cls = this.constructor.invoke();
                this.inject(ctx, cls);
                final Object aggregator = this.creator.invoke(cls);
                final List inputSignature = this.signature.inputSignature();
                final int expectedNumberOfInputs = inputSignature.size();
                return new UserAggregator(){

                    public void update(Object[] input) throws ProcedureException {
                        try {
                            if (expectedNumberOfInputs != input.length) {
                                throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Function `%s` takes %d arguments but %d was provided.", new Object[]{signature.name(), expectedNumberOfInputs, input.length});
                            }
                            for (int indexToMap : indexesToMap) {
                                input[indexToMap] = ((FieldSignature)inputSignature.get(indexToMap)).map(input[indexToMap]);
                            }
                            updateMethod.invoke(aggregator, input);
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof Status.HasStatus) {
                                throw new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[0]);
                            }
                            Throwable cause = ExceptionUtils.getRootCause((Throwable)throwable);
                            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke function `%s`: %s", new Object[]{signature.name(), "Caused by: " + (cause != null ? cause : throwable)});
                        }
                    }

                    public Object result() throws ProcedureException {
                        try {
                            return typeChecker.typeCheck(resultMethod.invoke(aggregator));
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof Status.HasStatus) {
                                throw new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[0]);
                            }
                            Throwable cause = ExceptionUtils.getRootCause((Throwable)throwable);
                            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke function `%s`: %s", new Object[]{signature.name(), "Caused by: " + (cause != null ? cause : throwable)});
                        }
                    }
                };
            }
            catch (Throwable throwable) {
                if (throwable instanceof Status.HasStatus) {
                    throw new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[0]);
                }
                Throwable cause = ExceptionUtils.getRootCause((Throwable)throwable);
                throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke function `%s`: %s", new Object[]{this.signature.name(), "Caused by: " + (cause != null ? cause : throwable)});
            }
        }
    }

    private static class ReflectiveUserFunction
    extends ReflectiveBase
    implements CallableUserFunction {
        private final TypeMappers.TypeChecker typeChecker;
        private final UserFunctionSignature signature;
        private final MethodHandle constructor;
        private final Method udfMethod;
        private final int[] indexesToMap;

        ReflectiveUserFunction(UserFunctionSignature signature, MethodHandle constructor, Method udfMethod, TypeMappers.TypeChecker typeChecker, ValueMapper<Object> mapper, List<FieldInjections.FieldSetter> fieldSetters) {
            super(mapper, fieldSetters);
            this.constructor = constructor;
            this.udfMethod = udfMethod;
            this.signature = signature;
            this.typeChecker = typeChecker;
            this.indexesToMap = ReflectiveProcedureCompiler.computeIndexesToMap(signature.inputSignature());
        }

        @Override
        public UserFunctionSignature signature() {
            return this.signature;
        }

        @Override
        public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
            try {
                Object cls = this.constructor.invoke();
                this.inject(ctx, cls);
                Object rs = this.udfMethod.invoke(cls, this.mapToObjects("Function", this.signature.name(), this.signature.inputSignature(), input));
                return this.typeChecker.toValue(rs);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Status.HasStatus) {
                    throw new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[]{throwable});
                }
                Throwable cause = ExceptionUtils.getRootCause((Throwable)throwable);
                throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke function `%s`: %s", new Object[]{this.signature.name(), "Caused by: " + (cause != null ? cause : throwable)});
            }
        }
    }

    private static class ReflectiveProcedure
    extends ReflectiveBase
    implements CallableProcedure {
        private final ProcedureSignature signature;
        private final OutputMappers.OutputMapper outputMapper;
        private final MethodHandle constructor;
        private final Method procedureMethod;
        private final int[] indexesToMap;

        ReflectiveProcedure(ProcedureSignature signature, MethodHandle constructor, Method procedureMethod, OutputMappers.OutputMapper outputMapper, List<FieldInjections.FieldSetter> fieldSetters) {
            super(null, fieldSetters);
            this.constructor = constructor;
            this.procedureMethod = procedureMethod;
            this.signature = signature;
            this.outputMapper = outputMapper;
            this.indexesToMap = ReflectiveProcedureCompiler.computeIndexesToMap(signature.inputSignature());
        }

        @Override
        public ProcedureSignature signature() {
            return this.signature;
        }

        @Override
        public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input, ResourceTracker resourceTracker) throws ProcedureException {
            try {
                Object rs;
                List inputSignature = this.signature.inputSignature();
                if (inputSignature.size() != input.length) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Procedure `%s` takes %d arguments but %d was provided.", new Object[]{this.signature.name(), inputSignature.size(), input.length});
                }
                for (int indexToMap : this.indexesToMap) {
                    input[indexToMap] = ((FieldSignature)inputSignature.get(indexToMap)).map(input[indexToMap]);
                }
                Object cls = this.constructor.invoke();
                this.inject(ctx, cls);
                if (this.signature.admin()) {
                    SecurityContext securityContext = ctx.get(Context.SECURITY_CONTEXT);
                    securityContext.assertCredentialsNotExpired();
                    if (!securityContext.isAdmin()) {
                        throw new AuthorizationViolationException("Permission denied.");
                    }
                }
                if ((rs = this.procedureMethod.invoke(cls, input)) == null) {
                    return Iterators.asRawIterator(Collections.emptyIterator());
                }
                return new MappingIterator(((Stream)rs).iterator(), ((Stream)rs)::close, resourceTracker);
            }
            catch (Throwable throwable) {
                throw this.newProcedureException(throwable);
            }
        }

        private ProcedureException newProcedureException(Throwable throwable) {
            if (throwable instanceof InvocationTargetException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof Status.HasStatus) {
                return new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[0]);
            }
            Throwable cause = ExceptionUtils.getRootCause((Throwable)throwable);
            return new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke procedure `%s`: %s", new Object[]{this.signature.name(), "Caused by: " + (cause != null ? cause : throwable)});
        }

        private class MappingIterator
        implements RawIterator<Object[], ProcedureException>,
        Resource {
            private final Iterator<?> out;
            private Resource closeableResource;
            private ResourceTracker resourceTracker;

            MappingIterator(Iterator<?> out, Resource closeableResource, ResourceTracker resourceTracker) {
                this.out = out;
                this.closeableResource = closeableResource;
                this.resourceTracker = resourceTracker;
                resourceTracker.registerCloseableResource((AutoCloseable)closeableResource);
            }

            public boolean hasNext() throws ProcedureException {
                try {
                    boolean hasNext = this.out.hasNext();
                    if (!hasNext) {
                        this.close();
                    }
                    return hasNext;
                }
                catch (Throwable throwable) {
                    throw this.closeAndCreateProcedureException(throwable);
                }
            }

            public Object[] next() throws ProcedureException {
                try {
                    Object record = this.out.next();
                    return ReflectiveProcedure.this.outputMapper.apply(record);
                }
                catch (Throwable throwable) {
                    throw this.closeAndCreateProcedureException(throwable);
                }
            }

            public void close() {
                if (this.closeableResource != null) {
                    Resource resourceToClose = this.closeableResource;
                    this.closeableResource = null;
                    AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
                    autoCloseableArray[0] = () -> this.resourceTracker.unregisterCloseableResource((AutoCloseable)resourceToClose);
                    autoCloseableArray[1] = () -> ((Resource)resourceToClose).close();
                    IOUtils.closeAll(ResourceCloseFailureException.class, (AutoCloseable[])autoCloseableArray);
                }
            }

            private ProcedureException closeAndCreateProcedureException(Throwable t) {
                ProcedureException procedureException = ReflectiveProcedure.this.newProcedureException(t);
                try {
                    this.close();
                }
                catch (Exception exceptionDuringClose) {
                    try {
                        procedureException.addSuppressed((Throwable)exceptionDuringClose);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return procedureException;
            }
        }
    }

    private static abstract class ReflectiveBase {
        final List<FieldInjections.FieldSetter> fieldSetters;
        private final ValueMapper<Object> mapper;

        ReflectiveBase(ValueMapper<Object> mapper, List<FieldInjections.FieldSetter> fieldSetters) {
            this.mapper = mapper;
            this.fieldSetters = fieldSetters;
        }

        protected void inject(Context ctx, Object object) throws ProcedureException {
            for (FieldInjections.FieldSetter setter : this.fieldSetters) {
                setter.apply(ctx, object);
            }
        }

        protected Object[] mapToObjects(String type, QualifiedName name, List<FieldSignature> inputSignature, AnyValue[] input) throws ProcedureException {
            if (inputSignature.size() != input.length) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "%s `%s` takes %d arguments but %d was provided.", new Object[]{type, name, inputSignature.size(), input.length});
            }
            Object[] args = new Object[input.length];
            for (int i = 0; i < input.length; ++i) {
                args[i] = inputSignature.get(i).map(input[i], this.mapper);
            }
            return args;
        }
    }
}

