/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.CapabilityValidator;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.StringIndexKey;
import org.neo4j.kernel.impl.index.schema.StringIndexProvider;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class StringIndexReader
extends NativeIndexReader<StringIndexKey, NativeIndexValue> {
    StringIndexReader(GBPTree<StringIndexKey, NativeIndexValue> tree, Layout<StringIndexKey, NativeIndexValue> layout, IndexSamplingConfig samplingConfig, IndexDescriptor descriptor) {
        super(tree, layout, samplingConfig, descriptor);
    }

    @Override
    void validateQuery(IndexOrder indexOrder, IndexQuery[] predicates) {
        if (predicates.length != 1) {
            throw new UnsupportedOperationException();
        }
        CapabilityValidator.validateQuery(StringIndexProvider.CAPABILITY, indexOrder, predicates);
    }

    @Override
    boolean initializeRangeForQuery(StringIndexKey treeKeyFrom, StringIndexKey treeKeyTo, IndexQuery[] predicates) {
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exists: {
                treeKeyFrom.initAsLowest();
                treeKeyTo.initAsHighest();
                return false;
            }
            case exact: {
                IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
                treeKeyFrom.from(Long.MIN_VALUE, exactPredicate.value());
                treeKeyTo.from(Long.MAX_VALUE, exactPredicate.value());
                return false;
            }
            case range: {
                IndexQuery.RangePredicate rangePredicate = (IndexQuery.RangePredicate)predicate;
                this.initFromForRange(rangePredicate, treeKeyFrom);
                this.initToForRange(rangePredicate, treeKeyTo);
                return false;
            }
            case stringPrefix: {
                IndexQuery.StringPrefixPredicate prefixPredicate = (IndexQuery.StringPrefixPredicate)predicate;
                treeKeyFrom.initAsPrefixLow(prefixPredicate.prefix());
                treeKeyTo.initAsPrefixHigh(prefixPredicate.prefix());
                return false;
            }
            case stringSuffix: 
            case stringContains: {
                treeKeyFrom.initAsLowest();
                treeKeyTo.initAsHighest();
                return true;
            }
        }
        throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
    }

    private void initFromForRange(IndexQuery.RangePredicate<?> rangePredicate, StringIndexKey treeKeyFrom) {
        Value fromValue = rangePredicate.fromValue();
        if (fromValue == Values.NO_VALUE) {
            treeKeyFrom.initAsLowest();
        } else {
            treeKeyFrom.from(rangePredicate.fromInclusive() ? Long.MIN_VALUE : Long.MAX_VALUE, fromValue);
            treeKeyFrom.setCompareId(true);
        }
    }

    private void initToForRange(IndexQuery.RangePredicate<?> rangePredicate, StringIndexKey treeKeyTo) {
        Value toValue = rangePredicate.toValue();
        if (toValue == Values.NO_VALUE) {
            treeKeyTo.initAsHighest();
        } else {
            treeKeyTo.from(rangePredicate.toInclusive() ? Long.MAX_VALUE : Long.MIN_VALUE, toValue);
            treeKeyTo.setCompareId(true);
        }
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return true;
    }
}

