/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;

class NativeIndexUpdater<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
implements IndexUpdater {
    private final KEY treeKey;
    private final VALUE treeValue;
    private final ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger = new ConflictDetectingValueMerger(true);
    private Writer<KEY, VALUE> writer;
    private boolean closed = true;

    NativeIndexUpdater(KEY treeKey, VALUE treeValue) {
        this.treeKey = treeKey;
        this.treeValue = treeValue;
    }

    NativeIndexUpdater<KEY, VALUE> initialize(Writer<KEY, VALUE> writer) {
        if (!this.closed) {
            throw new IllegalStateException("Updater still open");
        }
        this.writer = writer;
        this.closed = false;
        return this;
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
        this.assertOpen();
        NativeIndexUpdater.processUpdate(this.treeKey, this.treeValue, update, this.writer, this.conflictDetectingValueMerger);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.closed = true;
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("Updater has been closed");
        }
    }

    static <KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> void processUpdate(KEY treeKey, VALUE treeValue, IndexEntryUpdate<?> update, Writer<KEY, VALUE> writer, ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger) throws IOException, IndexEntryConflictException {
        switch (update.updateMode()) {
            case ADDED: {
                NativeIndexUpdater.processAdd(treeKey, treeValue, update, writer, conflictDetectingValueMerger);
                break;
            }
            case CHANGED: {
                NativeIndexUpdater.processChange(treeKey, treeValue, update, writer, conflictDetectingValueMerger);
                break;
            }
            case REMOVED: {
                NativeIndexUpdater.processRemove(treeKey, update, writer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static <KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> void processRemove(KEY treeKey, IndexEntryUpdate<?> update, Writer<KEY, VALUE> writer) throws IOException {
        treeKey.from(update.getEntityId(), update.values());
        writer.remove(treeKey);
    }

    private static <KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> void processChange(KEY treeKey, VALUE treeValue, IndexEntryUpdate<?> update, Writer<KEY, VALUE> writer, ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger) throws IOException, IndexEntryConflictException {
        treeKey.from(update.getEntityId(), update.beforeValues());
        writer.remove(treeKey);
        treeKey.from(update.getEntityId(), update.values());
        treeValue.from(update.values());
        conflictDetectingValueMerger.controlConflictDetection(treeKey);
        writer.merge(treeKey, treeValue, conflictDetectingValueMerger);
        conflictDetectingValueMerger.checkConflict(update.values());
    }

    static <KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> void processAdd(KEY treeKey, VALUE treeValue, IndexEntryUpdate<?> update, Writer<KEY, VALUE> writer, ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger) throws IOException, IndexEntryConflictException {
        treeKey.from(update.getEntityId(), update.values());
        treeValue.from(update.values());
        conflictDetectingValueMerger.controlConflictDetection(treeKey);
        writer.merge(treeKey, treeValue, conflictDetectingValueMerger);
        conflictDetectingValueMerger.checkConflict(update.values());
    }
}

