/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.StoreIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.DeferredConflictCheckingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeIndex;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SamplingUtil;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.util.concurrent.Work;
import org.neo4j.util.concurrent.WorkSync;

public abstract class NativeIndexPopulator<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndex<KEY, VALUE>
implements IndexPopulator {
    public static final byte BYTE_FAILED = 0;
    static final byte BYTE_ONLINE = 1;
    static final byte BYTE_POPULATING = 2;
    private final KEY treeKey;
    private final VALUE treeValue;
    private final UniqueIndexSampler uniqueSampler;
    private final NonUniqueIndexSampler nonUniqueSampler;
    final IndexSamplingConfig samplingConfig;
    private WorkSync<IndexUpdateApply<KEY, VALUE>, IndexUpdateWork<KEY, VALUE>> additionsWorkSync;
    private WorkSync<IndexUpdateApply<KEY, VALUE>, IndexUpdateWork<KEY, VALUE>> updatesWorkSync;
    private byte[] failureBytes;
    private boolean dropped;
    private boolean closed;

    NativeIndexPopulator(PageCache pageCache, FileSystemAbstraction fs, File storeFile, Layout<KEY, VALUE> layout, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        super(pageCache, fs, storeFile, layout, monitor, descriptor);
        this.treeKey = (NativeIndexKey)((Object)layout.newKey());
        this.treeValue = (NativeIndexValue)layout.newValue();
        this.samplingConfig = samplingConfig;
        switch (descriptor.type()) {
            case GENERAL: {
                this.uniqueSampler = null;
                this.nonUniqueSampler = new DefaultNonUniqueIndexSampler(samplingConfig.sampleSizeLimit());
                break;
            }
            case UNIQUE: {
                this.uniqueSampler = new UniqueIndexSampler();
                this.nonUniqueSampler = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected index type " + (Object)((Object)descriptor.type()));
            }
        }
    }

    public void clear() throws IOException {
        NativeIndexPopulator.deleteFileIfPresent(this.fileSystem, this.storeFile);
    }

    @Override
    public synchronized void create() throws IOException {
        this.create(new NativeIndexHeaderWriter(2));
    }

    protected synchronized void create(Consumer<PageCursor> headerWriter) throws IOException {
        this.assertNotDropped();
        this.assertNotClosed();
        NativeIndexPopulator.deleteFileIfPresent(this.fileSystem, this.storeFile);
        this.instantiateTree(RecoveryCleanupWorkCollector.IMMEDIATE, headerWriter);
        boolean compareIds = this.descriptor.type() == IndexDescriptor.Type.GENERAL;
        this.additionsWorkSync = new WorkSync(new IndexUpdateApply<KEY, VALUE>(this.tree, this.treeKey, this.treeValue, new ConflictDetectingValueMerger(compareIds)));
        this.updatesWorkSync = new WorkSync(new IndexUpdateApply<KEY, VALUE>(this.tree, this.treeKey, this.treeValue, new ConflictDetectingValueMerger(true)));
    }

    @Override
    public synchronized void drop() {
        try {
            this.closeTree();
            NativeIndexPopulator.deleteFileIfPresent(this.fileSystem, this.storeFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.dropped = true;
            this.closed = true;
        }
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IOException, IndexEntryConflictException {
        this.applyWithWorkSync(this.additionsWorkSync, updates);
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
    }

    @Override
    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
        IndexUpdater updater = new IndexUpdater(){
            private boolean closed;
            private final Collection<IndexEntryUpdate<?>> updates = new ArrayList();

            @Override
            public void process(IndexEntryUpdate<?> update) {
                this.assertOpen();
                this.updates.add(update);
            }

            @Override
            public void close() throws IOException, IndexEntryConflictException {
                NativeIndexPopulator.this.applyWithWorkSync(NativeIndexPopulator.this.updatesWorkSync, this.updates);
                this.closed = true;
            }

            private void assertOpen() {
                if (this.closed) {
                    throw new IllegalStateException("Updater has been closed");
                }
            }
        };
        if (this.descriptor.type() == IndexDescriptor.Type.UNIQUE) {
            updater = new DeferredConflictCheckingIndexUpdater(updater, this::newReader, this.descriptor);
        }
        return updater;
    }

    abstract IndexReader newReader();

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully) throws IOException {
        if (populationCompletedSuccessfully && this.failureBytes != null) {
            throw new IllegalStateException("Can't mark index as online after it has been marked as failure");
        }
        try {
            if (populationCompletedSuccessfully) {
                this.assertPopulatorOpen();
                this.markTreeAsOnline();
            } else {
                this.assertNotDropped();
                this.ensureTreeInstantiated();
                this.markTreeAsFailed();
            }
        }
        finally {
            this.closeTree();
            this.closed = true;
        }
    }

    private void applyWithWorkSync(WorkSync<IndexUpdateApply<KEY, VALUE>, IndexUpdateWork<KEY, VALUE>> workSync, Collection<? extends IndexEntryUpdate<?>> updates) throws IOException, IndexEntryConflictException {
        try {
            workSync.apply(new IndexUpdateWork(updates));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof IndexEntryConflictException) {
                throw (IndexEntryConflictException)cause;
            }
            throw new IOException(cause);
        }
    }

    private void assertNotDropped() {
        if (this.dropped) {
            throw new IllegalStateException("Populator has already been dropped.");
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }

    @Override
    public void markAsFailed(String failure) {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
    }

    private void ensureTreeInstantiated() throws IOException {
        if (this.tree == null) {
            this.instantiateTree(RecoveryCleanupWorkCollector.IGNORE, GBPTree.NO_HEADER_WRITER);
        }
    }

    private void assertPopulatorOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }

    private void markTreeAsFailed() throws IOException {
        if (this.failureBytes == null) {
            this.failureBytes = ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        this.tree.checkpoint(IOLimiter.UNLIMITED, (Consumer)new FailureHeaderWriter(this.failureBytes));
    }

    void markTreeAsOnline() throws IOException {
        this.tree.checkpoint(IOLimiter.UNLIMITED, pc -> pc.putByte((byte)1));
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        switch (this.descriptor.type()) {
            case GENERAL: {
                this.updateNonUniqueSample(update);
                break;
            }
            case UNIQUE: {
                this.updateUniqueSample(update);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected index type " + (Object)((Object)this.descriptor.type()));
            }
        }
    }

    private void updateUniqueSample(IndexEntryUpdate<?> update) {
        switch (update.updateMode()) {
            case ADDED: {
                this.uniqueSampler.increment(1L);
                break;
            }
            case REMOVED: {
                this.uniqueSampler.increment(-1L);
                break;
            }
            case CHANGED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported update mode type:" + (Object)((Object)update.updateMode()));
            }
        }
    }

    private void updateNonUniqueSample(IndexEntryUpdate<?> update) {
        String encodedValues = SamplingUtil.encodedStringValuesForSampling(update.values());
        switch (update.updateMode()) {
            case ADDED: {
                this.nonUniqueSampler.include(encodedValues);
                break;
            }
            case REMOVED: {
                this.nonUniqueSampler.exclude(encodedValues);
                break;
            }
            case CHANGED: {
                this.nonUniqueSampler.exclude(SamplingUtil.encodedStringValuesForSampling(update.beforeValues()));
                this.nonUniqueSampler.include(encodedValues);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported update mode type:" + (Object)((Object)update.updateMode()));
            }
        }
    }

    @Override
    public IndexSample sampleResult() {
        switch (this.descriptor.type()) {
            case GENERAL: {
                return this.nonUniqueSampler.result();
            }
            case UNIQUE: {
                return this.uniqueSampler.result();
            }
        }
        throw new IllegalArgumentException("Unexpected index type " + (Object)((Object)this.descriptor.type()));
    }

    private static void deleteFileIfPresent(FileSystemAbstraction fs, File storeFile) throws IOException {
        try {
            fs.deleteFileOrThrow(storeFile);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    static class IndexUpdateWork<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
    implements Work<IndexUpdateApply<KEY, VALUE>, IndexUpdateWork<KEY, VALUE>> {
        private final Collection<? extends IndexEntryUpdate<?>> updates;

        IndexUpdateWork(Collection<? extends IndexEntryUpdate<?>> updates) {
            this.updates = updates;
        }

        public IndexUpdateWork<KEY, VALUE> combine(IndexUpdateWork<KEY, VALUE> work) {
            ArrayList combined = new ArrayList(this.updates);
            combined.addAll(work.updates);
            return new IndexUpdateWork<KEY, VALUE>(combined);
        }

        public void apply(IndexUpdateApply<KEY, VALUE> indexUpdateApply) throws Exception {
            indexUpdateApply.process(this.updates);
        }
    }

    static class IndexUpdateApply<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> {
        private final GBPTree<KEY, VALUE> tree;
        private final KEY treeKey;
        private final VALUE treeValue;
        private final ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger;

        IndexUpdateApply(GBPTree<KEY, VALUE> tree, KEY treeKey, VALUE treeValue, ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger) {
            this.tree = tree;
            this.treeKey = treeKey;
            this.treeValue = treeValue;
            this.conflictDetectingValueMerger = conflictDetectingValueMerger;
        }

        void process(Iterable<? extends IndexEntryUpdate<?>> indexEntryUpdates) throws Exception {
            try (Writer writer = this.tree.writer();){
                for (IndexEntryUpdate<?> indexEntryUpdate : indexEntryUpdates) {
                    NativeIndexUpdater.processUpdate(this.treeKey, this.treeValue, indexEntryUpdate, writer, this.conflictDetectingValueMerger);
                }
            }
        }
    }
}

