/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.hashing.HashFunction;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaComputer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaProcessor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.lock.ResourceType;

public class MultiTokenSchemaDescriptor
implements SchemaDescriptor {
    private static final HashFunction HASH_FUNCTION = HashFunction.incrementalXXH64();
    private final int[] entityTokens;
    private final EntityType entityType;
    private final int[] propertyIds;
    private final int key;

    MultiTokenSchemaDescriptor(int[] entityTokens, EntityType entityType, int[] propertyIds) {
        this.entityTokens = entityTokens;
        Arrays.sort(this.entityTokens);
        this.entityType = entityType;
        this.propertyIds = propertyIds;
        Arrays.sort(this.propertyIds);
        long hash = HASH_FUNCTION.initialise(81985529216486895L + (long)entityType.ordinal());
        for (int entityToken : this.entityTokens) {
            hash = HASH_FUNCTION.update(hash, (long)entityToken);
        }
        for (int propertyId : this.propertyIds) {
            hash = HASH_FUNCTION.update(hash, (long)propertyId);
        }
        hash = HASH_FUNCTION.finalise(hash);
        this.key = HASH_FUNCTION.toInt(hash);
    }

    public boolean isAffected(long[] entityTokenIds) {
        if (SchemaDescriptor.isAnyEntityTokenSchema((SchemaDescriptor)this)) {
            return true;
        }
        for (int id : this.entityTokens) {
            if (!ArrayUtils.contains((long[])entityTokenIds, (long)id)) continue;
            return true;
        }
        return false;
    }

    public <R> R computeWith(SchemaComputer<R> computer) {
        return (R)computer.computeSpecific((SchemaDescriptor)this);
    }

    public void processWith(SchemaProcessor processor) {
        processor.processSpecific((SchemaDescriptor)this);
    }

    public String toString() {
        return "MultiTokenSchemaDescriptor[" + this.userDescription(SchemaUtil.idTokenNameLookup) + "]";
    }

    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format(this.entityType + ":%s(%s)", Arrays.stream(tokenNameLookup.entityTokensGetNames(this.entityType, this.entityTokens)).collect(Collectors.joining(", ")), SchemaUtil.niceProperties((TokenNameLookup)tokenNameLookup, (int[])this.propertyIds));
    }

    public int[] getPropertyIds() {
        return this.propertyIds;
    }

    public int[] getEntityTokenIds() {
        return this.entityTokens;
    }

    public int keyId() {
        return this.key;
    }

    public ResourceType keyType() {
        return ResourceTypes.SCHEMA;
    }

    public EntityType entityType() {
        return this.entityType;
    }

    public SchemaDescriptor.PropertySchemaType propertySchemaType() {
        return SchemaDescriptor.PropertySchemaType.PARTIAL_ANY_TOKEN;
    }

    public SchemaDescriptor schema() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTokenSchemaDescriptor that = (MultiTokenSchemaDescriptor)o;
        return Arrays.equals(this.entityTokens, that.entityTokens) && this.entityType == that.entityType && Arrays.equals(this.propertyIds, that.propertyIds);
    }

    public int hashCode() {
        int result = Objects.hash(this.entityType);
        result = 31 * result + Arrays.hashCode(this.entityTokens);
        result = 31 * result + Arrays.hashCode(this.propertyIds);
        return result;
    }
}

