/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.kernel.api.query.CompilerInfo;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.IndexUsage;
import org.neo4j.kernel.api.query.PageCounterValues;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.values.virtual.MapValue;

public class QuerySnapshot {
    private final ExecutingQuery query;
    private final CompilerInfo compilerInfo;
    private final long compilationTimeMillis;
    private final long elapsedTimeMillis;
    private final long cpuTimeMillis;
    private final long waitTimeMillis;
    private final String status;
    private final Map<String, Object> resourceInfo;
    private final List<ActiveLock> waitingLocks;
    private final long activeLockCount;
    private final long allocatedBytes;
    private final PageCounterValues page;

    QuerySnapshot(ExecutingQuery query, CompilerInfo compilerInfo, PageCounterValues page, long compilationTimeMillis, long elapsedTimeMillis, long cpuTimeMillis, long waitTimeMillis, String status, Map<String, Object> resourceInfo, List<ActiveLock> waitingLocks, long activeLockCount, long allocatedBytes) {
        this.query = query;
        this.compilerInfo = compilerInfo;
        this.page = page;
        this.compilationTimeMillis = compilationTimeMillis;
        this.elapsedTimeMillis = elapsedTimeMillis;
        this.cpuTimeMillis = cpuTimeMillis;
        this.waitTimeMillis = waitTimeMillis;
        this.status = status;
        this.resourceInfo = resourceInfo;
        this.waitingLocks = waitingLocks;
        this.activeLockCount = activeLockCount;
        this.allocatedBytes = allocatedBytes;
    }

    public long internalQueryId() {
        return this.query.internalQueryId();
    }

    public String queryText() {
        return this.query.queryText();
    }

    public MapValue queryParameters() {
        return this.query.queryParameters();
    }

    public String username() {
        return this.query.username();
    }

    public ClientConnectionInfo clientConnection() {
        return this.query.clientConnection();
    }

    public Map<String, Object> transactionAnnotationData() {
        return this.query.transactionAnnotationData();
    }

    public long activeLockCount() {
        return this.activeLockCount;
    }

    public String planner() {
        return this.compilerInfo == null ? null : this.compilerInfo.planner();
    }

    public String runtime() {
        return this.compilerInfo == null ? null : this.compilerInfo.runtime();
    }

    public List<Map<String, String>> indexes() {
        if (this.compilerInfo == null) {
            return Collections.emptyList();
        }
        return this.compilerInfo.indexes().stream().map(IndexUsage::asMap).collect(Collectors.toList());
    }

    public String status() {
        return this.status;
    }

    public Map<String, Object> resourceInformation() {
        return this.resourceInfo;
    }

    public long startTimestampMillis() {
        return this.query.startTimestampMillis();
    }

    public long compilationTimeMillis() {
        return this.compilationTimeMillis;
    }

    public long waitTimeMillis() {
        return this.waitTimeMillis;
    }

    public long elapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public Long cpuTimeMillis() {
        return this.cpuTimeMillis < 0L ? null : Long.valueOf(this.cpuTimeMillis);
    }

    public Long idleTimeMillis() {
        return this.cpuTimeMillis < 0L ? null : Long.valueOf(this.elapsedTimeMillis - this.cpuTimeMillis - this.waitTimeMillis);
    }

    public Long allocatedBytes() {
        return this.allocatedBytes < 0L ? null : Long.valueOf(this.allocatedBytes);
    }

    public long pageHits() {
        return this.page.hits;
    }

    public long pageFaults() {
        return this.page.faults;
    }

    public List<ActiveLock> waitingLocks() {
        return this.waitingLocks;
    }
}

