/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DatabaseDiagnostics;
import org.neo4j.kernel.NeoStoreKernelModule;
import org.neo4j.kernel.NeoStoreTransactionLogModule;
import org.neo4j.kernel.api.InwardKernel;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.dependency.AllByPrioritySelectionStrategy;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.ExplicitIndexProvider;
import org.neo4j.kernel.impl.api.KernelImpl;
import org.neo4j.kernel.impl.api.KernelTransactionMonitorScheduler;
import org.neo4j.kernel.impl.api.KernelTransactionTimeoutMonitor;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StackingQueryRegistrationOperations;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.format.RecordFormatPropertyConfigurator;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.storemigration.DatabaseMigrator;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.StoreMigrator;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogVersionUpgradeChecker;
import org.neo4j.kernel.impl.transaction.log.LoggingLogFileMonitor;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointScheduler;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFileCreationMonitor;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruningImpl;
import org.neo4j.kernel.impl.transaction.log.reverse.ReverseTransactionCursorLoggingMonitor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedSingleFileTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotationImpl;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.impl.util.monitoring.LogProgressReporter;
import org.neo4j.kernel.info.DiagnosticsExtractor;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.TransactionEventHandlers;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.lifecycle.Lifecycles;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.DefaultRecoveryService;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.kernel.recovery.LoggingLogTailScannerMonitor;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.VisibleForTesting;

public class NeoStoreDataSource
extends LifecycleAdapter {
    public static final String DEFAULT_DATA_SOURCE_NAME = "nioneodb";
    private final boolean failOnCorruptedLogFiles = FeatureToggles.flag(NeoStoreDataSource.class, (String)"failOnCorruptedLogFiles", (boolean)false);
    private final Monitors monitors;
    private final Tracers tracers;
    private final Log msgLog;
    private final LogService logService;
    private final AutoIndexing autoIndexing;
    private final LogProvider logProvider;
    private final DependencyResolver dependencyResolver;
    private final TokenNameLookup tokenNameLookup;
    private final TokenHolders tokenHolders;
    private final StatementLocksFactory statementLocksFactory;
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionEventHandlers transactionEventHandlers;
    private final IdGeneratorFactory idGeneratorFactory;
    private final JobScheduler scheduler;
    private final Config config;
    private final LockService lockService;
    private final IndexingService.Monitor indexingServiceMonitor;
    private final FileSystemAbstraction fs;
    private final TransactionMonitor transactionMonitor;
    private final DatabaseHealth databaseHealth;
    private final LogFileCreationMonitor physicalLogMonitor;
    private final TransactionHeaderInformationFactory transactionHeaderInformationFactory;
    private final CommitProcessFactory commitProcessFactory;
    private final PageCache pageCache;
    private final ConstraintSemantics constraintSemantics;
    private final Procedures procedures;
    private final IOLimiter ioLimiter;
    private final AvailabilityGuard availabilityGuard;
    private final SystemNanoClock clock;
    private final IndexConfigStore indexConfigStore;
    private final ExplicitIndexProvider explicitIndexProvider;
    private final StoreCopyCheckPointMutex storeCopyCheckPointMutex;
    private final CollectionsFactorySupplier collectionsFactorySupplier;
    private Dependencies dataSourceDependencies;
    private LifeSupport life;
    private IndexProviderMap indexProviderMap;
    private File storeDir;
    private boolean readOnly;
    private final IdController idController;
    private final DatabaseInfo databaseInfo;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final VersionContextSupplier versionContextSupplier;
    private final AccessCapability accessCapability;
    private StorageEngine storageEngine;
    private NeoStoreTransactionLogModule transactionLogModule;
    private NeoStoreKernelModule kernelModule;

    public NeoStoreDataSource(File storeDir, Config config, IdGeneratorFactory idGeneratorFactory, LogService logService, JobScheduler scheduler, TokenNameLookup tokenNameLookup, DependencyResolver dependencyResolver, TokenHolders tokenHolders, StatementLocksFactory statementLocksFactory, SchemaWriteGuard schemaWriteGuard, TransactionEventHandlers transactionEventHandlers, IndexingService.Monitor indexingServiceMonitor, FileSystemAbstraction fs, TransactionMonitor transactionMonitor, DatabaseHealth databaseHealth, LogFileCreationMonitor physicalLogMonitor, TransactionHeaderInformationFactory transactionHeaderInformationFactory, CommitProcessFactory commitProcessFactory, AutoIndexing autoIndexing, IndexConfigStore indexConfigStore, ExplicitIndexProvider explicitIndexProvider, PageCache pageCache, ConstraintSemantics constraintSemantics, Monitors monitors, Tracers tracers, Procedures procedures, IOLimiter ioLimiter, AvailabilityGuard availabilityGuard, SystemNanoClock clock, AccessCapability accessCapability, StoreCopyCheckPointMutex storeCopyCheckPointMutex, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IdController idController, DatabaseInfo databaseInfo, VersionContextSupplier versionContextSupplier, CollectionsFactorySupplier collectionsFactorySupplier) {
        this.storeDir = storeDir;
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.tokenNameLookup = tokenNameLookup;
        this.dependencyResolver = dependencyResolver;
        this.scheduler = scheduler;
        this.logService = logService;
        this.autoIndexing = autoIndexing;
        this.indexConfigStore = indexConfigStore;
        this.explicitIndexProvider = explicitIndexProvider;
        this.storeCopyCheckPointMutex = storeCopyCheckPointMutex;
        this.logProvider = logService.getInternalLogProvider();
        this.tokenHolders = tokenHolders;
        this.statementLocksFactory = statementLocksFactory;
        this.schemaWriteGuard = schemaWriteGuard;
        this.transactionEventHandlers = transactionEventHandlers;
        this.indexingServiceMonitor = indexingServiceMonitor;
        this.fs = fs;
        this.transactionMonitor = transactionMonitor;
        this.databaseHealth = databaseHealth;
        this.physicalLogMonitor = physicalLogMonitor;
        this.transactionHeaderInformationFactory = transactionHeaderInformationFactory;
        this.constraintSemantics = constraintSemantics;
        this.monitors = monitors;
        this.tracers = tracers;
        this.procedures = procedures;
        this.ioLimiter = ioLimiter;
        this.availabilityGuard = availabilityGuard;
        this.clock = clock;
        this.accessCapability = accessCapability;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.readOnly = config.get(GraphDatabaseSettings.read_only);
        this.idController = idController;
        this.databaseInfo = databaseInfo;
        this.versionContextSupplier = versionContextSupplier;
        this.msgLog = this.logProvider.getLog(((Object)((Object)this)).getClass());
        this.lockService = new ReentrantLockService();
        this.commitProcessFactory = commitProcessFactory;
        this.pageCache = pageCache;
        this.monitors.addMonitorListener(new LoggingLogFileMonitor(this.msgLog), new String[0]);
        this.collectionsFactorySupplier = collectionsFactorySupplier;
    }

    public void start() throws IOException {
        this.dataSourceDependencies = new Dependencies(this.dependencyResolver);
        this.dataSourceDependencies.satisfyDependency(this.tokenHolders);
        this.life = new LifeSupport();
        this.life.add((Lifecycle)this.recoveryCleanupWorkCollector);
        AllByPrioritySelectionStrategy indexProviderSelection = new AllByPrioritySelectionStrategy();
        IndexProvider defaultIndexProvider = (IndexProvider)this.dependencyResolver.resolveDependency(IndexProvider.class, indexProviderSelection);
        this.indexProviderMap = new DefaultIndexProviderMap(defaultIndexProvider, indexProviderSelection.lowerPrioritizedCandidates());
        this.dataSourceDependencies.satisfyDependency(this.indexProviderMap);
        this.dataSourceDependencies.satisfyDependency(this.lockService);
        this.life.add((Lifecycle)this.indexConfigStore);
        this.life.add(Lifecycles.multiple(this.explicitIndexProvider.allIndexProviders()));
        VersionAwareLogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader = new VersionAwareLogEntryReader<ReadableClosablePositionAwareChannel>();
        LogFiles logFiles = LogFilesBuilder.builder(this.storeDir, this.fs).withLogEntryReader(logEntryReader).withLogFileMonitor(this.physicalLogMonitor).withConfig(this.config).withDependencies(this.dataSourceDependencies).build();
        LogTailScanner tailScanner = new LogTailScanner(logFiles, logEntryReader, this.monitors, this.failOnCorruptedLogFiles);
        this.monitors.addMonitorListener(new LoggingLogTailScannerMonitor(this.logService.getInternalLog(LogTailScanner.class)), new String[0]);
        this.monitors.addMonitorListener(new ReverseTransactionCursorLoggingMonitor(this.logService.getInternalLog(ReversedSingleFileTransactionCursor.class)), new String[0]);
        LogVersionUpgradeChecker.check(tailScanner, this.config);
        RecordFormats formats = NeoStoreDataSource.selectStoreFormats(this.config, this.storeDir, this.fs, this.pageCache, this.logService);
        this.upgradeStore(formats, tailScanner);
        StorageEngine storageEngine = null;
        try {
            DatabaseSchemaState databaseSchemaState = new DatabaseSchemaState(this.logProvider);
            SynchronizedArrayIdOrderingQueue explicitIndexTransactionOrdering = new SynchronizedArrayIdOrderingQueue(20);
            Supplier<KernelTransactionsSnapshot> transactionsSnapshotSupplier = () -> this.kernelModule.kernelTransactions().get();
            this.idController.initialize(transactionsSnapshotSupplier);
            storageEngine = this.buildStorageEngine(this.explicitIndexProvider, this.indexConfigStore, databaseSchemaState, explicitIndexTransactionOrdering, this.databaseInfo.operationalMode, this.versionContextSupplier);
            this.life.add((Lifecycle)logFiles);
            TransactionIdStore transactionIdStore = (TransactionIdStore)this.dataSourceDependencies.resolveDependency(TransactionIdStore.class);
            this.versionContextSupplier.init(transactionIdStore::getLastClosedTransactionId);
            LogVersionRepository logVersionRepository = (LogVersionRepository)this.dataSourceDependencies.resolveDependency(LogVersionRepository.class);
            NeoStoreTransactionLogModule transactionLogModule = this.buildTransactionLogs(logFiles, this.config, this.logProvider, this.scheduler, storageEngine, logEntryReader, explicitIndexTransactionOrdering, transactionIdStore);
            transactionLogModule.satisfyDependencies(this.dataSourceDependencies);
            this.buildRecovery(this.fs, transactionIdStore, tailScanner, this.monitors.newMonitor(RecoveryMonitor.class, new String[0]), this.monitors.newMonitor(RecoveryStartInformationProvider.Monitor.class, new String[0]), logFiles, storageEngine, transactionLogModule.logicalTransactionStore(), logVersionRepository);
            NodePropertyAccessor nodePropertyAccessor = (NodePropertyAccessor)this.dataSourceDependencies.resolveDependency(NodePropertyAccessor.class);
            NeoStoreKernelModule kernelModule = this.buildKernel(logFiles, transactionLogModule.transactionAppender(), (IndexingService)this.dataSourceDependencies.resolveDependency(IndexingService.class), databaseSchemaState, (LabelScanStore)this.dataSourceDependencies.resolveDependency(LabelScanStore.class), storageEngine, this.indexConfigStore, transactionIdStore, this.availabilityGuard, this.clock, nodePropertyAccessor);
            kernelModule.satisfyDependencies(this.dataSourceDependencies);
            this.storageEngine = storageEngine;
            this.transactionLogModule = transactionLogModule;
            this.kernelModule = kernelModule;
            this.dataSourceDependencies.satisfyDependency(this);
            this.dataSourceDependencies.satisfyDependency(databaseSchemaState);
            this.dataSourceDependencies.satisfyDependency(logEntryReader);
            this.dataSourceDependencies.satisfyDependency(storageEngine);
            this.dataSourceDependencies.satisfyDependency(this.explicitIndexProvider);
        }
        catch (Throwable e) {
            this.msgLog.warn("Exception occurred while setting up store modules. Attempting to close things down.", e);
            try {
                if (storageEngine != null) {
                    storageEngine.forceClose();
                }
            }
            catch (Exception closeException) {
                this.msgLog.error("Couldn't close neostore after startup failure", (Throwable)closeException);
            }
            Exceptions.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        this.life.add((Lifecycle)new DatabaseDiagnostics((DiagnosticsManager)this.dataSourceDependencies.resolveDependency(DiagnosticsManager.class), this, this.databaseInfo));
        this.life.setLast(this.lifecycleToTriggerCheckPointOnShutdown());
        try {
            this.life.start();
        }
        catch (Throwable e) {
            this.msgLog.warn("Exception occurred while starting the datasource. Attempting to close things down.", e);
            try {
                this.life.shutdown();
                storageEngine.forceClose();
            }
            catch (Exception closeException) {
                this.msgLog.error("Couldn't close neostore after startup failure", (Throwable)closeException);
            }
            throw new RuntimeException(e);
        }
        this.databaseHealth.healed();
    }

    private static RecordFormats selectStoreFormats(Config config, File storeDir, FileSystemAbstraction fs, PageCache pageCache, LogService logService) {
        LogProvider logging = logService.getInternalLogProvider();
        RecordFormats formats = RecordFormatSelector.selectNewestFormat(config, storeDir, fs, pageCache, logging);
        new RecordFormatPropertyConfigurator(formats, config).configure();
        return formats;
    }

    private void upgradeStore(RecordFormats format, LogTailScanner tailScanner) {
        VisibleMigrationProgressMonitor progressMonitor = new VisibleMigrationProgressMonitor(this.logService.getUserLog(StoreMigrator.class));
        new DatabaseMigrator(progressMonitor, this.fs, this.config, this.logService, this.indexProviderMap, this.explicitIndexProvider, this.pageCache, format, tailScanner).migrate(this.storeDir);
    }

    private StorageEngine buildStorageEngine(ExplicitIndexProvider explicitIndexProviderLookup, IndexConfigStore indexConfigStore, SchemaState schemaState, SynchronizedArrayIdOrderingQueue explicitIndexTransactionOrdering, OperationalMode operationalMode, VersionContextSupplier versionContextSupplier) {
        RecordStorageEngine storageEngine = new RecordStorageEngine(this.storeDir, this.config, this.pageCache, this.fs, this.logProvider, this.tokenHolders, schemaState, this.constraintSemantics, this.scheduler, this.tokenNameLookup, this.lockService, this.indexProviderMap, this.indexingServiceMonitor, this.databaseHealth, explicitIndexProviderLookup, indexConfigStore, explicitIndexTransactionOrdering, this.idGeneratorFactory, this.idController, this.monitors, this.recoveryCleanupWorkCollector, operationalMode, versionContextSupplier);
        storageEngine.satisfyDependencies(this.dataSourceDependencies);
        return (StorageEngine)this.life.add((Lifecycle)storageEngine);
    }

    private NeoStoreTransactionLogModule buildTransactionLogs(LogFiles logFiles, Config config, LogProvider logProvider, JobScheduler scheduler, StorageEngine storageEngine, LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader, SynchronizedArrayIdOrderingQueue explicitIndexTransactionOrdering, TransactionIdStore transactionIdStore) {
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache(100000);
        if (config.get(GraphDatabaseSettings.ephemeral).booleanValue()) {
            config.augmentDefaults(GraphDatabaseSettings.keep_logical_logs, "1 files");
        }
        LogPruningImpl logPruning = new LogPruningImpl(this.fs, logFiles, logProvider, new LogPruneStrategyFactory(), (Clock)this.clock, config);
        LogRotationImpl logRotation = new LogRotationImpl(this.monitors.newMonitor(LogRotation.Monitor.class, new String[0]), logFiles, this.databaseHealth);
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(logFiles, logRotation, transactionMetadataCache, transactionIdStore, explicitIndexTransactionOrdering, this.databaseHealth));
        PhysicalLogicalTransactionStore logicalTransactionStore = new PhysicalLogicalTransactionStore(logFiles, transactionMetadataCache, logEntryReader, this.monitors, this.failOnCorruptedLogFiles);
        CheckPointThreshold threshold = CheckPointThreshold.createThreshold(config, (Clock)this.clock, logPruning, logProvider);
        CheckPointerImpl checkPointer = new CheckPointerImpl(transactionIdStore, threshold, storageEngine, logPruning, appender, this.databaseHealth, logProvider, this.tracers.checkPointTracer, this.ioLimiter, this.storeCopyCheckPointMutex);
        long recurringPeriod = threshold.checkFrequencyMillis();
        CheckPointScheduler checkPointScheduler = new CheckPointScheduler(checkPointer, this.ioLimiter, scheduler, recurringPeriod, this.databaseHealth);
        this.life.add((Lifecycle)checkPointer);
        this.life.add((Lifecycle)checkPointScheduler);
        return new NeoStoreTransactionLogModule(logicalTransactionStore, logFiles, logRotation, checkPointer, appender, explicitIndexTransactionOrdering);
    }

    private void buildRecovery(FileSystemAbstraction fileSystemAbstraction, TransactionIdStore transactionIdStore, LogTailScanner tailScanner, RecoveryMonitor recoveryMonitor, RecoveryStartInformationProvider.Monitor positionMonitor, LogFiles logFiles, StorageEngine storageEngine, LogicalTransactionStore logicalTransactionStore, LogVersionRepository logVersionRepository) {
        DefaultRecoveryService recoveryService = new DefaultRecoveryService(storageEngine, tailScanner, transactionIdStore, logicalTransactionStore, logVersionRepository, positionMonitor);
        CorruptedLogsTruncator logsTruncator = new CorruptedLogsTruncator(this.storeDir, logFiles, fileSystemAbstraction);
        LogProgressReporter progressReporter = new LogProgressReporter(this.logService.getInternalLog(Recovery.class));
        Recovery recovery = new Recovery(recoveryService, logsTruncator, recoveryMonitor, progressReporter, this.failOnCorruptedLogFiles);
        this.life.add((Lifecycle)recovery);
    }

    private NeoStoreKernelModule buildKernel(LogFiles logFiles, TransactionAppender appender, IndexingService indexingService, DatabaseSchemaState databaseSchemaState, LabelScanStore labelScanStore, StorageEngine storageEngine, IndexConfigStore indexConfigStore, TransactionIdStore transactionIdStore, AvailabilityGuard availabilityGuard, SystemNanoClock clock, NodePropertyAccessor nodePropertyAccessor) {
        AtomicReference<CpuClock> cpuClockRef = this.setupCpuClockAtomicReference();
        AtomicReference<HeapAllocation> heapAllocationRef = this.setupHeapAllocationAtomicReference();
        TransactionCommitProcess transactionCommitProcess = this.commitProcessFactory.create(appender, storageEngine, this.config);
        Supplier<Kernel> kernelProvider = () -> this.kernelModule.kernelAPI();
        ConstraintIndexCreator constraintIndexCreator = new ConstraintIndexCreator(kernelProvider, indexingService, nodePropertyAccessor, this.logProvider);
        ExplicitIndexStore explicitIndexStore = new ExplicitIndexStore(this.config, indexConfigStore, kernelProvider, this.explicitIndexProvider);
        StatementOperationParts statementOperationParts = this.dataSourceDependencies.satisfyDependency(this.buildStatementOperations(cpuClockRef, heapAllocationRef));
        TransactionHooks hooks = new TransactionHooks();
        KernelTransactions kernelTransactions = (KernelTransactions)this.life.add((Lifecycle)new KernelTransactions(this.statementLocksFactory, constraintIndexCreator, statementOperationParts, this.schemaWriteGuard, this.transactionHeaderInformationFactory, transactionCommitProcess, indexConfigStore, this.explicitIndexProvider, hooks, this.transactionMonitor, availabilityGuard, this.tracers, storageEngine, this.procedures, transactionIdStore, clock, cpuClockRef, heapAllocationRef, this.accessCapability, this.autoIndexing, explicitIndexStore, this.versionContextSupplier, this.collectionsFactorySupplier, this.constraintSemantics, databaseSchemaState, indexingService, this.tokenHolders, this.dataSourceDependencies));
        this.buildTransactionMonitor(kernelTransactions, (Clock)clock, this.config);
        KernelImpl kernel = new KernelImpl(kernelTransactions, hooks, this.databaseHealth, this.transactionMonitor, this.procedures, this.config);
        kernel.registerTransactionHook(this.transactionEventHandlers);
        this.life.add((Lifecycle)kernel);
        NeoStoreFileListing fileListing = new NeoStoreFileListing(this.storeDir, logFiles, labelScanStore, indexingService, this.explicitIndexProvider, storageEngine);
        this.dataSourceDependencies.satisfyDependency(fileListing);
        return new NeoStoreKernelModule(transactionCommitProcess, kernel, kernelTransactions, fileListing);
    }

    private AtomicReference<CpuClock> setupCpuClockAtomicReference() {
        AtomicReference<CpuClock> cpuClock = new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE);
        BiConsumer<Boolean, Boolean> cpuClockUpdater = (before, after) -> {
            if (after.booleanValue()) {
                cpuClock.set(CpuClock.CPU_CLOCK);
            } else {
                cpuClock.set(CpuClock.NOT_AVAILABLE);
            }
        };
        cpuClockUpdater.accept(null, this.config.get(GraphDatabaseSettings.track_query_cpu_time));
        this.config.registerDynamicUpdateListener(GraphDatabaseSettings.track_query_cpu_time, cpuClockUpdater);
        return cpuClock;
    }

    private AtomicReference<HeapAllocation> setupHeapAllocationAtomicReference() {
        AtomicReference<HeapAllocation> heapAllocation = new AtomicReference<HeapAllocation>(HeapAllocation.NOT_AVAILABLE);
        BiConsumer<Boolean, Boolean> heapAllocationUpdater = (before, after) -> {
            if (after.booleanValue()) {
                heapAllocation.set(HeapAllocation.HEAP_ALLOCATION);
            } else {
                heapAllocation.set(HeapAllocation.NOT_AVAILABLE);
            }
        };
        heapAllocationUpdater.accept(null, this.config.get(GraphDatabaseSettings.track_query_allocation));
        this.config.registerDynamicUpdateListener(GraphDatabaseSettings.track_query_allocation, heapAllocationUpdater);
        return heapAllocation;
    }

    private void buildTransactionMonitor(KernelTransactions kernelTransactions, Clock clock, Config config) {
        KernelTransactionTimeoutMonitor kernelTransactionTimeoutMonitor = new KernelTransactionTimeoutMonitor(kernelTransactions, clock, this.logService);
        this.dataSourceDependencies.satisfyDependency(kernelTransactionTimeoutMonitor);
        KernelTransactionMonitorScheduler transactionMonitorScheduler = new KernelTransactionMonitorScheduler(kernelTransactionTimeoutMonitor, this.scheduler, config.get(GraphDatabaseSettings.transaction_monitor_check_interval).toMillis());
        this.life.add((Lifecycle)transactionMonitorScheduler);
    }

    public synchronized void stop() {
        if (!this.life.isRunning()) {
            return;
        }
        this.life.stop();
        this.awaitAllClosingTransactions();
        this.life.shutdown();
    }

    private void awaitAllClosingTransactions() {
        KernelTransactions kernelTransactions = this.kernelModule.kernelTransactions();
        kernelTransactions.terminateTransactions();
        while (kernelTransactions.haveClosingTransaction()) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }

    private Lifecycle lifecycleToTriggerCheckPointOnShutdown() {
        return new LifecycleAdapter(){

            public void shutdown() throws IOException {
                if (NeoStoreDataSource.this.databaseHealth.isHealthy()) {
                    NeoStoreDataSource.this.transactionLogModule.checkPointing().forceCheckPoint(new SimpleTriggerInfo("database shutdown"));
                }
            }
        };
    }

    public StoreId getStoreId() {
        return this.storageEngine.getStoreId();
    }

    public File getStoreDir() {
        return this.storeDir;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public InwardKernel getKernel() {
        return this.kernelModule.kernelAPI();
    }

    public ResourceIterator<StoreFileMetadata> listStoreFiles(boolean includeLogs) throws IOException {
        NeoStoreFileListing.StoreFileListingBuilder fileListingBuilder = this.getNeoStoreFileListing().builder();
        if (!includeLogs) {
            fileListingBuilder.excludeLogFiles();
        }
        return fileListingBuilder.build();
    }

    public NeoStoreFileListing getNeoStoreFileListing() {
        return this.kernelModule.fileListing();
    }

    public void registerDiagnosticsWith(DiagnosticsManager manager) {
        this.storageEngine.registerDiagnostics(manager);
        manager.registerAll(Diagnostics.class, this);
    }

    public DependencyResolver getDependencyResolver() {
        return this.dataSourceDependencies;
    }

    private StatementOperationParts buildStatementOperations(AtomicReference<CpuClock> cpuClockRef, AtomicReference<HeapAllocation> heapAllocationRef) {
        StackingQueryRegistrationOperations queryRegistrationOperations = new StackingQueryRegistrationOperations(this.clock, cpuClockRef, heapAllocationRef);
        return new StatementOperationParts(queryRegistrationOperations);
    }

    public void beforeModeSwitch() {
        this.clearTransactions();
    }

    private void clearTransactions() {
        this.storageEngine.clearBufferedIds();
        this.kernelModule.kernelTransactions().disposeAll();
    }

    public void afterModeSwitch() {
        this.storageEngine.loadSchemaCache();
        this.clearTransactions();
    }

    public StoreCopyCheckPointMutex getStoreCopyCheckPointMutex() {
        return this.storeCopyCheckPointMutex;
    }

    @VisibleForTesting
    public LifeSupport getLife() {
        return this.life;
    }

    static enum Diagnostics implements DiagnosticsExtractor<NeoStoreDataSource>
    {
        TRANSACTION_RANGE("Transaction log:"){

            @Override
            void dump(NeoStoreDataSource source, Logger log) {
                LogFiles logFiles = (LogFiles)source.getDependencyResolver().resolveDependency(LogFiles.class);
                try {
                    long logVersion = logFiles.getLowestLogVersion();
                    while (logFiles.versionExists(logVersion)) {
                        if (logFiles.hasAnyEntries(logVersion)) {
                            LogHeader header = logFiles.extractHeader(logVersion);
                            long firstTransactionIdInThisLog = header.lastCommittedTxId + 1L;
                            log.log("Oldest transaction " + firstTransactionIdInThisLog + " found in log with version " + logVersion);
                            return;
                        }
                        ++logVersion;
                    }
                    log.log("No transactions found in any log");
                }
                catch (IOException e) {
                    log.log("Error trying to figure out oldest transaction in log");
                }
            }
        };

        private final String message;

        private Diagnostics(String message) {
            this.message = message;
        }

        @Override
        public void dumpDiagnostics(NeoStoreDataSource source, DiagnosticsPhase phase, Logger logger) {
            if (this.applicable(phase)) {
                logger.log(this.message);
                this.dump(source, logger);
            }
        }

        boolean applicable(DiagnosticsPhase phase) {
            return phase.isInitialization() || phase.isExplicitlyRequested();
        }

        abstract void dump(NeoStoreDataSource var1, Logger var2);
    }
}

