/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import org.neo4j.string.UTF8;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.CollisionValues;

public class StringCollisionValues
implements CollisionValues {
    private final long chunkSize;
    private final ByteArray cache;
    private long offset;
    private ByteArray current;

    public StringCollisionValues(NumberArrayFactory factory, long length) {
        this.chunkSize = Long.max(length, 10000L);
        this.cache = factory.newDynamicByteArray(this.chunkSize, new byte[1]);
        this.current = (ByteArray)this.cache.at(0L);
    }

    @Override
    public long add(Object id) {
        String string = (String)id;
        byte[] bytes = UTF8.encode((String)string);
        int length = bytes.length;
        if (length > 65535) {
            throw new IllegalArgumentException(string);
        }
        long bytesLeftInThisChunk = this.bytesLeftInCurrentChunk();
        if (bytesLeftInThisChunk < 3L) {
            this.offset += this.chunkSize - this.offset % this.chunkSize;
            this.current = (ByteArray)this.cache.at(this.offset);
        }
        long startOffset = this.offset;
        this.current.setShort(this.offset, 0, (short)length);
        this.offset += 2L;
        int i = 0;
        while (i < length) {
            int bytesLeftToWrite = length - i;
            int bytesLeftInChunk = (int)(this.chunkSize - this.offset % this.chunkSize);
            int bytesToWriteInThisChunk = Integer.min(bytesLeftToWrite, bytesLeftInChunk);
            for (int j = 0; j < bytesToWriteInThisChunk; ++j) {
                this.current.setByte(this.offset++, 0, bytes[i++]);
            }
            if (length <= i) continue;
            this.current = (ByteArray)this.cache.at(this.offset);
        }
        return startOffset;
    }

    private long bytesLeftInCurrentChunk() {
        long rest = this.offset % this.chunkSize;
        return rest == 0L ? 0L : this.chunkSize - rest;
    }

    @Override
    public Object get(long offset) {
        ByteArray array = (ByteArray)this.cache.at(offset);
        int length = array.getShort(offset, 0) & 0xFFFF;
        offset += 2L;
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < length) {
            int bytesLeftToRead = length - i;
            int bytesLeftInChunk = (int)(this.chunkSize - offset % this.chunkSize);
            int bytesToReadInThisChunk = Integer.min(bytesLeftToRead, bytesLeftInChunk);
            for (int j = 0; j < bytesToReadInThisChunk; ++j) {
                bytes[i++] = array.getByte(offset++, 0);
            }
            if (length <= i) continue;
            array = (ByteArray)this.cache.at(offset);
        }
        return UTF8.decode((byte[])bytes);
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        this.cache.acceptMemoryStatsVisitor(visitor);
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

