/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.StoreIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NativeIndexes;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;

abstract class NativeIndexProvider<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends IndexProvider {
    protected final PageCache pageCache;
    protected final FileSystemAbstraction fs;
    protected final IndexProvider.Monitor monitor;
    protected final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    protected final boolean readOnly;

    protected NativeIndexProvider(IndexProvider.Descriptor descriptor, int priority, IndexDirectoryStructure.Factory directoryStructureFactory, PageCache pageCache, FileSystemAbstraction fs, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(descriptor, priority, directoryStructureFactory);
        this.pageCache = pageCache;
        this.fs = fs;
        this.monitor = monitor;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.readOnly = readOnly;
    }

    abstract Layout<KEY, VALUE> layout(StoreIndexDescriptor var1);

    @Override
    public IndexPopulator getPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        File storeFile = this.nativeIndexFileFromIndexId(descriptor.getId());
        return this.newIndexPopulator(storeFile, this.layout(descriptor), descriptor, samplingConfig);
    }

    protected abstract IndexPopulator newIndexPopulator(File var1, Layout<KEY, VALUE> var2, StoreIndexDescriptor var3, IndexSamplingConfig var4);

    @Override
    public IndexAccessor getOnlineAccessor(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        File storeFile = this.nativeIndexFileFromIndexId(descriptor.getId());
        return this.newIndexAccessor(storeFile, this.layout(descriptor), descriptor, samplingConfig);
    }

    protected abstract IndexAccessor newIndexAccessor(File var1, Layout<KEY, VALUE> var2, StoreIndexDescriptor var3, IndexSamplingConfig var4) throws IOException;

    @Override
    public String getPopulationFailure(StoreIndexDescriptor descriptor) throws IllegalStateException {
        try {
            String failureMessage = NativeIndexes.readFailureMessage(this.pageCache, this.nativeIndexFileFromIndexId(descriptor.getId()));
            if (failureMessage == null) {
                throw new IllegalStateException("Index " + descriptor.getId() + " isn't failed");
            }
            return failureMessage;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InternalIndexState getInitialState(StoreIndexDescriptor descriptor) {
        try {
            return NativeIndexes.readState(this.pageCache, this.nativeIndexFileFromIndexId(descriptor.getId()));
        }
        catch (IOException | MetadataMismatchException e) {
            this.monitor.failedToOpenIndex(descriptor, "Requesting re-population.", (Exception)e);
            return InternalIndexState.POPULATING;
        }
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    private File nativeIndexFileFromIndexId(long indexId) {
        return new File(this.directoryStructure().directoryForIndex(indexId), NativeIndexProvider.indexFileName(indexId));
    }

    private static String indexFileName(long indexId) {
        return "index-" + indexId;
    }
}

