/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.store.TemporalValueWriterAdapter;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;

abstract class NativeIndexKey<SELF extends NativeIndexKey<SELF>>
extends TemporalValueWriterAdapter<RuntimeException> {
    private static final boolean DEFAULT_COMPARE_ID = true;
    private long entityId;
    private boolean compareId = true;

    NativeIndexKey() {
    }

    void setCompareId(boolean compareId) {
        this.compareId = compareId;
    }

    boolean getCompareId() {
        return this.compareId;
    }

    long getEntityId() {
        return this.entityId;
    }

    void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    final void from(long entityId, Value ... values) {
        this.initialize(entityId);
        this.assertValidValue(values).writeTo((ValueWriter)this);
    }

    void initialize(long entityId) {
        this.compareId = true;
        this.entityId = entityId;
    }

    private Value assertValidValue(Value ... values) {
        if (values.length > 1) {
            throw new IllegalArgumentException("Tried to create composite key with non-composite schema key layout");
        }
        if (values.length < 1) {
            throw new IllegalArgumentException("Tried to create key without value");
        }
        return this.assertCorrectType(values[0]);
    }

    protected abstract Value assertCorrectType(Value var1);

    String propertiesAsString() {
        return this.asValue().toString();
    }

    abstract Value asValue();

    final void initAsLowest() {
        this.initialize(Long.MIN_VALUE);
        this.initValueAsLowest();
    }

    abstract void initValueAsLowest();

    final void initAsHighest() {
        this.initialize(Long.MAX_VALUE);
        this.initValueAsHighest();
    }

    abstract void initValueAsHighest();

    abstract int compareValueTo(SELF var1);
}

