/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.DateIndexKey;
import org.neo4j.kernel.impl.index.schema.IndexLayout;

class DateLayout
extends IndexLayout<DateIndexKey> {
    DateLayout() {
        super("Tda", 0, 1);
    }

    public DateIndexKey newKey() {
        return new DateIndexKey();
    }

    public DateIndexKey copyKey(DateIndexKey key, DateIndexKey into) {
        into.epochDay = key.epochDay;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    public int keySize(DateIndexKey key) {
        return 16;
    }

    public void writeKey(PageCursor cursor, DateIndexKey key) {
        cursor.putLong(key.epochDay);
        cursor.putLong(key.getEntityId());
    }

    public void readKey(PageCursor cursor, DateIndexKey into, int keySize) {
        into.epochDay = cursor.getLong();
        into.setEntityId(cursor.getLong());
    }
}

